/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryEngineRegistry;
import com.hp.hpl.jena.sparql.engine.QueryExecutionBase;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.util.FileManager;
import java.util.List;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;

public class QueryExecutionFactory {
    protected QueryExecutionFactory() {
    }

    public static QueryExecution create(Query query2) {
        QueryExecutionFactory.checkArg(query2);
        return QueryExecutionFactory.make(query2);
    }

    public static QueryExecution create(String queryStr) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr));
    }

    public static QueryExecution create(String queryStr, Syntax syntax) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax));
    }

    public static QueryExecution create(Query query2, Dataset dataset) {
        return QueryExecutionFactory.make(query2, dataset);
    }

    public static QueryExecution create(String queryStr, Dataset dataset) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.make(QueryExecutionFactory.makeQuery(queryStr), dataset);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, Dataset dataset) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.make(QueryExecutionFactory.makeQuery(queryStr, syntax), dataset);
    }

    public static QueryExecution create(Query query2, FileManager fm) {
        QueryExecutionFactory.checkArg(query2);
        QueryExecution qe = QueryExecutionFactory.make(query2);
        if (fm != null) {
            qe.setFileManager(fm);
        }
        return qe;
    }

    public static QueryExecution create(String queryStr, FileManager fm) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), fm);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, FileManager fm) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), fm);
    }

    public static QueryExecution create(Query query2, Model model) {
        QueryExecutionFactory.checkArg(query2);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.make(query2, DatasetFactory.create(model));
    }

    public static QueryExecution create(String queryStr, Model model) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), model);
    }

    public static QueryExecution create(String queryStr, Syntax lang, Model model) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, lang), model);
    }

    public static QueryExecution create(Query query2, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(query2);
        QueryExecution qe = QueryExecutionFactory.make(query2);
        if (initialBinding != null) {
            qe.setInitialBinding(initialBinding);
        }
        return qe;
    }

    public static QueryExecution create(String queryStr, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), initialBinding);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), initialBinding);
    }

    public static QueryExecution create(Query query2, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(query2, DatasetFactory.create(model), initialBinding);
    }

    public static QueryExecution create(String queryStr, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), model, initialBinding);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), model, initialBinding);
    }

    public static QueryExecution create(Query query2, Dataset dataset, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(query2);
        QueryExecution qe = QueryExecutionFactory.make(query2, dataset);
        if (initialBinding != null) {
            qe.setInitialBinding(initialBinding);
        }
        return qe;
    }

    public static QueryExecution create(String queryStr, Dataset dataset, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), dataset, initialBinding);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, Dataset dataset, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), dataset, initialBinding);
    }

    public static QueryExecution sparqlService(String service, String query2) {
        return QueryExecutionFactory.sparqlService(service, query2, (HttpAuthenticator)null);
    }

    public static QueryExecution sparqlService(String service, String query2, HttpAuthenticator authenticator) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query2);
        return QueryExecutionFactory.sparqlService(service, QueryFactory.create(query2), authenticator);
    }

    public static QueryExecution sparqlService(String service, String query2, String defaultGraph) {
        return QueryExecutionFactory.sparqlService(service, query2, defaultGraph, null);
    }

    public static QueryExecution sparqlService(String service, String query2, String defaultGraph, HttpAuthenticator authenticator) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query2);
        return QueryExecutionFactory.sparqlService(service, QueryFactory.create(query2), defaultGraph, authenticator);
    }

    public static QueryExecution sparqlService(String service, String query2, List<String> defaultGraphURIs, List<String> namedGraphURIs) {
        return QueryExecutionFactory.sparqlService(service, query2, defaultGraphURIs, namedGraphURIs, null);
    }

    public static QueryExecution sparqlService(String service, String query2, List<String> defaultGraphURIs, List<String> namedGraphURIs, HttpAuthenticator authenticator) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query2);
        return QueryExecutionFactory.sparqlService(service, QueryFactory.create(query2), defaultGraphURIs, namedGraphURIs, authenticator);
    }

    public static QueryExecution sparqlService(String service, Query query2) {
        return QueryExecutionFactory.sparqlService(service, query2, (HttpAuthenticator)null);
    }

    public static QueryExecution sparqlService(String service, Query query2, HttpAuthenticator authenticator) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query2);
        return QueryExecutionFactory.createServiceRequest(service, query2, authenticator);
    }

    public static QueryExecution sparqlService(String service, Query query2, List<String> defaultGraphURIs, List<String> namedGraphURIs) {
        return QueryExecutionFactory.sparqlService(service, query2, defaultGraphURIs, namedGraphURIs, null);
    }

    public static QueryExecution sparqlService(String service, Query query2, List<String> defaultGraphURIs, List<String> namedGraphURIs, HttpAuthenticator authenticator) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query2);
        QueryEngineHTTP qe = QueryExecutionFactory.createServiceRequest(service, query2, authenticator);
        if (defaultGraphURIs != null) {
            qe.setDefaultGraphURIs(defaultGraphURIs);
        }
        if (namedGraphURIs != null) {
            qe.setNamedGraphURIs(namedGraphURIs);
        }
        return qe;
    }

    public static QueryExecution sparqlService(String service, Query query2, String defaultGraph) {
        return QueryExecutionFactory.sparqlService(service, query2, defaultGraph, null);
    }

    public static QueryExecution sparqlService(String service, Query query2, String defaultGraph, HttpAuthenticator authenticator) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query2);
        QueryEngineHTTP qe = QueryExecutionFactory.createServiceRequest(service, query2, authenticator);
        qe.addDefaultGraph(defaultGraph);
        return qe;
    }

    public static QueryEngineHTTP createServiceRequest(String service, Query query2) {
        return QueryExecutionFactory.createServiceRequest(service, query2, null);
    }

    public static QueryEngineHTTP createServiceRequest(String service, Query query2, HttpAuthenticator authenticator) {
        QueryEngineHTTP qe = new QueryEngineHTTP(service, query2, authenticator);
        return qe;
    }

    public static Plan createPlan(Query query2, DatasetGraph dataset, Binding input, Context context) {
        return QueryExecutionFactory.makePlan(query2, dataset, input, context);
    }

    public static Plan createPlan(Query query2, DatasetGraph dataset, Binding input) {
        return QueryExecutionFactory.makePlan(query2, dataset, input, null);
    }

    private static Query toQuery(Element pattern) {
        Query query2 = QueryFactory.make();
        query2.setQueryPattern(pattern);
        query2.setQuerySelectType();
        query2.setQueryResultStar(true);
        return query2;
    }

    private static Plan makePlan(Query query2, DatasetGraph dataset, Binding input, Context context) {
        QueryEngineFactory f;
        if (context == null) {
            context = new Context(ARQ.getContext());
        }
        if (input == null) {
            input = BindingRoot.create();
        }
        if ((f = QueryExecutionFactory.findFactory(query2, dataset, context)) == null) {
            return null;
        }
        return f.create(query2, dataset, input, context);
    }

    private static Query makeQuery(String queryStr) {
        return QueryFactory.create(queryStr);
    }

    private static Query makeQuery(String queryStr, Syntax syntax) {
        return QueryFactory.create(queryStr, syntax);
    }

    protected static QueryExecution make(Query query2) {
        return QueryExecutionFactory.make(query2, null);
    }

    protected static QueryExecution make(Query query2, Dataset dataset) {
        return QueryExecutionFactory.make(query2, dataset, null);
    }

    protected static QueryExecution make(Query query2, Dataset dataset, Context context) {
        QueryEngineFactory f;
        query2.setResultVars();
        if (context == null) {
            context = ARQ.getContext();
        }
        DatasetGraph dsg = null;
        if (dataset != null) {
            dsg = dataset.asDatasetGraph();
        }
        if ((f = QueryExecutionFactory.findFactory(query2, dsg, context)) == null) {
            Log.warn(QueryExecutionFactory.class, "Failed to find a QueryEngineFactory for query: " + query2);
            return null;
        }
        return new QueryExecutionBase(query2, dataset, context, f);
    }

    private static QueryEngineFactory findFactory(Query query2, DatasetGraph dataset, Context context) {
        return QueryEngineRegistry.get().find(query2, dataset, context);
    }

    private static void checkNotNull(Object obj, String msg) {
        if (obj == null) {
            throw new IllegalArgumentException(msg);
        }
    }

    private static void checkArg(Model model) {
        QueryExecutionFactory.checkNotNull(model, "Model is a null pointer");
    }

    private static void checkArg(String queryStr) {
        QueryExecutionFactory.checkNotNull(queryStr, "Query string is null");
    }

    private static void checkArg(Query query2) {
        QueryExecutionFactory.checkNotNull(query2, "Query is null");
    }
}

