/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingProject;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterConvert;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRepeatApply;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSingleton;
import com.hp.hpl.jena.sparql.engine.main.OpExecutor;
import java.util.List;

public class QueryIterProject2
extends QueryIterRepeatApply {
    List<Var> projectionVars;
    private final OpProject opProject;
    private final OpExecutor engine;

    public QueryIterProject2(OpProject opProject, QueryIterator input, OpExecutor engine, ExecutionContext execCxt) {
        super(input, execCxt);
        this.opProject = opProject;
        this.engine = engine;
    }

    @Override
    protected QueryIterator nextStage(Binding binding) {
        QueryIterator qIter = this.engine.executeOp(this.opProject.getSubOp(), QueryIterSingleton.create(binding, this.getExecContext()));
        qIter = new ProjectEnsureBinding(qIter, new ProjectEnsureBindingConverter(binding, this.opProject.getVars()), this.getExecContext());
        return qIter;
    }

    static class ProjectEnsureBindingConverter
    implements QueryIterConvert.Converter {
        private final Binding outerBinding;
        private final List<Var> projectionVars;

        public ProjectEnsureBindingConverter(Binding outerBinding, List<Var> vars) {
            this.outerBinding = outerBinding;
            this.projectionVars = vars;
        }

        @Override
        public Binding convert(Binding bind) {
            BindingProject b = new BindingProject(this.projectionVars, bind, this.outerBinding);
            return b;
        }
    }

    static class ProjectEnsureBinding
    extends QueryIterConvert {
        public ProjectEnsureBinding(QueryIterator iter, QueryIterConvert.Converter c, ExecutionContext context) {
            super(iter, c, context);
        }
    }
}

