/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.FetchTxt;
import gov.loc.repository.bagit.FetchTxtReader;
import gov.loc.repository.bagit.FetchTxtWriter;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.utilities.MessageDigestHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FetchTxtImpl
extends ArrayList<FetchTxt.FilenameSizeUrl>
implements FetchTxt {
    private static final Log log = LogFactory.getLog(FetchTxtImpl.class);
    private static final long serialVersionUID = 1L;
    private String name;
    private Bag.BagConstants bagConstants;
    private Bag.BagPartFactory bagPartFactory;
    private BagFile sourceBagFile = null;
    private String originalFixity = null;

    public FetchTxtImpl(Bag.BagConstants bagConstants, Bag.BagPartFactory bagPartFactory) {
        log.info((Object)"Creating new fetch.txt.");
        this.init(bagConstants, bagPartFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FetchTxtImpl(Bag.BagConstants bagConstants, Bag.BagPartFactory bagPartFactory, BagFile sourceBagFile) {
        log.info((Object)"Creating fetch.txt.");
        this.init(bagConstants, bagPartFactory);
        this.sourceBagFile = sourceBagFile;
        FetchTxtReader reader = bagPartFactory.createFetchTxtReader(sourceBagFile.newInputStream(), this.bagConstants.getBagEncoding());
        try {
            while (reader.hasNext()) {
                this.add(reader.next());
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)reader);
        }
        this.originalFixity = MessageDigestHelper.generateFixity(this.generatedInputStream(), Manifest.Algorithm.MD5);
    }

    private void init(Bag.BagConstants bagConstants, Bag.BagPartFactory bagPartFactory) {
        this.name = bagConstants.getFetchTxt();
        this.bagConstants = bagConstants;
        this.bagPartFactory = bagPartFactory;
    }

    @Override
    public InputStream newInputStream() {
        if (MessageDigestHelper.fixityMatches(this.generatedInputStream(), Manifest.Algorithm.MD5, this.originalFixity)) {
            return this.sourceBagFile.newInputStream();
        }
        return this.generatedInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream generatedInputStream() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FetchTxtWriter writer = this.bagPartFactory.createFetchTxtWriter(out);
        try {
            for (FetchTxt.FilenameSizeUrl filenameSizeUrl : this) {
                writer.write(filenameSizeUrl.getFilename(), filenameSizeUrl.getSize(), filenameSizeUrl.getUrl());
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)writer);
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    @Override
    public String getFilepath() {
        return this.name;
    }

    @Override
    public long getSize() {
        InputStream in = this.newInputStream();
        long size = 0L;
        try {
            while (in.read() != -1) {
                ++size;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return size;
    }

    @Override
    public boolean exists() {
        return true;
    }
}

