/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ecoinformatics.datamanager.database.DatabaseAdapter;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.AttributeList;
import org.ecoinformatics.datamanager.parser.DateTimeDomain;
import org.ecoinformatics.datamanager.parser.Domain;
import org.ecoinformatics.datamanager.parser.EnumeratedDomain;
import org.ecoinformatics.datamanager.parser.NumericDomain;
import org.ecoinformatics.datamanager.parser.TextDomain;

public class PostgresAdapter
extends DatabaseAdapter {
    public static final String AND = "AND";
    public static final String BOOLEAN = "Boolean";
    public static final String CREATETABLE = "CREATE TABLE";
    public static final String DATETIME = "Timestamp";
    public static final String DELETE = "DELETE";
    public static final String DOUBLE = "Double";
    public static final String DROPTABLE = "DROP TABLE";
    public static final String FLOAT = "Float";
    public static final String FROM = "FROM";
    public static final String INTEGER = "Integer";
    public static final String LIKE = "LIKE";
    public static final String LONG = "Long";
    public static final String QUESTION = "?";
    public static final String QUOTE = "\"";
    public static final String SELECT = "SELECT";
    public static final String STRING = "String";
    public static final String WHERE = "WHERE";
    private static final String[][] datetimeTransformationTable = new String[][]{{"YYYY-MM-DDThh:mm:ss", "YYYY-MM-DD HH24:MI:ss"}, {"YYYY-MM-DD hh:mm:ss", "YYYY-MM-DD HH24:MI:ss"}, {"YYYY-MM-DDThh:mm", "YYYY-MM-DD HH24:MI"}, {"YYYY-MM-DD hh:mm", "YYYY-MM-DD HH24:MI"}, {"hh:mm:ss", "HH24:MI:ss"}, {"hh:mm", "HH24:MI"}, {"hhmm", "HH24MI"}, {"hh:mm:ss.sss", "HH24:MI:ss.sss"}, {"hh:mm:ss.ss", "HH24:MI:ss.ss"}, {"hh:mm:ss.s", "HH24:MI:ss.s"}, {"YYYY-WWW-DD", "YYYY-Mon-DD"}, {"YYYY/WWW/DD", "YYYY/Mon/DD"}, {"DD WWW YYYY", "DD Mon YYYY"}, {"YYYYWWWDD", "YYYYMonDD"}};

    public PostgresAdapter() {
        this.TO_DATE_FUNCTION = "to_timestamp";
    }

    @Override
    public String generateDDL(AttributeList attributeList, String tableName) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CREATETABLE);
        stringBuffer.append(" ");
        stringBuffer.append(tableName);
        stringBuffer.append("(");
        String attributeSQL = this.parseAttributeList(attributeList);
        stringBuffer.append(attributeSQL);
        stringBuffer.append(")");
        stringBuffer.append(";");
        String sqlStr = stringBuffer.toString();
        return sqlStr;
    }

    @Override
    public String generateDropTableSQL(String tableName) {
        String sqlString = "DROP TABLE " + tableName + " " + ";";
        return sqlString;
    }

    @Override
    protected String getAttributeType(Attribute attribute) {
        String attributeType = null;
        attributeType = attribute.getAttributeType();
        if (attributeType != null) {
            return attributeType;
        }
        String className = this.getClass().getName();
        attributeType = this.getAttributeTypeFromStorageType(attribute, className);
        if (attributeType != null) {
            attribute.setAttributeType(attributeType);
            return attributeType;
        }
        attributeType = "string";
        Domain domain = attribute.getDomain();
        if (domain instanceof DateTimeDomain) {
            attributeType = "datetime";
        } else if (domain instanceof EnumeratedDomain || domain instanceof TextDomain) {
            attributeType = "string";
        } else if (domain instanceof NumericDomain) {
            NumericDomain numericDomain = (NumericDomain)domain;
            attributeType = numericDomain.getNumberType();
        }
        if (attribute != null) {
            attribute.setAttributeType(attributeType);
        }
        return attributeType;
    }

    @Override
    protected String mapDataType(String attributeType) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("string", "TEXT");
        map.put("integer", "INTEGER");
        map.put("real", "FLOAT");
        map.put("whole", "INTEGER");
        map.put("natural", "INTEGER");
        map.put("datetime", "TIMESTAMP");
        String dbDataType = (String)map.get(attributeType.toLowerCase());
        return dbDataType;
    }

    @Override
    protected String transformDatetime(String datetimeString) {
        Pattern pattern;
        Matcher matcher;
        if (datetimeString != null && (matcher = (pattern = Pattern.compile(".+\\d+T\\d+.+")).matcher(datetimeString)).matches()) {
            datetimeString = datetimeString.replace('T', ' ');
        }
        return datetimeString;
    }

    @Override
    protected String transformFormatString(String emlFormatString) {
        String pgFormatString = emlFormatString;
        for (int i = 0; i < datetimeTransformationTable.length; ++i) {
            String emlFormat = datetimeTransformationTable[i][0];
            String pgFormat = datetimeTransformationTable[i][1];
            String emlFormatZulu = emlFormat + "Z";
            if (!emlFormatString.equalsIgnoreCase(emlFormat) && !emlFormatString.equalsIgnoreCase(emlFormatZulu)) continue;
            pgFormatString = pgFormat;
            break;
        }
        return pgFormatString;
    }

    @Override
    public String transformSelectionSQL(String ANSISQL) {
        String sqlString = "";
        return sqlString;
    }

    @Override
    public String getCountingRowNumberSQL(String tableName) {
        String selectString = "SELECT COUNT(*) FROM " + tableName;
        return selectString;
    }
}

