/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.foresite.jena;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.dspace.foresite.OREException;
import org.dspace.foresite.OREParser;
import org.dspace.foresite.OREParserException;
import org.dspace.foresite.ResourceMap;
import org.dspace.foresite.jena.JenaOREFactory;
import org.dspace.foresite.jena.ORE;

public class JenaOREParser
implements OREParser {
    private String type = "RDF/XML";

    public ResourceMap parse(InputStream is) throws OREParserException {
        try {
            Model model = this.parseToModel(is);
            SimpleSelector selector = new SimpleSelector(null, ORE.describes, (RDFNode)null);
            StmtIterator itr = model.listStatements((Selector)selector);
            if (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                Resource resource = statement.getSubject();
                ResourceMap rem = JenaOREFactory.createResourceMap(model, new URI(resource.getURI()));
                return rem;
            }
            return null;
        }
        catch (URISyntaxException e) {
            throw new OREParserException(e);
        }
        catch (OREException e) {
            throw new OREParserException(e);
        }
    }

    public ResourceMap parse(InputStream is, URI uri) throws OREParserException {
        try {
            Model model = this.parseToModel(is);
            ResourceMap rem = JenaOREFactory.createResourceMap(model, uri);
            return rem;
        }
        catch (OREException e) {
            throw new OREParserException(e);
        }
    }

    public void configure(Properties properties) {
        this.type = properties.getProperty("type");
    }

    private Model parseToModel(InputStream is) {
        Model model = ModelFactory.createDefaultModel();
        model = model.read(is, null, this.type);
        return model;
    }
}

