/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprTransform;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import java.util.ArrayList;
import java.util.List;

public abstract class ExprFunctionN
extends ExprFunction {
    protected ExprList args = null;

    protected ExprFunctionN(String fName, Expr ... args) {
        this(fName, ExprFunctionN.argList(args));
    }

    protected ExprFunctionN(String fName, ExprList args) {
        super(fName);
        this.args = args;
    }

    private static ExprList argList(Expr[] args) {
        ExprList exprList = new ExprList();
        for (Expr e2 : args) {
            if (e2 == null) continue;
            exprList.add(e2);
        }
        return exprList;
    }

    @Override
    public Expr getArg(int i) {
        if (--i >= this.args.size()) {
            return null;
        }
        return this.args.get(i);
    }

    @Override
    public int numArgs() {
        return this.args.size();
    }

    @Override
    public List<Expr> getArgs() {
        return this.args.getList();
    }

    @Override
    public Expr copySubstitute(Binding binding, boolean foldConstants) {
        ExprList newArgs = new ExprList();
        for (int i = 1; i <= this.numArgs(); ++i) {
            Expr e2 = this.getArg(i);
            e2 = e2.copySubstitute(binding, foldConstants);
            newArgs.add(e2);
        }
        return this.copy(newArgs);
    }

    @Override
    public Expr applyNodeTransform(NodeTransform transform) {
        ExprList newArgs = new ExprList();
        for (int i = 1; i <= this.numArgs(); ++i) {
            Expr e2 = this.getArg(i);
            e2 = e2.applyNodeTransform(transform);
            newArgs.add(e2);
        }
        return this.copy(newArgs);
    }

    protected NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        return null;
    }

    @Override
    public final NodeValue eval(Binding binding, FunctionEnv env) {
        NodeValue s = this.evalSpecial(binding, env);
        if (s != null) {
            return s;
        }
        ArrayList<NodeValue> argsEval = new ArrayList<NodeValue>();
        for (int i = 1; i <= this.numArgs(); ++i) {
            NodeValue x = ExprFunctionN.eval(binding, env, this.getArg(i));
            argsEval.add(x);
        }
        return this.eval(argsEval, env);
    }

    public NodeValue eval(List<NodeValue> args, FunctionEnv env) {
        return this.eval(args);
    }

    protected abstract NodeValue eval(List<NodeValue> var1);

    protected abstract Expr copy(ExprList var1);

    @Override
    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    public Expr apply(ExprTransform transform, ExprList exprList) {
        return transform.transform(this, exprList);
    }
}

