/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib.cache;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.SingletonIterator;
import org.apache.jena.atlas.lib.ActionKeyValue;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.Lib;

public class Cache1<K, V>
implements Cache<K, V> {
    private ActionKeyValue<K, V> dropHandler = null;
    private K cacheKey;
    private V cacheValue;

    public Cache1() {
        this.clear();
    }

    @Override
    public boolean containsKey(K key) {
        if (this.cacheKey == null) {
            return false;
        }
        return this.cacheKey.equals(key);
    }

    @Override
    public V get(K key) {
        if (this.cacheKey == null) {
            return null;
        }
        if (this.cacheKey.equals(key)) {
            return this.cacheValue;
        }
        return null;
    }

    @Override
    public void clear() {
        if (this.cacheKey == null) {
            return;
        }
        K k = this.cacheKey;
        V v = this.cacheValue;
        this.cacheKey = null;
        this.cacheValue = null;
        this.notifyDrop(k, v);
    }

    @Override
    public boolean isEmpty() {
        return this.cacheKey == null;
    }

    @Override
    public Iterator<K> keys() {
        return new SingletonIterator<K>(this.cacheKey);
    }

    @Override
    public V put(K key, V thing) {
        if (Lib.equal(this.cacheKey, key) && Lib.equal(this.cacheValue, thing)) {
            return this.cacheValue;
        }
        K k = this.cacheKey;
        V v = this.cacheValue;
        this.cacheKey = key;
        this.cacheValue = thing;
        this.notifyDrop(k, v);
        return v;
    }

    @Override
    public boolean remove(K key) {
        if (this.cacheKey == null) {
            return false;
        }
        if (this.cacheKey.equals(key)) {
            this.clear();
            return true;
        }
        return false;
    }

    @Override
    public void setDropHandler(ActionKeyValue<K, V> dropHandler) {
        this.dropHandler = dropHandler;
    }

    private void notifyDrop(K key, V thing) {
        if (this.dropHandler != null && key != null) {
            this.dropHandler.apply(key, thing);
        }
    }

    @Override
    public long size() {
        return this.cacheKey == null ? 0L : 1L;
    }
}

