/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.sample;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.ecoinformatics.datamanager.download.DataSourceNotFoundException;
import org.ecoinformatics.datamanager.download.DataStorageInterface;

public class SampleDataStorage
implements DataStorageInterface {
    private File tmp = new File(System.getProperty("java.io.tmpdir"));
    FileOutputStream stream = null;

    @Override
    public boolean doesDataExist(String identifier) {
        identifier = this.transformURLToIdentifier(identifier);
        System.out.println("the identifier is ============ " + identifier);
        File file = new File(this.tmp, identifier);
        return file.exists();
    }

    @Override
    public void finishSerialize(String indentifier, String errorCode) {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (Exception e) {
                System.err.println("Erorr: " + e.getMessage());
            }
        }
    }

    public long getEntitySize(String identifier) {
        long size = 0L;
        identifier = this.transformURLToIdentifier(identifier);
        File file = new File(this.tmp, identifier);
        size = file.length();
        return size;
    }

    @Override
    public Exception getException() {
        return null;
    }

    @Override
    public boolean isCompleted(String identifier) {
        return true;
    }

    @Override
    public boolean isSuccess(String identifier) {
        return true;
    }

    @Override
    public InputStream load(String identifier) throws DataSourceNotFoundException {
        identifier = this.transformURLToIdentifier(identifier);
        File file = new File(this.tmp, identifier);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (Exception e) {
            throw new DataSourceNotFoundException(e.getMessage());
        }
        return inputStream;
    }

    @Override
    public OutputStream startSerialize(String identifier) {
        identifier = this.transformURLToIdentifier(identifier);
        File file = new File(this.tmp, identifier);
        System.out.println("The tmp dir is " + System.getProperty("java.io.tmpdir"));
        try {
            this.stream = new FileOutputStream(file);
        }
        catch (Exception e) {
            System.err.println("Erorr: " + e.getMessage());
        }
        return this.stream;
    }

    private String transformURLToIdentifier(String url) {
        String identifier = null;
        if (url != null) {
            identifier = "tao" + url.hashCode();
        }
        return identifier;
    }
}

