/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transformer.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.BagInfoTxt;
import gov.loc.repository.bagit.transformer.Splitter;
import gov.loc.repository.bagit.transformer.impl.SplitBagHelper;
import gov.loc.repository.bagit.utilities.SizeHelper;
import gov.loc.repository.bagit.utilities.namevalue.NameValueReader;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SplitBySize
implements Splitter {
    private Double maxBagSize;
    private boolean keepLowestLevelDir;
    private BagFactory bagFactory;
    private String[] exludeDirs;

    public SplitBySize(BagFactory bagFactory, Double maxBagSize, boolean keepLowestLevelDir, String[] excludeDirs) {
        this.bagFactory = bagFactory;
        this.setKeepLowestLevelDir(keepLowestLevelDir);
        this.setMaxBagSize(maxBagSize);
        this.setExludeDirs(excludeDirs);
    }

    @Override
    public List<Bag> split(Bag srcBag) {
        ArrayList<Bag> subBags = new ArrayList<Bag>();
        List<BagFile> sortedBagFiles = this.sortBagFiles(srcBag.getPayload(), this.isKeepLowestLevelDir(), this.getMaxBagSize(), this.getExludeDirs());
        List<BagFileGroup> bagFileGroups = this.group(sortedBagFiles, this.getMaxBagSize());
        for (BagFileGroup bagFileGroup : bagFileGroups) {
            List<BagFile> groupBagFiles = bagFileGroup.getBagFiles();
            Bag subBag = this.bagFactory.createBag(srcBag.getVersion());
            if (srcBag.getBagInfoTxt() != null) {
                BagInfoTxt bagInfoTxt = subBag.getBagPartFactory().createBagInfoTxt();
                subBag.putBagFile(bagInfoTxt);
                List<NameValueReader.NameValue> list = srcBag.getBagInfoTxt().asList();
                for (NameValueReader.NameValue nameValue : list) {
                    subBag.getBagInfoTxt().put(nameValue);
                }
            }
            for (BagFile bagFile : groupBagFiles) {
                if (bagFile instanceof LowestLevelBagDir) {
                    subBag.putBagFiles(((LowestLevelBagDir)bagFile).getBagFiles());
                    continue;
                }
                subBag.putBagFile(bagFile);
            }
            subBags.add(subBag);
        }
        return subBags;
    }

    private List<BagFile> sortBagFiles(Collection<BagFile> payloadBagFiles, boolean keepLowestLevelDir, Double maxBagSize, String[] excludeDirs) {
        ArrayList<BagFile> sortedBagFiles = new ArrayList<BagFile>();
        HashSet<String> filePathDirs = new HashSet<String>();
        for (BagFile bagFile : payloadBagFiles) {
            if (SplitBagHelper.isExcluded(excludeDirs, this.getFilePathDir(bagFile.getFilepath()))) continue;
            filePathDirs.add(this.getFilePathDir(bagFile.getFilepath()));
        }
        if (keepLowestLevelDir) {
            for (String filePathdir : filePathDirs) {
                if (this.isLowestLevelDir(filePathdir, filePathDirs)) {
                    LowestLevelBagDir lowestLevelBagDir = new LowestLevelBagDir(filePathdir);
                    for (BagFile bagFile : payloadBagFiles) {
                        if (!this.getFilePathDir(bagFile.getFilepath()).equals(filePathdir)) continue;
                        lowestLevelBagDir.addBagFile(bagFile);
                    }
                    if ((double)lowestLevelBagDir.getSize() >= maxBagSize) {
                        throw new RuntimeException(MessageFormat.format("The size of the lowest level directory {0} exceeds the maximum split bag size {1}.", lowestLevelBagDir.getFilepath(), SizeHelper.getSize(maxBagSize.longValue())));
                    }
                    sortedBagFiles.add(lowestLevelBagDir);
                    continue;
                }
                for (BagFile bagFile : payloadBagFiles) {
                    if (!this.getFilePathDir(bagFile.getFilepath()).equals(filePathdir)) continue;
                    if ((double)bagFile.getSize() >= maxBagSize) {
                        throw new RuntimeException(MessageFormat.format("The size of the file {0} exceeds the maximum split bag size {1}.", bagFile.getFilepath(), SizeHelper.getSize(maxBagSize.longValue())));
                    }
                    if (SplitBagHelper.isExcluded(excludeDirs, bagFile.getFilepath())) continue;
                    sortedBagFiles.add(bagFile);
                }
            }
        } else {
            for (BagFile bagFile : payloadBagFiles) {
                if ((double)bagFile.getSize() >= maxBagSize) {
                    throw new RuntimeException(MessageFormat.format("The size of the file {0} exceeds the maximum split bag size {1}.", bagFile.getFilepath(), SizeHelper.getSize(maxBagSize.longValue())));
                }
                if (SplitBagHelper.isExcluded(excludeDirs, bagFile.getFilepath())) continue;
                sortedBagFiles.add(bagFile);
            }
        }
        return sortedBagFiles;
    }

    private String getFilePathDir(String filePath) {
        return filePath.substring(0, filePath.lastIndexOf(47));
    }

    private boolean isLowestLevelDir(String filePathDir, Set<String> filePathDirs) {
        for (String filePathDirItem : filePathDirs) {
            if (filePathDirItem.equals(filePathDir) || filePathDirItem.indexOf(filePathDir) < 0) continue;
            return false;
        }
        return true;
    }

    private List<BagFileGroup> group(List<BagFile> bagFiles, Double maxBagSize) {
        Collections.sort(bagFiles, new BagFileSizeReverseComparator());
        ArrayList<BagFileGroup> bagFileGroups = new ArrayList<BagFileGroup>();
        for (BagFile bagFile : bagFiles) {
            if (bagFileGroups.isEmpty()) {
                BagFileGroup group = new BagFileGroup(maxBagSize);
                group.addBagFile(bagFile);
                bagFileGroups.add(group);
                continue;
            }
            boolean foundSpace = false;
            for (BagFileGroup bagFileGroup : bagFileGroups) {
                if (!bagFileGroup.hasSpace(bagFile)) continue;
                bagFileGroup.addBagFile(bagFile);
                foundSpace = true;
                break;
            }
            if (foundSpace) continue;
            BagFileGroup group = new BagFileGroup(maxBagSize);
            group.addBagFile(bagFile);
            bagFileGroups.add(group);
        }
        return bagFileGroups;
    }

    public Double getMaxBagSize() {
        return this.maxBagSize;
    }

    public void setMaxBagSize(Double maxBagSize) {
        this.maxBagSize = maxBagSize;
    }

    public boolean isKeepLowestLevelDir() {
        return this.keepLowestLevelDir;
    }

    public void setKeepLowestLevelDir(boolean keepLowestLevelDir) {
        this.keepLowestLevelDir = keepLowestLevelDir;
    }

    public String[] getExludeDirs() {
        return this.exludeDirs;
    }

    public void setExludeDirs(String[] exludeDirs) {
        this.exludeDirs = exludeDirs;
    }

    private class LowestLevelBagDir
    implements BagFile {
        private String filePath;
        private List<BagFile> bagFiles = new ArrayList<BagFile>();

        public LowestLevelBagDir(String filePath) {
            this.filePath = filePath;
        }

        public List<BagFile> getBagFiles() {
            return this.bagFiles;
        }

        @Override
        public boolean exists() {
            throw new RuntimeException("Operation not supported exception.");
        }

        @Override
        public String getFilepath() {
            return this.filePath;
        }

        @Override
        public long getSize() {
            long length = 0L;
            for (BagFile bagFile : this.bagFiles) {
                length += bagFile.getSize();
            }
            return length;
        }

        @Override
        public InputStream newInputStream() {
            throw new RuntimeException("Operation not supported exception.");
        }

        public void addBagFile(BagFile bagFile) {
            this.bagFiles.add(bagFile);
        }
    }

    private class BagFileGroup {
        List<BagFile> bagFiles = new ArrayList<BagFile>();
        Double groupSize = 0.0;
        Double maxGroupSize = 300.0 * SizeHelper.GB;

        public BagFileGroup(Double maxGroupSize) {
            this.maxGroupSize = maxGroupSize;
        }

        public List<BagFile> getBagFiles() {
            return this.bagFiles;
        }

        public boolean hasSpace(BagFile bagFile) {
            return !(this.groupSize + (double)bagFile.getSize() > this.maxGroupSize);
        }

        public void addBagFile(BagFile bagFile) {
            this.bagFiles.add(bagFile);
            BagFileGroup bagFileGroup = this;
            bagFileGroup.groupSize = bagFileGroup.groupSize + (double)bagFile.getSize();
        }
    }

    private class BagFileSizeReverseComparator
    implements Comparator<BagFile> {
        private BagFileSizeReverseComparator() {
        }

        @Override
        public int compare(BagFile bagFile1, BagFile bagFile2) {
            return new Long(bagFile2.getSize()).compareTo(new Long(bagFile1.getSize()));
        }
    }
}

