/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.stream;

import com.hp.hpl.jena.util.FileUtils;
import java.util.Locale;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.stream.Locator;
import org.apache.jena.riot.stream.StreamManager;
import org.apache.jena.riot.web.HttpOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocatorURL
implements Locator {
    private static Logger log = LoggerFactory.getLogger(LocatorURL.class);
    private static final String[] schemeNames = new String[]{"http", "https"};

    @Override
    public TypedInputStream open(String uri) {
        if (!LocatorURL.acceptByScheme(uri)) {
            if (StreamManager.logAllLookups && log.isTraceEnabled()) {
                log.trace("Not found : " + uri);
            }
            return null;
        }
        if (uri.startsWith("http://") || uri.startsWith("https://")) {
            return HttpOp.execHttpGet(uri, "text/turtle,application/n-triples;q=0.9,application/rdf+xml;q=0.8,application/xml;q=0.7,*/*;q=0.5");
        }
        return null;
    }

    @Override
    public String getName() {
        return "LocatorURL";
    }

    private static boolean acceptByScheme(String filenameOrURI) {
        String uriSchemeName = FileUtils.getScheme((String)filenameOrURI);
        if (uriSchemeName == null) {
            return false;
        }
        uriSchemeName = uriSchemeName.toLowerCase(Locale.ENGLISH);
        for (int i = 0; i < schemeNames.length; ++i) {
            if (!uriSchemeName.equals(schemeNames[i])) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return 57;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }
}

