/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.Context;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.out.CharSpace;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.writer.WriterDatasetRIOTBase;

public class NQuadsWriter
extends WriterDatasetRIOTBase {
    private final CharSpace charSpace;

    public static void write(OutputStream out, Iterator<Quad> iter) {
        NQuadsWriter.write(out, iter, CharSpace.UTF8);
    }

    public static void write(OutputStream out, Iterator<Quad> iter, CharSpace charSpace) {
        StreamRDF s = StreamRDFLib.writer(out, charSpace);
        NQuadsWriter.write$(s, iter);
    }

    public static void write(Writer out, Iterator<Quad> iter) {
        NQuadsWriter.write(out, iter, CharSpace.UTF8);
    }

    public static void write(Writer out, Iterator<Quad> iter, CharSpace charSpace) {
        StreamRDF s = StreamRDFLib.writer(out, charSpace);
        NQuadsWriter.write$(s, iter);
    }

    private static void write$(StreamRDF s, Iterator<Quad> iter) {
        s.start();
        StreamRDFLib.quadsToStream(s, iter);
        s.finish();
    }

    public NQuadsWriter() {
        this(CharSpace.UTF8);
    }

    public NQuadsWriter(CharSpace charSpace) {
        this.charSpace = charSpace;
    }

    @Override
    public Lang getLang() {
        return Lang.NQUADS;
    }

    @Override
    public void write(Writer out, DatasetGraph dataset, PrefixMap prefixMap, String baseURI, Context context) {
        NQuadsWriter.write(out, dataset.find(null, null, null, null), this.charSpace);
    }

    @Override
    public void write(OutputStream out, DatasetGraph dataset, PrefixMap prefixMap, String baseURI, Context context) {
        NQuadsWriter.write(out, dataset.find(null, null, null, null), this.charSpace);
    }
}

