/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.other;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.Tuple;
import org.apache.jena.riot.other.StreamRDFBatchHandler;
import org.apache.jena.riot.system.StreamRDF;

public class BatchedStreamRDF
implements StreamRDF {
    private final StreamRDFBatchHandler batchProc;
    private Node currentSubject = null;
    private Node currentGraph = null;
    private List<Triple> batchTriples = null;
    private List<Quad> batchQuads = null;

    public BatchedStreamRDF(StreamRDFBatchHandler batchProc) {
        this.batchProc = batchProc;
    }

    @Override
    public final void start() {
        this.currentSubject = null;
        this.currentGraph = null;
        this.batchTriples = null;
        this.batchQuads = null;
        this.batchProc.start();
    }

    @Override
    public void triple(Triple triple) {
        Node s = triple.getSubject();
        if (!Lib.equal(s, this.currentSubject)) {
            if (this.currentSubject != null) {
                this.finishBatchTriple(this.currentSubject);
            }
            this.startBatchTriple(s);
            this.currentGraph = null;
            this.currentSubject = s;
        }
        this.processTriple(triple);
    }

    private void startBatchTriple(Node subject) {
        this.batchTriples = new ArrayList<Triple>();
    }

    private void finishBatchTriple(Node subject) {
        if (this.batchTriples != null && this.batchTriples.size() > 0) {
            this.batchProc.batchTriples(this.currentSubject, this.batchTriples);
        }
    }

    private void processTriple(Triple triple) {
        this.batchTriples.add(triple);
    }

    @Override
    public void quad(Quad quad) {
        Node g = quad.getGraph();
        Node s = quad.getSubject();
        if (!Lib.equal(g, this.currentGraph) || !Lib.equal(s, this.currentSubject)) {
            if (this.currentSubject != null) {
                this.finishBatchQuad(this.currentGraph, this.currentSubject);
            }
            this.startBatchQuad(g, s);
            this.currentGraph = g;
            this.currentSubject = s;
        }
        this.processQuad(quad);
    }

    private void startBatchQuad(Node graph, Node subject) {
        this.batchQuads = new ArrayList<Quad>();
    }

    private void finishBatchQuad(Node graph, Node subject) {
        if (this.batchQuads != null && this.batchQuads.size() > 0) {
            this.batchProc.batchQuads(this.currentGraph, this.currentSubject, this.batchQuads);
        }
    }

    private void processQuad(Quad Quad2) {
        this.batchQuads.add(Quad2);
    }

    private void flush() {
        this.finishBatchTriple(this.currentSubject);
        this.finishBatchQuad(this.currentGraph, this.currentSubject);
    }

    @Override
    public final void finish() {
        this.flush();
        this.batchProc.finish();
    }

    @Override
    public void tuple(Tuple<Node> tuple) {
        throw new UnsupportedOperationException("Tuples not supported");
    }

    @Override
    public void base(String base) {
        this.batchProc.base(base);
    }

    @Override
    public void prefix(String prefix, String iri2) {
        this.batchProc.prefix(prefix, iri2);
    }
}

