/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.InputStream;
import java.util.logging.Level;

public class ClasspathXmlConfig
extends Config {
    private final ILogger logger = Logger.getLogger(ClasspathXmlConfig.class.getName());

    public ClasspathXmlConfig(String resource) {
        this(Thread.currentThread().getContextClassLoader(), resource);
    }

    public ClasspathXmlConfig(ClassLoader classLoader, String resource) {
        this.logger.log(Level.INFO, "Configuring Hazelcast from '" + resource + "'.");
        InputStream in = classLoader.getResourceAsStream(resource);
        if (in == null) {
            throw new NullPointerException("Specified resource '" + resource + "' could not be found!");
        }
        new XmlConfigBuilder(in).build(this);
    }
}

