/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.utilities;

import gov.loc.repository.bagit.Manifest;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.text.MessageFormat;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageDigestHelper {
    private static final Log log = LogFactory.getLog(MessageDigestHelper.class);
    private static final int BUFFERSIZE = 65536;

    public static String generateFixity(File file, Manifest.Algorithm algorithm) {
        try {
            log.debug((Object)("Generating fixity for " + file.toString()));
            return MessageDigestHelper.generateFixity(new FileInputStream(file), algorithm);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String generateFixity(InputStream in, Manifest.Algorithm algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm.javaSecurityAlgorithm);
            byte[] dataBytes = new byte[65536];
            int nread = in.read(dataBytes);
            while (nread > 0) {
                md.update(dataBytes, 0, nread);
                nread = in.read(dataBytes);
            }
            String string = new String(Hex.encodeHex((byte[])md.digest()));
            return string;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static boolean fixityMatches(InputStream in, Manifest.Algorithm algorithm, String fixity) {
        if (fixity == null) {
            return false;
        }
        String generatedFixity = MessageDigestHelper.generateFixity(in, algorithm);
        log.debug((Object)MessageFormat.format("Generated fixity is {0}.  Check fixity is {1}.", generatedFixity, fixity));
        return generatedFixity.equalsIgnoreCase(fixity);
    }
}

