/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dataone.cn.indexer.convert.IConverter;
import org.dataone.cn.indexer.parser.ISolrField;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SolrField
implements ISolrField {
    private static Logger log = Logger.getLogger(SolrField.class);
    protected String name = null;
    protected String xpath = null;
    protected boolean multivalue = false;
    protected XPathExpression xPathExpression = null;
    protected IConverter converter = null;
    protected boolean combineNodes = false;
    private String combineDelimiter = " ";
    protected boolean dedupe = false;
    protected List<String> disallowedValues = null;
    protected String valueSeparator = null;
    protected String splitOnString = null;
    protected boolean substringBefore = false;
    protected boolean substringAfter = false;
    protected String defaultValue = null;

    public SolrField() {
    }

    public SolrField(String name, String xpath, boolean multivalue) {
        this(name, xpath, multivalue, null);
    }

    public SolrField(String name, String xpath, boolean multivalue, IConverter converter) {
        this.name = name;
        this.xpath = xpath;
        this.multivalue = multivalue;
        this.converter = converter;
    }

    public SolrField(String name, String xpath) {
        this.name = name;
        this.xpath = xpath;
    }

    @Override
    public void initExpression(XPath xpathObject) {
        if (this.getxPathExpression() == null) {
            try {
                this.setxPathExpression(xpathObject.compile(this.getXpath()));
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public List<SolrElementField> getFields(Document doc, String identifier) throws Exception {
        return this.processField(doc);
    }

    public List<SolrElementField> processField(Document doc) throws XPathExpressionException, IOException, SAXException, ParserConfigurationException {
        ArrayList<SolrElementField> fields;
        block11: {
            fields = new ArrayList<SolrElementField>();
            HashSet<String> usedValues = new HashSet<String>();
            try {
                if (this.multivalue) {
                    NodeList values = (NodeList)this.xPathExpression.evaluate(doc, XPathConstants.NODESET);
                    for (int i = 0; i < values.getLength(); ++i) {
                        Node n = values.item(i);
                        String nodeValue = n.getNodeValue();
                        if (nodeValue == null) continue;
                        nodeValue = nodeValue.trim();
                        if (StringUtils.isNotEmpty((CharSequence)this.valueSeparator) && nodeValue.contains(this.valueSeparator)) {
                            String[] inlineValues = StringUtils.split((String)nodeValue, (String)this.valueSeparator);
                            for (int j = 0; j < inlineValues.length; ++j) {
                                String inlineValue = inlineValues[j];
                                if (inlineValue.equals(this.valueSeparator) || !StringUtils.isNotEmpty((CharSequence)(nodeValue = this.processNodeValue(nodeValue, usedValues)))) continue;
                                fields.add(new SolrElementField(this.name, nodeValue));
                            }
                            continue;
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)(nodeValue = this.processNodeValue(nodeValue, usedValues)))) continue;
                        fields.add(new SolrElementField(this.name, nodeValue));
                    }
                    break block11;
                }
                String value = null;
                if (this.combineNodes) {
                    NodeList nodeSet = (NodeList)this.xPathExpression.evaluate(doc, XPathConstants.NODESET);
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < nodeSet.getLength(); ++i) {
                        if (i > 0) {
                            sb.append(this.combineDelimiter);
                        }
                        Node nText = nodeSet.item(i);
                        String nodeValue = nText.getNodeValue();
                        if (!StringUtils.isNotEmpty((CharSequence)(nodeValue = this.processNodeValue(nodeValue, usedValues)))) continue;
                        sb.append(nodeValue);
                    }
                    value = sb.toString().trim();
                } else {
                    String nodeValue = (String)this.xPathExpression.evaluate(doc, XPathConstants.STRING);
                    value = this.processNodeValue(nodeValue, usedValues);
                }
                if (StringUtils.isNotEmpty((CharSequence)value) && this.allowedValue(value)) {
                    fields.add(new SolrElementField(this.name, value));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return fields;
    }

    protected String processNodeValue(String nodeValue, Set<String> usedValues) {
        String finalValue = null;
        if (StringUtils.isNotEmpty((CharSequence)nodeValue)) {
            if (StringUtils.isNotEmpty((CharSequence)this.splitOnString) && nodeValue.contains(this.splitOnString)) {
                if (this.substringAfter) {
                    nodeValue = StringUtils.substringAfter((String)nodeValue, (String)this.splitOnString);
                }
                if (this.substringBefore) {
                    nodeValue = StringUtils.substringBefore((String)nodeValue, (String)this.splitOnString);
                }
            }
            nodeValue = nodeValue.trim();
            if (this.converter != null) {
                nodeValue = this.converter.convert(nodeValue);
            }
            if ((!this.dedupe || this.dedupe & !usedValues.contains(nodeValue)) && StringUtils.isNotEmpty((CharSequence)nodeValue) && this.allowedValue(nodeValue)) {
                finalValue = nodeValue;
                usedValues.add(finalValue);
            }
        } else if (this.defaultValue != null) {
            finalValue = this.defaultValue;
        }
        return finalValue;
    }

    protected boolean allowedValue(String value) {
        if (this.disallowedValues == null || this.disallowedValues.isEmpty()) {
            return true;
        }
        for (String disallowed : this.disallowedValues) {
            if (!disallowed.equalsIgnoreCase(value)) continue;
            return false;
        }
        return true;
    }

    public boolean isCombineNodes() {
        return this.combineNodes;
    }

    public void setCombineNodes(boolean combineNodes) {
        this.combineNodes = combineNodes;
    }

    public String getCombineDelimiter() {
        return this.combineDelimiter;
    }

    public void setCombineDelimiter(String combineDelimiter) {
        this.combineDelimiter = combineDelimiter;
    }

    public void setDedupe(boolean dedupe) {
        this.dedupe = dedupe;
    }

    public void setDisallowedValues(List<String> disallowed) {
        this.disallowedValues = disallowed;
    }

    public List<String> getDisallwedValues() {
        return this.disallowedValues;
    }

    public void setValueSeparator(String valueSeparator) {
        this.valueSeparator = valueSeparator;
    }

    public String getValueSeparator() {
        return this.valueSeparator;
    }

    protected XPathExpression getxPathExpression() {
        return this.xPathExpression;
    }

    protected void setxPathExpression(XPathExpression xPathExpression) {
        this.xPathExpression = xPathExpression;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public boolean isMultivalue() {
        return this.multivalue;
    }

    public void setMultivalue(boolean multivalue) {
        this.multivalue = multivalue;
    }

    public IConverter getConverter() {
        return this.converter;
    }

    public void setConverter(IConverter converter) {
        this.converter = converter;
    }

    public String getSplitOnString() {
        return this.splitOnString;
    }

    public void setSplitOnString(String splitOnString) {
        this.splitOnString = splitOnString;
    }

    public boolean isSubstringBefore() {
        return this.substringBefore;
    }

    public void setSubstringBefore(boolean substringBefore) {
        this.substringBefore = substringBefore;
    }

    public boolean isSubstringAfter() {
        return this.substringAfter;
    }

    public void setSubstringAfter(boolean substringAfter) {
        this.substringAfter = substringAfter;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}

