/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OrderItem {
    @NotNull
    @NotEmpty
    private String object;
    @NotNull
    private Integer amount;
    private String currency;
    private String description;
    @NotNull
    private Integer parent;
    @NotNull
    private Integer quantity;
    @NotNull
    @NotEmpty
    @Pattern(regexp="sku|tax|shipping|discount")
    private @NotNull @NotEmpty @Pattern(regexp="sku|tax|shipping|discount") String type;

    public OrderItem() {
    }

    public OrderItem(String json) throws IOException {
        if (!json.equals("{}")) {
            OrderItem orderItem = (OrderItem)new ObjectMapper().readValue(json, OrderItem.class);
            this.object = orderItem.getObject();
            this.amount = orderItem.getAmount();
            this.currency = orderItem.getCurrency();
            this.description = orderItem.getDescription();
            this.parent = orderItem.getParent();
            this.quantity = orderItem.getQuantity();
            this.type = orderItem.getType();
        }
    }

    public OrderItem(@NotNull @NotEmpty String object, @NotNull Integer amount, @NotNull @NotEmpty String currency, @NotNull @NotEmpty String description, Integer parent, @NotNull Integer quantity, @NotNull @NotEmpty @Pattern(regexp="sku|tax|shipping|discount") @NotNull @NotEmpty @Pattern(regexp="sku|tax|shipping|discount") String type) {
        this.object = object;
        this.amount = amount;
        this.currency = currency;
        this.description = description;
        this.parent = parent;
        this.quantity = quantity;
        this.type = type;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getParent() {
        return this.parent;
    }

    public void setParent(Integer parent) {
        this.parent = parent;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderItem orderItem = (OrderItem)o;
        return Objects.equals(this.getObject(), orderItem.getObject()) && Objects.equals(this.getAmount(), orderItem.getAmount()) && Objects.equals(this.getCurrency(), orderItem.getCurrency()) && Objects.equals(this.getDescription(), orderItem.getDescription()) && Objects.equals(this.getParent(), orderItem.getParent()) && Objects.equals(this.getQuantity(), orderItem.getQuantity()) && Objects.equals(this.getType(), orderItem.getType());
    }

    public int hashCode() {
        return Objects.hash(this.getObject(), this.getAmount(), this.getCurrency(), this.getDescription(), this.getParent(), this.getQuantity(), this.getType());
    }
}

