/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.dataone.bookkeeper.api.Quota;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Feature {
    @NotNull
    @NotEmpty
    private String name;
    @NotNull
    @NotEmpty
    private String label;
    @NotNull
    @NotEmpty
    private String description;
    private Quota quota;

    public Feature() {
    }

    public Feature(String json) throws IOException {
        if (!json.equals("{}")) {
            Feature feature = (Feature)new ObjectMapper().readValue(json, Feature.class);
            this.name = feature.name;
            this.label = feature.label;
            this.description = feature.description;
            this.quota = feature.quota;
        }
    }

    public Feature(@NotNull @NotEmpty String name, @NotNull @NotEmpty String label, @NotNull @NotEmpty String description, @NotEmpty Quota quota) {
        this.name = name;
        this.label = label;
        this.description = description;
        this.quota = quota;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Quota getQuota() {
        return this.quota;
    }

    public void setQuota(Quota quota) {
        this.quota = quota;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feature feature = (Feature)o;
        return Objects.equals(this.getName(), feature.getName()) && Objects.equals(this.getLabel(), feature.getLabel()) && Objects.equals(this.getDescription(), feature.getDescription()) && Objects.equals(this.getQuota(), feature.getQuota());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getLabel(), this.getDescription(), this.getQuota());
    }
}

