/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb;

import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.sparql.mgt.ARQMgt;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.file.ChannelManager;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.file.LocationLock;
import com.hp.hpl.jena.tdb.setup.DatasetBuilderStd;
import com.hp.hpl.jena.tdb.setup.StoreParams;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import com.hp.hpl.jena.tdb.transaction.DatasetGraphTxn;
import com.hp.hpl.jena.tdb.transaction.JournalControl;
import com.hp.hpl.jena.tdb.transaction.SysTxnState;
import com.hp.hpl.jena.tdb.transaction.TDBTransactionException;
import com.hp.hpl.jena.tdb.transaction.TransactionInfo;
import com.hp.hpl.jena.tdb.transaction.TransactionManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class StoreConnection {
    private final TransactionManager transactionManager;
    private final DatasetGraphTDB baseDSG;
    private boolean isValid = true;
    private volatile boolean haveUsedInTransaction = false;
    private static Map<Location, StoreConnection> cache = new HashMap<Location, StoreConnection>();

    private StoreConnection(DatasetGraphTDB dsg) {
        this.baseDSG = dsg;
        this.transactionManager = new TransactionManager(this.baseDSG);
    }

    private void checkValid() {
        if (!this.isValid) {
            throw new TDBTransactionException("StoreConnection inValid (issued before a StoreConnection.release?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTransactional() {
        if (!this.haveUsedInTransaction) {
            StoreConnection storeConnection = this;
            synchronized (storeConnection) {
                if (!this.haveUsedInTransaction) {
                    this.baseDSG.sync();
                }
                this.haveUsedInTransaction = true;
            }
        }
    }

    public boolean haveUsedInTransaction() {
        return this.haveUsedInTransaction;
    }

    public Location getLocation() {
        this.checkValid();
        return this.baseDSG.getLocation();
    }

    public SysTxnState getTransMgrState() {
        this.checkValid();
        return this.transactionManager.state();
    }

    public DatasetGraphTxn begin(ReadWrite mode) {
        this.checkValid();
        this.checkTransactional();
        this.haveUsedInTransaction = true;
        return this.transactionManager.begin(mode);
    }

    public DatasetGraphTxn begin(ReadWrite mode, String label) {
        this.checkValid();
        this.checkTransactional();
        return this.transactionManager.begin(mode, label);
    }

    public DatasetGraphTDB getBaseDataset() {
        this.checkValid();
        return this.baseDSG;
    }

    public void flush() {
        if (!this.haveUsedInTransaction()) {
            return;
        }
        this.checkValid();
        this.transactionManager.flush();
    }

    public boolean activeTransactions() {
        this.checkValid();
        return this.transactionManager.activeTransactions();
    }

    public void forceRecoverFromJournal() {
        JournalControl.recoverFromJournal(this.getBaseDataset().getConfig(), this.transactionManager.getJournal());
    }

    public void printJournal() {
        JournalControl.print(this.transactionManager.getJournal());
    }

    public static StoreConnection make(String location) {
        return StoreConnection.make(Location.create(location));
    }

    public static synchronized void reset() {
        HashSet<Location> x = new HashSet<Location>(cache.keySet());
        for (Location loc : x) {
            StoreConnection.expel(loc, true);
        }
        cache.clear();
    }

    public static synchronized void release(Location location) {
        StoreConnection.expel(location, false);
    }

    public static synchronized void expel(Location location, boolean force) {
        StoreConnection sConn = cache.get(location);
        if (sConn == null) {
            return;
        }
        if (!force && sConn.transactionManager.activeTransactions()) {
            throw new TDBTransactionException("Can't expel: Active transactions for location: " + location);
        }
        sConn.transactionManager.closedown();
        sConn.baseDSG.close();
        sConn.isValid = false;
        cache.remove(location);
        ChannelManager.release(sConn.transactionManager.getJournal().getFilename());
        if (SystemTDB.DiskLocationMultiJvmUsagePrevention) {
            if (location.getLock().isOwned()) {
                location.getLock().release();
            } else if (location.getLock().canLock()) {
                SystemTDB.errlog.warn("Location " + location.getDirectoryPath() + " was not locked, if another JVM accessed this location simultaneously data corruption may have occurred");
            }
        }
    }

    public static synchronized StoreConnection make(Location location, StoreParams params) {
        StoreConnection sConn = cache.get(location);
        if (sConn != null) {
            return sConn;
        }
        DatasetGraphTDB dsg = DatasetBuilderStd.create(location, params);
        sConn = StoreConnection._makeAndCache(dsg);
        return sConn;
    }

    public static StoreConnection make(Location location) {
        return StoreConnection.make(location, null);
    }

    public static synchronized StoreConnection getExisting(Location location) {
        return cache.get(location);
    }

    private static StoreConnection _makeAndCache(DatasetGraphTDB dsg) {
        Location location = dsg.getLocation();
        StoreConnection sConn = cache.get(location);
        if (sConn == null) {
            LocationLock lock;
            sConn = new StoreConnection(dsg);
            if (SystemTDB.DiskLocationMultiJvmUsagePrevention && (lock = location.getLock()).canLock()) {
                if (!lock.canObtain()) {
                    throw new TDBException("Can't open database at location " + location.getDirectoryPath() + " as it is already locked by the process with PID " + lock.getOwner() + ".  TDB databases do not permit concurrent usage across JVMs so in order to prevent possible data corruption you cannot open this location from the JVM that does not own the lock for the dataset");
                }
                lock.obtain();
                if (!lock.isOwned()) {
                    throw new TDBException("Can't open database at location " + location.getDirectoryPath() + " as it is alread locked by the process with PID " + lock.getOwner() + ".  TDB databases do not permit concurrent usage across JVMs so in order to prevent possible data corruption you cannot open this location from the JVM that does not own the lock for the dataset");
                }
            }
            sConn.forceRecoverFromJournal();
            if (!location.isMemUnique()) {
                cache.put(location, sConn);
            }
            String NS = "org.apache.jena.tdb";
            TransactionInfo txInfo = new TransactionInfo(sConn.transactionManager);
            ARQMgt.register((String)(NS + ".system:type=Transactions"), (Object)txInfo);
        }
        return sConn;
    }

    public static StoreConnection createMemUncached() {
        DatasetGraphTDB dsg = DatasetBuilderStd.create(Location.mem(), null);
        return new StoreConnection(dsg);
    }
}

