/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.math.ec.WNafUtil;

public class RSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private RSAKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (RSAKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = null;
        boolean bl = false;
        while (!bl) {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            BigInteger bigInteger3;
            BigInteger bigInteger4;
            BigInteger bigInteger5;
            BigInteger bigInteger6;
            BigInteger bigInteger7;
            BigInteger bigInteger8;
            int n = this.param.getStrength();
            int n2 = (n + 1) / 2;
            int n3 = n - n2;
            int n4 = n / 3;
            int n5 = n >> 2;
            BigInteger bigInteger9 = this.param.getPublicExponent();
            BigInteger bigInteger10 = this.chooseRandomPrime(n2, bigInteger9);
            while (true) {
                if ((bigInteger8 = (bigInteger7 = this.chooseRandomPrime(n3, bigInteger9)).subtract(bigInteger10).abs()).bitLength() < n4) {
                    continue;
                }
                bigInteger6 = bigInteger10.multiply(bigInteger7);
                if (bigInteger6.bitLength() != n) {
                    bigInteger10 = bigInteger10.max(bigInteger7);
                    continue;
                }
                if (WNafUtil.getNafWeight(bigInteger6) >= n5) break;
                bigInteger10 = this.chooseRandomPrime(n2, bigInteger9);
            }
            if (bigInteger10.compareTo(bigInteger7) < 0) {
                bigInteger5 = bigInteger10;
                bigInteger10 = bigInteger7;
                bigInteger7 = bigInteger5;
            }
            if ((bigInteger4 = bigInteger9.modInverse(bigInteger3 = (bigInteger5 = (bigInteger2 = bigInteger10.subtract(ONE)).multiply(bigInteger = bigInteger7.subtract(ONE))).divide(bigInteger2.gcd(bigInteger)))).bitLength() <= n3 || !bigInteger4.equals(bigInteger9.modInverse(bigInteger5))) continue;
            bl = true;
            bigInteger8 = bigInteger4.remainder(bigInteger2);
            BigInteger bigInteger11 = bigInteger4.remainder(bigInteger);
            BigInteger bigInteger12 = bigInteger7.modInverse(bigInteger10);
            asymmetricCipherKeyPair = new AsymmetricCipherKeyPair(new RSAKeyParameters(false, bigInteger6, bigInteger9), new RSAPrivateCrtKeyParameters(bigInteger6, bigInteger9, bigInteger4, bigInteger10, bigInteger7, bigInteger8, bigInteger11, bigInteger12));
        }
        return asymmetricCipherKeyPair;
    }

    protected BigInteger chooseRandomPrime(int n, BigInteger bigInteger) {
        BigInteger bigInteger2;
        while ((bigInteger2 = new BigInteger(n, 1, this.param.getRandom())).mod(bigInteger).equals(ONE) || !bigInteger2.isProbablePrime(this.param.getCertainty()) || !bigInteger.gcd(bigInteger2.subtract(ONE)).equals(ONE)) {
        }
        return bigInteger2;
    }
}

