/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.events.aggregated;

import com.carrotsearch.ant.tasks.junit4.ForkedJvmInfo;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Lists;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.Subscribe;
import com.carrotsearch.ant.tasks.junit4.events.IEvent;
import com.carrotsearch.ant.tasks.junit4.events.LowLevelHeartBeatEvent;
import com.carrotsearch.ant.tasks.junit4.events.SuiteCompletedEvent;
import com.carrotsearch.ant.tasks.junit4.events.SuiteFailureEvent;
import com.carrotsearch.ant.tasks.junit4.events.SuiteStartedEvent;
import com.carrotsearch.ant.tasks.junit4.events.TestFailureEvent;
import com.carrotsearch.ant.tasks.junit4.events.TestFinishedEvent;
import com.carrotsearch.ant.tasks.junit4.events.TestIgnoredAssumptionEvent;
import com.carrotsearch.ant.tasks.junit4.events.TestIgnoredEvent;
import com.carrotsearch.ant.tasks.junit4.events.TestStartedEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedSuiteResultEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedSuiteStartedEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedTestResultEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.HeartBeatEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.PartialOutputEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;

public class AggregatingListener {
    private EventBus target;
    private ForkedJvmInfo slave;
    private AggregatedSuiteStartedEvent startEvent;
    private Description lastSuite;
    private List suiteFailures;
    private ArrayDeque tests;
    private ArrayList eventStream;
    private int testStartStreamMarker;

    public AggregatingListener(EventBus eventBus, ForkedJvmInfo forkedJvmInfo) {
        this.target = eventBus;
        this.slave = forkedJvmInfo;
    }

    @Subscribe
    public void appendToEventStream(IEvent iEvent) {
        if (this.eventStream != null) {
            switch (iEvent.getType()) {
                case APPEND_STDOUT: 
                case APPEND_STDERR: {
                    this.target.post(new PartialOutputEvent(this.slave, iEvent));
                }
                case TEST_STARTED: 
                case TEST_FINISHED: 
                case TEST_FAILURE: 
                case TEST_IGNORED: 
                case TEST_IGNORED_ASSUMPTION: 
                case SUITE_FAILURE: {
                    this.eventStream.add(iEvent);
                    break;
                }
            }
        }
    }

    @Subscribe
    public void slowHeartBeat(LowLevelHeartBeatEvent lowLevelHeartBeatEvent) {
        Description description = null;
        description = this.tests != null && !this.tests.isEmpty() ? ((AggregatedTestResultEvent)this.tests.peek()).getDescription() : this.lastSuite;
        this.target.post(new HeartBeatEvent(this.slave, description, lowLevelHeartBeatEvent.lastActivity, lowLevelHeartBeatEvent.currentTime));
    }

    @Subscribe
    public void receiveSuiteStart(SuiteStartedEvent suiteStartedEvent) {
        assert (this.lastSuite == null);
        assert (this.startEvent == null);
        this.tests = new ArrayDeque();
        this.suiteFailures = new ArrayList();
        this.eventStream = new ArrayList();
        this.lastSuite = suiteStartedEvent.getDescription();
        this.startEvent = new AggregatedSuiteStartedEvent(this.slave, suiteStartedEvent);
        this.target.post(this.startEvent);
    }

    @Subscribe
    public void receiveTestStart(TestStartedEvent testStartedEvent) {
        this.tests.push(new AggregatedTestResultEvent(this.slave, this.lastSuite, testStartedEvent.getDescription()));
        this.testStartStreamMarker = this.eventStream.size();
    }

    @Subscribe
    public void receiveTestIgnored(TestIgnoredEvent testIgnoredEvent) {
        Description description = testIgnoredEvent.getDescription();
        if (description.getMethodName() == null) {
            return;
        }
        if (!this.tests.isEmpty() && description.equals((Object)((AggregatedTestResultEvent)this.tests.peek()).getDescription())) {
            ((AggregatedTestResultEvent)this.tests.peek()).setIgnored(testIgnoredEvent.getCause());
        } else {
            this.receiveTestStart(new TestStartedEvent(description));
            ((AggregatedTestResultEvent)this.tests.peek()).setIgnored(testIgnoredEvent.getCause());
            this.receiveTestEnd(new TestFinishedEvent(description, 0L, testIgnoredEvent.getStartTimestamp()));
        }
    }

    @Subscribe
    public void receiveTestAssumptionIgnored(TestIgnoredAssumptionEvent testIgnoredAssumptionEvent) {
        Description description = testIgnoredAssumptionEvent.getDescription();
        if (description.getMethodName() == null) {
            return;
        }
        assert (testIgnoredAssumptionEvent.getDescription().equals((Object)((AggregatedTestResultEvent)this.tests.peek()).getDescription()));
        ((AggregatedTestResultEvent)this.tests.peek()).addFailure(testIgnoredAssumptionEvent.getFailure());
    }

    @Subscribe
    public void receiveTestFailure(TestFailureEvent testFailureEvent) {
        Description description = testFailureEvent.getDescription();
        if (description.getMethodName() == null) {
            this.suiteFailures.add(testFailureEvent.getFailure());
            return;
        }
        ((AggregatedTestResultEvent)this.tests.peek()).addFailure(testFailureEvent.getFailure());
    }

    @Subscribe
    public void receiveTestEnd(TestFinishedEvent testFinishedEvent) {
        assert (testFinishedEvent.getDescription().equals((Object)((AggregatedTestResultEvent)this.tests.peek()).getDescription()));
        ((AggregatedTestResultEvent)this.tests.peek()).complete(testFinishedEvent, new ArrayList(this.eventStream.subList(this.testStartStreamMarker, this.eventStream.size())));
        this.target.post(this.tests.peek());
    }

    @Subscribe
    public void receiveSuiteEnd(SuiteCompletedEvent suiteCompletedEvent) {
        this.target.post(new AggregatedSuiteResultEvent(this.startEvent, this.slave, suiteCompletedEvent.getDescription(), this.suiteFailures, Lists.newArrayList(this.tests.descendingIterator()), this.eventStream, suiteCompletedEvent.getStartTimestamp(), suiteCompletedEvent.getExecutionTime()));
        this.suiteFailures = null;
        this.lastSuite = null;
        this.startEvent = null;
        this.tests = null;
        this.eventStream = null;
    }

    @Subscribe
    public void receiveSuiteFailure(SuiteFailureEvent suiteFailureEvent) {
        if (this.suiteFailures != null) {
            this.suiteFailures.add(suiteFailureEvent.getFailure());
        } else {
            this.receiveSuiteStart(new SuiteStartedEvent(suiteFailureEvent.getDescription(), System.currentTimeMillis()));
            this.suiteFailures.add(suiteFailureEvent.getFailure());
            this.receiveSuiteEnd(new SuiteCompletedEvent(suiteFailureEvent.getDescription(), System.currentTimeMillis(), 0L));
        }
    }
}

