/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.auth;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivateKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.dataone.client.auth.CertificateManager;
import org.dataone.client.rest.MultipartRestClient;
import org.dataone.exceptions.MarshallingException;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v2.TypeFactory;

public class X509Session
extends Session {
    private static final long serialVersionUID = -1711723814675675414L;
    private X509Certificate cert;
    private PrivateKey privateKey;
    private Object httpClient;
    private MultipartRestClient mrc;

    X509Session(X509Certificate certificate, PrivateKey key) {
        this.cert = certificate;
        this.privateKey = key;
    }

    private X509Session() {
    }

    public static X509Session create(String certificateLabel) throws IOException {
        return CertificateManager.getInstance().selectSession(certificateLabel);
    }

    public static X509Session create(X509Certificate certificate, PrivateKey key, Session session) throws InstantiationException, IllegalAccessException, InvocationTargetException, MarshallingException, IOException, NoSuchMethodException {
        X509Session xs = (X509Session)((Object)TypeFactory.convertTypeFromType((Object)TypeFactory.clone((Object)session), X509Session.class));
        xs.cert = certificate;
        xs.privateKey = key;
        return xs;
    }

    public static X509Session create(X509Certificate certificate, PrivateKey key) {
        return new X509Session(certificate, key);
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.cert.checkValidity();
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        this.cert.checkValidity(date);
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setHttpClient(Object httpClient) {
        this.httpClient = httpClient;
    }

    public Object getHttpClient() {
        return this.httpClient;
    }

    public void setMultipartRestClient(MultipartRestClient multipartRestClient) {
        this.mrc = multipartRestClient;
    }

    public MultipartRestClient getMultipartRestClient() {
        return this.mrc;
    }
}

