/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprException;
import com.hp.hpl.jena.sparql.expr.ExprFunctionN;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.RegexEngine;
import com.hp.hpl.jena.sparql.expr.RegexJava;
import com.hp.hpl.jena.sparql.expr.RegexXerces;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeFunctions;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.util.List;
import org.apache.jena.atlas.logging.Log;

public class E_Regex
extends ExprFunctionN {
    private static Symbol regexImpl = null;
    private static final String name = "regex";
    private RegexEngine regexEngine = null;

    public E_Regex(Expr expr, Expr pattern, Expr flags) {
        super(name, expr, pattern, flags);
        this.init(pattern, flags);
    }

    public E_Regex(Expr expr, String pattern, String flags) {
        super(name, expr, NodeValue.makeString(pattern), NodeValue.makeString(flags));
        this.init(this.getArg(2), this.getArg(3));
    }

    private void init(Expr pattern, Expr flags) {
        if (pattern.isConstant() && pattern.getConstant().isString() && (flags == null || flags.isConstant())) {
            this.regexEngine = E_Regex.makeRegexEngine(pattern.getConstant(), flags == null ? null : flags.getConstant());
        }
    }

    @Override
    public NodeValue eval(List<NodeValue> args) {
        boolean b;
        Node arg = NodeFunctions.checkAndGetStringLiteral("REGEX", args.get(0));
        NodeValue vPattern = args.get(1);
        NodeValue vFlags = args.size() == 2 ? null : args.get(2);
        RegexEngine regex = this.regexEngine;
        if (regex == null) {
            regex = E_Regex.makeRegexEngine(vPattern, vFlags);
        }
        return (b = regex.match(arg.getLiteralLexicalForm())) ? NodeValue.TRUE : NodeValue.FALSE;
    }

    public static RegexEngine makeRegexEngine(NodeValue vPattern, NodeValue vFlags) {
        if (!vPattern.isString()) {
            throw new ExprException("REGEX: Pattern is not a string: " + vPattern);
        }
        if (vFlags != null && !vFlags.isString()) {
            throw new ExprException("REGEX: Pattern flags are not a string: " + vFlags);
        }
        String s = vFlags == null ? null : vFlags.getString();
        return E_Regex.makeRegexEngine(vPattern.getString(), s);
    }

    public static RegexEngine makeRegexEngine(String pattern, String flags) {
        if (regexImpl.equals(ARQ.xercesRegex)) {
            return new RegexXerces(pattern, flags);
        }
        return new RegexJava(pattern, flags);
    }

    @Override
    protected Expr copy(ExprList newArgs) {
        if (newArgs.size() == 2) {
            return new E_Regex(newArgs.get(0), newArgs.get(1), null);
        }
        return new E_Regex(newArgs.get(0), newArgs.get(1), newArgs.get(2));
    }

    static {
        Object v = ARQ.getContext().get(ARQ.regexImpl, ARQ.javaRegex);
        if (v instanceof Symbol) {
            regexImpl = (Symbol)v;
        }
        if (v instanceof String) {
            regexImpl = Symbol.create((String)v);
        }
        if (regexImpl == null) {
            Log.warn(E_Regex.class, "Regex implementation some weird setting: default to Java");
            regexImpl = ARQ.javaRegex;
        }
        if (!regexImpl.equals(ARQ.javaRegex) && !regexImpl.equals(ARQ.xercesRegex)) {
            Log.warn(E_Regex.class, "Regex implementation not recognized : default to Java");
            regexImpl = ARQ.javaRegex;
        }
    }
}

