/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.configuration.provider;

import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.core.configuration.provider.HierarchicalConfigProvider;
import java.util.List;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;

public abstract class TypedProvider<T>
extends HierarchicalConfigProvider<T> {
    String type;
    String target;
    ConfigurationNode typeConfig;

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public TypedProvider(ConfigurationNode config, String type, String target) {
        super(config);
        this.type = type;
        this.target = target;
    }

    public TypedProvider() {
    }

    protected TypedProvider(String type, String target) {
        this.target = target;
        this.type = type;
    }

    public ConfigurationNode getTypeConfig() {
        return this.typeConfig;
    }

    public void setTypeConfig(ConfigurationNode typeConfig) {
        this.typeConfig = typeConfig;
    }

    @Override
    protected boolean checkEvent(CfgEvent cfgEvent) {
        if (cfgEvent.getConfiguration().getName().equals(this.getType()) && !cfgEvent.getConfiguration().getChildren(this.getTarget()).isEmpty()) {
            this.setTypeConfig(cfgEvent.getConfiguration());
            this.setConfig((ConfigurationNode)cfgEvent.getConfiguration().getChildren(this.getTarget()).get(0));
            return true;
        }
        return false;
    }

    public String getTypeAttribute(String key) {
        List list = this.getTypeConfig().getAttributes(key);
        if (list.isEmpty()) {
            return null;
        }
        DefaultConfigurationNode node = (DefaultConfigurationNode)list.get(0);
        return node.getValue().toString();
    }

    protected String getTypeAttribute(String key, String defaultValue) {
        String x = this.getTypeAttribute(key);
        if (x == null) {
            x = defaultValue;
        }
        return x;
    }

    public int getTypeIntAttribute(String key, int defaultValue) {
        String x = this.getTypeAttribute(key);
        if (x == null) {
            return defaultValue;
        }
        return Integer.parseInt(x);
    }

    public int getTypeIntAttribute(String key) {
        return Integer.parseInt(this.getTypeAttribute(key));
    }

    public boolean getTypeBooleanAttribute(String key) {
        return Boolean.parseBoolean(this.getTypeAttribute(key));
    }

    public String toString() {
        String className = this.getClass().getSimpleName();
        if (className.length() == 0) {
            className = "<anonymous>";
        }
        return className + "[type=" + this.getType() + ", target=" + this.getTarget() + ", cfg node=" + (this.getConfig().getName() == null ? "(null)" : this.getConfig().getName()) + "]";
    }
}

