/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.graph.impl.AdhocDatatype;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LiteralLabelImpl
implements LiteralLabel {
    private static Logger log = LoggerFactory.getLogger(LiteralLabelImpl.class);
    private String lexicalForm;
    private Object value;
    private RDFDatatype dtype;
    private String lang;
    private boolean wellformed = true;
    private String exceptionMsg = null;
    private int hash = 0;

    LiteralLabelImpl(String lex, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        this.setLiteralLabel_1(lex, lang, dtype);
    }

    private void setLiteralLabel_1(String lex, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        this.lexicalForm = lex;
        this.dtype = dtype;
        String string = this.lang = lang == null ? "" : lang;
        if (dtype == null) {
            this.value = lex;
        } else {
            this.setValue(lex);
        }
        this.normalize();
    }

    LiteralLabelImpl(Object value, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        this.setLiteralLabel_2(value, lang, dtype);
    }

    LiteralLabelImpl(Object value) {
        RDFDatatype dt = TypeMapper.getInstance().getTypeByValue(value);
        if (dt == null) {
            this.setWithNewDatatypeForValueClass(value);
        } else {
            this.setLiteralLabel_2(value, "", dt);
        }
    }

    private void setWithNewDatatypeForValueClass(Object value) {
        Class<?> c = value.getClass();
        log.warn("inventing a datatype for " + c);
        AdhocDatatype dt = new AdhocDatatype(c);
        TypeMapper.getInstance().registerDatatype(dt);
        this.lang = "";
        this.dtype = dt;
        this.value = value;
        this.lexicalForm = value.toString();
    }

    private void setLiteralLabel_2(Object value, String language, RDFDatatype dtype) throws DatatypeFormatException {
        this.dtype = dtype;
        String string = this.lang = language == null ? "" : language;
        if (value instanceof String) {
            String lex;
            this.lexicalForm = lex = (String)value;
            if (dtype == null) {
                this.value = lex;
            } else {
                this.setValue(lex);
            }
        } else {
            this.value = dtype == null ? value : dtype.cannonicalise(value);
        }
        this.normalize();
        if (dtype != null && this.lexicalForm == null) {
            this.wellformed = this.dtype.isValidValue(value);
            if (JenaParameters.enableEagerLiteralValidation && !this.wellformed) {
                throw new DatatypeFormatException(value.toString(), dtype, "in literal creation");
            }
        }
    }

    LiteralLabelImpl(String s, String lg, boolean xml) {
        this.setLiteralLabel_3(s, lg, xml);
    }

    private void setLiteralLabel_3(String s, String lg, boolean xml) {
        this.lexicalForm = s;
        String string = this.lang = lg == null ? "" : lg;
        if (xml) {
            this.dtype = XMLLiteralType.theXMLLiteralType;
            this.value = s;
            this.wellformed = true;
        } else {
            this.value = s;
            this.dtype = null;
        }
    }

    private void setValue(String lex) throws DatatypeFormatException {
        try {
            this.value = this.dtype.parse(lex);
            this.wellformed = true;
        }
        catch (DatatypeFormatException e) {
            if (JenaParameters.enableEagerLiteralValidation) {
                e.fillInStackTrace();
                throw e;
            }
            this.wellformed = false;
            this.exceptionMsg = e.getMessage();
        }
    }

    protected void normalize() {
        if (this.dtype != null && this.value != null) {
            this.dtype = this.dtype.normalizeSubType(this.value, this.dtype);
        }
    }

    @Override
    public boolean isXML() {
        return this.dtype == XMLLiteralType.theXMLLiteralType && this.wellformed;
    }

    @Override
    public boolean isWellFormed() {
        return this.dtype != null && this.wellformed;
    }

    @Override
    public boolean isWellFormedRaw() {
        return this.wellformed;
    }

    @Override
    public String toString(boolean quoting) {
        StringBuffer b = new StringBuffer();
        if (quoting) {
            b.append('\"');
        }
        b.append(this.getLexicalForm());
        if (quoting) {
            b.append('\"');
        }
        if (this.lang != null && !this.lang.equals("")) {
            b.append("@").append(this.lang);
        }
        if (this.dtype != null) {
            b.append("^^").append(this.dtype.getURI());
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    @Override
    public String getLexicalForm() {
        if (this.lexicalForm == null) {
            this.lexicalForm = this.dtype == null ? this.value.toString() : this.dtype.unparse(this.value);
        }
        return this.lexicalForm;
    }

    @Override
    public Object getIndexingValue() {
        return this.isXML() ? this : (!this.lang.equals("") ? this.getLexicalForm() + "@" + this.lang.toLowerCase(Locale.ENGLISH) : (this.wellformed ? this.getValue() : this.getLexicalForm()));
    }

    @Override
    public String language() {
        return this.lang;
    }

    @Override
    public Object getValue() throws DatatypeFormatException {
        if (this.wellformed) {
            return this.value;
        }
        throw new DatatypeFormatException(this.lexicalForm, this.dtype, this.exceptionMsg);
    }

    @Override
    public RDFDatatype getDatatype() {
        return this.dtype;
    }

    @Override
    public String getDatatypeURI() {
        if (this.dtype == null) {
            return null;
        }
        return this.dtype.getURI();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof LiteralLabel)) {
            return false;
        }
        LiteralLabel otherLiteral = (LiteralLabel)other;
        boolean typeEqual = this.dtype == null ? otherLiteral.getDatatype() == null : this.dtype.equals(otherLiteral.getDatatype());
        boolean langEqual = this.dtype == null ? this.lang.equals(otherLiteral.language()) : true;
        return typeEqual && langEqual && this.getLexicalForm().equals(otherLiteral.getLexicalForm());
    }

    @Override
    public boolean sameValueAs(LiteralLabel other) {
        if (other == null) {
            return false;
        }
        if (!this.wellformed || !other.isWellFormedRaw()) {
            return this.areIllFormedLiteralsSameValueAs(other);
        }
        return this.dtype == null ? this.isPlainLiteralSameValueAsOther(other) : this.isTypedLiteralSameValueAsOther(other);
    }

    private boolean areIllFormedLiteralsSameValueAs(LiteralLabel other) {
        return !other.isWellFormedRaw() && this.sameByFormAndLanguage(other);
    }

    private boolean sameByFormAndLanguage(LiteralLabel other) {
        String lex2;
        String lex1 = this.getLexicalForm();
        return lex1.equals(lex2 = other.getLexicalForm()) && this.lang.equalsIgnoreCase(other.language());
    }

    private boolean isTypedLiteralSameValueAsOther(LiteralLabel other) {
        return other.getDatatype() == null ? this.looksLikePlainString(this) && this.sameByFormAndLanguage(other) : this.dtype.isEqual(this, other);
    }

    private boolean isPlainLiteralSameValueAsOther(LiteralLabel other) {
        return other.getDatatype() == null || this.looksLikePlainString(other) ? this.sameByFormAndLanguage(other) : false;
    }

    private boolean looksLikePlainString(LiteralLabel L) {
        return L.getDatatype().equals(XSDDatatype.XSDstring) && JenaParameters.enablePlainLiteralSameAsString;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.dtype == null ? this.getDefaultHashcode() : this.dtype.getHashCode(this);
        }
        return this.hash;
    }

    @Override
    public int getDefaultHashcode() {
        return (this.wellformed ? this.value : this.getLexicalForm()).hashCode();
    }
}

