/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web.auth;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.atlas.web.auth.AbstractScopedAuthenticator;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;

public class DelegatingAuthenticator
extends AbstractScopedAuthenticator<HttpAuthenticator> {
    private Map<URI, HttpAuthenticator> authenticators = new HashMap<URI, HttpAuthenticator>();

    public DelegatingAuthenticator(URI target, HttpAuthenticator authenticator) {
        if (target == null) {
            throw new IllegalArgumentException("Target URI cannot be null");
        }
        this.authenticators.put(target, authenticator);
    }

    public DelegatingAuthenticator(Map<URI, HttpAuthenticator> authenticators) {
        this.authenticators.putAll(authenticators);
    }

    @Override
    public void apply(AbstractHttpClient client, HttpContext context, URI target) {
        HttpAuthenticator authenticator = (HttpAuthenticator)this.findCredentials(target);
        if (authenticator != null) {
            authenticator.apply(client, context, target);
        }
    }

    @Override
    protected HttpAuthenticator getCredentials(URI target) {
        return this.authenticators.get(target);
    }

    @Override
    protected String getUserNameFromCredentials(HttpAuthenticator credentials) {
        return null;
    }

    @Override
    protected char[] getPasswordFromCredentials(HttpAuthenticator credentials) {
        return null;
    }
}

