/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.foresite.jena;

import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.foresite.Agent;
import org.dspace.foresite.OREException;
import org.dspace.foresite.OREFactory;
import org.dspace.foresite.OREModel;
import org.dspace.foresite.OREResource;
import org.dspace.foresite.Predicate;
import org.dspace.foresite.Triple;
import org.dspace.foresite.TripleSelector;
import org.dspace.foresite.Vocab;
import org.dspace.foresite.jena.AgentJena;
import org.dspace.foresite.jena.GraphResource;
import org.dspace.foresite.jena.JenaOREFactory;
import org.dspace.foresite.jena.ORE;
import org.dspace.foresite.jena.TripleJena;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OREResourceJena
implements OREResource,
GraphResource {
    protected Model model = ModelFactory.createDefaultModel();
    protected Resource res;

    protected OREResourceJena() {
    }

    @Override
    public URI getURI() throws OREException {
        try {
            String uri = this.res.getURI();
            if (uri != null) {
                return new URI(uri);
            }
            return null;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    @Override
    public List<Triple> listTriples() throws OREException {
        StmtIterator itr = this.res.listProperties();
        ArrayList<Triple> triples = new ArrayList<Triple>();
        while (itr.hasNext()) {
            Statement statement = itr.nextStatement();
            Triple triple = JenaOREFactory.createTriple(statement);
            triples.add(triple);
        }
        return triples;
    }

    @Override
    public List<Triple> listAllTriples() throws OREException {
        StmtIterator itr = this.model.listStatements();
        ArrayList<Triple> triples = new ArrayList<Triple>();
        while (itr.hasNext()) {
            Statement statement = itr.nextStatement();
            Triple triple = JenaOREFactory.createTriple(statement);
            triples.add(triple);
        }
        return triples;
    }

    @Override
    public List<Triple> listTriples(TripleSelector selector) throws OREException {
        selector.setSubjectURI(this.getURI());
        return this.listAllTriples(selector);
    }

    @Override
    public List<Triple> listAllTriples(TripleSelector selector) throws OREException {
        URI subjectURI = selector.getSubjectURI();
        Predicate predInit = selector.getPredicate();
        URI objectURI = selector.getObjectURI();
        Object objectLiteral = selector.getLiteral();
        return this.listTriples(subjectURI, predInit, objectURI, objectLiteral);
    }

    @Override
    public void addTriples(List<Triple> triples) throws OREException {
        for (Triple triple : triples) {
            this.addTriple(triple);
        }
    }

    @Override
    public void addTriple(Triple triple) throws OREException {
        Statement statement = JenaOREFactory.createStatement(triple);
        boolean connected = false;
        Resource subject = statement.getSubject();
        SimpleSelector selector1 = new SimpleSelector(subject, null, (RDFNode)null);
        SimpleSelector selector2 = new SimpleSelector(null, null, (RDFNode)subject);
        StmtIterator itr1 = this.model.listStatements((Selector)selector1);
        StmtIterator itr2 = this.model.listStatements((Selector)selector2);
        if (itr1.hasNext() || itr2.hasNext()) {
            connected = true;
        }
        RDFNode object = statement.getObject();
        Resource oResource = null;
        if (object instanceof Resource) {
            oResource = (Resource)object;
        }
        if (oResource != null && !connected) {
            SimpleSelector selector3 = new SimpleSelector(oResource, null, (RDFNode)null);
            SimpleSelector selector4 = new SimpleSelector(null, null, (RDFNode)oResource);
            StmtIterator itr3 = this.model.listStatements((Selector)selector3);
            StmtIterator itr4 = this.model.listStatements((Selector)selector4);
            if (itr3.hasNext() || itr4.hasNext()) {
                connected = true;
            }
        }
        if (!connected) {
            throw new OREException("Illegal Triple; graph must be connected");
        }
        this.model.add(statement);
    }

    @Override
    public void removeTriple(Triple triple) throws OREException {
        Statement statement = JenaOREFactory.createStatement(triple);
        this.model.remove(statement);
    }

    @Override
    public Triple createTriple(Predicate pred, URI uri) throws OREException {
        Triple triple = OREFactory.createTriple((OREResource)this, pred, uri);
        this.addTriple(triple);
        return triple;
    }

    @Override
    public Triple createTriple(Predicate pred, Object literal) throws OREException {
        Triple triple = OREFactory.createTriple((OREResource)this, pred, literal);
        this.addTriple(triple);
        return triple;
    }

    @Override
    public Triple createTriple(URI pred, URI uri) throws OREException {
        Predicate predicate = new Predicate(pred);
        return this.createTriple(predicate, uri);
    }

    @Override
    public Triple createTriple(URI pred, Object literal) throws OREException {
        Predicate predicate = new Predicate(pred);
        return this.createTriple(predicate, literal);
    }

    @Override
    public Triple createTriple(Vocab pred, URI uri) throws OREException {
        Predicate predicate = new Predicate(pred.uri());
        return this.createTriple(predicate, uri);
    }

    @Override
    public Triple createTriple(Vocab pred, Object literal) throws OREException {
        Predicate predicate = new Predicate(pred.uri());
        return this.createTriple(predicate, literal);
    }

    @Override
    public List<Agent> getCreators() {
        ArrayList<Agent> agents = new ArrayList<Agent>();
        StmtIterator itr = this.res.listProperties(DC.creator);
        while (itr.hasNext()) {
            Statement statement = itr.nextStatement();
            Agent agent = JenaOREFactory.createAgent((Resource)statement.getObject());
            agents.add(agent);
        }
        return agents;
    }

    @Override
    public void setCreators(List<Agent> creators) {
        this.clearCreators();
        for (Agent creator : creators) {
            this.addCreator(creator);
        }
    }

    @Override
    public void addCreator(Agent creator) {
        Resource resource = ((AgentJena)creator).getResource();
        this.res.addProperty(DC.creator, (RDFNode)resource);
        this.addResourceToModel(resource);
    }

    @Override
    public void clearCreators() {
        List<Agent> creators = this.getCreators();
        for (Agent creator : creators) {
            Model cModel = ((AgentJena)creator).getModel();
            StmtIterator itr = cModel.listStatements();
            this.model.remove(itr);
        }
    }

    @Override
    public List<Agent> getAgents(URI relationship) throws OREException {
        ArrayList<Agent> agents = new ArrayList<Agent>();
        StmtIterator itr = this.res.listProperties(this.model.createProperty(relationship.toString()));
        while (itr.hasNext()) {
            Statement statement = itr.nextStatement();
            Agent agent = JenaOREFactory.createAgent((Resource)statement.getObject());
            agents.add(agent);
        }
        return agents;
    }

    @Override
    public void setAgents(List<URI> relationship, Agent agent) throws OREException {
        this.clearCreators();
        for (URI relation : relationship) {
            this.addAgent(relation, agent);
        }
    }

    @Override
    public void addAgent(URI relationship, Agent agent) throws OREException {
        Resource resource = ((AgentJena)agent).getResource();
        this.res.addProperty(this.model.createProperty(relationship.toString()), (RDFNode)resource);
        this.addResourceToModel(resource);
    }

    @Override
    public void clearAgents(URI relationship) throws OREException {
        List<Agent> agents = this.getAgents(relationship);
        for (Agent agent : agents) {
            Model cModel = ((AgentJena)agent).getModel();
            StmtIterator itr = cModel.listStatements();
            this.model.remove(itr);
        }
    }

    @Override
    public List<URI> getTypes() throws OREException {
        try {
            ArrayList<URI> types = new ArrayList<URI>();
            StmtIterator itr = this.res.listProperties(RDF.type);
            while (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                RDFNode node = statement.getObject();
                if (node instanceof Resource) {
                    types.add(new URI(((Resource)node).getURI()));
                    continue;
                }
                if (!(node instanceof Literal)) continue;
                throw new OREException("Type MAY NOT be Literal; error in graph");
            }
            return types;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void setTypes(List<URI> types) {
        this.clearTypes();
        for (URI type : types) {
            this.addType(type);
        }
    }

    @Override
    public void addType(URI type) {
        this.res.addProperty(RDF.type, (RDFNode)this.model.createResource(type.toString()));
    }

    @Override
    public void clearTypes() {
        StmtIterator itr = this.res.listProperties(RDF.type);
        this.model.remove(itr);
    }

    @Override
    public void addRDF(String rdf, String format) throws OREException {
        ByteArrayInputStream is = new ByteArrayInputStream(rdf.getBytes());
        Model model = ModelFactory.createDefaultModel();
        model = model.read((InputStream)is, null, format);
        this.addModelToModel(model);
    }

    @Override
    public abstract void empty() throws OREException;

    @Override
    public abstract void detach() throws OREException;

    @Override
    public Resource getResource() {
        return this.res;
    }

    @Override
    public void setResource(Resource resource) {
        StmtIterator itr = resource.listProperties();
        this.model.removeAll();
        this.model.add(itr);
        this.res = (Resource)resource.inModel(this.model);
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public void setModel(Model model, URI resourceURI) throws OREException {
        String ident = resourceURI.toString();
        String rx = ".+://.+";
        Pattern p = Pattern.compile(rx);
        Matcher m = p.matcher(ident);
        if (!m.matches()) {
            throw new OREException("Illegal URI: " + resourceURI.toString() + "; GraphResource implementer requires a protocol-based URI");
        }
        this.model = model;
        this.res = model.createResource(resourceURI.toString());
    }

    @Override
    public void setModel(Model model, AnonId blankID) throws OREException {
        this.model = model;
        this.res = model.createResource(blankID);
    }

    protected List<Triple> listTriples(URI subjectURI, Predicate predInit, URI objectURI, Object objectLiteral) throws OREException {
        try {
            Resource subject = null;
            if (subjectURI != null) {
                subject = this.model.createResource(subjectURI.toString());
            }
            Property predicate = null;
            if (predInit != null) {
                predicate = this.model.createProperty(predInit.getURI().toString());
            }
            Literal object = null;
            if (objectLiteral != null) {
                object = this.model.createTypedLiteral(objectLiteral);
            } else if (objectURI != null) {
                object = this.model.createResource(objectURI.toString());
            }
            SimpleSelector sel = new SimpleSelector(subject, predicate, (RDFNode)object);
            ArrayList<Triple> triples = new ArrayList<Triple>();
            StmtIterator itr = this.model.listStatements((Selector)sel);
            while (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                Resource resource = statement.getSubject();
                Property property = statement.getPredicate();
                Predicate pred = new Predicate();
                pred.setNamespace(property.getNameSpace());
                pred.setName(property.getLocalName());
                pred.setURI(new URI(property.getURI()));
                TripleJena triple = new TripleJena();
                triple.initialise(new URI(resource.getURI()));
                RDFNode node = statement.getObject();
                if (node instanceof Literal) {
                    String literal = ((Literal)node).getLexicalForm();
                    triple.relate(pred, literal);
                } else {
                    URI obj = new URI(((Resource)node).getURI());
                    triple.relate(pred, obj);
                }
                triples.add(triple);
            }
            return triples;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    protected void addResourceToModel(Resource resource) {
        StmtIterator itr = resource.listProperties();
        this.model.add(itr);
    }

    protected void addModelToModel(Model externalModel) {
        StmtIterator itr = externalModel.listStatements();
        this.model.add(itr);
    }

    protected void recursiveRemove(Resource resource) throws OREException {
        SimpleSelector self = new SimpleSelector(resource, null, (RDFNode)null);
        StmtIterator itr1 = this.model.listStatements((Selector)self);
        while (itr1.hasNext()) {
            Statement statement = itr1.nextStatement();
            RDFNode node = statement.getObject();
            if (!(node instanceof Resource) || !this.recursivelyRemovable(statement)) continue;
            this.recursiveRemove((Resource)node);
        }
        StmtIterator itr2 = this.model.listStatements((Selector)self);
        this.model.remove(itr2);
    }

    protected boolean recursivelyRemovable(Statement stmt) throws OREException {
        try {
            boolean removable = false;
            Resource resource = (Resource)stmt.getObject();
            Property predicate = stmt.getPredicate();
            Vocab pred = Vocab.getByURI(new URI(predicate.getURI()));
            Vocab type = OREModel.getObjectOf(pred);
            if (type == null) {
                List<Vocab> predSubject = this.getORESubjectOfPredicates(resource);
                if (predSubject.size() > 1) {
                    throw new OREException("Malformed ORE Resource: ambiguous type");
                }
                if (predSubject.size() == 1) {
                    type = OREModel.getSubjectOf(predSubject.get(0));
                }
                if (type == null) {
                    List<Vocab> predObject = this.getOREObjectOfPredicates(resource);
                    if (predObject.size() > 1) {
                        throw new OREException("Malformed ORE Resource: ambiguous type");
                    }
                    if (predObject.size() == 1) {
                        type = OREModel.getSubjectOf(predSubject.get(0));
                    }
                }
            }
            if (!this.aboveInHierarchy(type)) {
                return false;
            }
            return !this.isUsedElsewhere(resource);
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    protected Vocab getOREType(Resource resource) throws OREException {
        try {
            Vocab type = Vocab.getByURI(new URI(resource.getURI()));
            if (type.inNamespace("ore")) {
                return type;
            }
            return null;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    protected boolean aboveInHierarchy(Vocab type) throws OREException {
        if (type == null) {
            return true;
        }
        Vocab rtype = this.getOREType();
        return false;
    }

    protected boolean isUsedElsewhere(Resource resource) throws OREException {
        return false;
    }

    protected void prune() {
    }

    protected List<Vocab> getOREObjectOfPredicates(Resource resource) {
        StmtIterator itr7;
        StmtIterator itr6;
        StmtIterator itr5;
        StmtIterator itr4;
        StmtIterator itr3;
        StmtIterator itr2;
        ArrayList<Vocab> predicates = new ArrayList<Vocab>();
        SimpleSelector s1 = new SimpleSelector(null, ORE.aggregates, (RDFNode)resource);
        SimpleSelector s2 = new SimpleSelector(null, ORE.describes, (RDFNode)resource);
        SimpleSelector s3 = new SimpleSelector(null, ORE.isAggregatedBy, (RDFNode)resource);
        SimpleSelector s4 = new SimpleSelector(null, ORE.isDescribedBy, (RDFNode)resource);
        SimpleSelector s5 = new SimpleSelector(null, ORE.lineage, (RDFNode)resource);
        SimpleSelector s6 = new SimpleSelector(null, ORE.proxyFor, (RDFNode)resource);
        SimpleSelector s7 = new SimpleSelector(null, ORE.proxyIn, (RDFNode)resource);
        StmtIterator itr1 = this.model.listStatements((Selector)s1);
        if (itr1.hasNext()) {
            predicates.add(Vocab.ore_aggregates);
        }
        if ((itr2 = this.model.listStatements((Selector)s2)).hasNext()) {
            predicates.add(Vocab.ore_describes);
        }
        if ((itr3 = this.model.listStatements((Selector)s3)).hasNext()) {
            predicates.add(Vocab.ore_isAggregatedBy);
        }
        if ((itr4 = this.model.listStatements((Selector)s4)).hasNext()) {
            predicates.add(Vocab.ore_isDescribedBy);
        }
        if ((itr5 = this.model.listStatements((Selector)s5)).hasNext()) {
            predicates.add(Vocab.ore_lineage);
        }
        if ((itr6 = this.model.listStatements((Selector)s6)).hasNext()) {
            predicates.add(Vocab.ore_proxyFor);
        }
        if ((itr7 = this.model.listStatements((Selector)s7)).hasNext()) {
            predicates.add(Vocab.ore_proxyIn);
        }
        return predicates;
    }

    protected List<Vocab> getORESubjectOfPredicates(Resource resource) {
        StmtIterator itr7;
        StmtIterator itr6;
        StmtIterator itr5;
        StmtIterator itr4;
        StmtIterator itr3;
        StmtIterator itr2;
        ArrayList<Vocab> predicates = new ArrayList<Vocab>();
        SimpleSelector s1 = new SimpleSelector(resource, ORE.aggregates, (RDFNode)null);
        SimpleSelector s2 = new SimpleSelector(resource, ORE.describes, (RDFNode)null);
        SimpleSelector s3 = new SimpleSelector(resource, ORE.isAggregatedBy, (RDFNode)null);
        SimpleSelector s4 = new SimpleSelector(resource, ORE.isDescribedBy, (RDFNode)null);
        SimpleSelector s5 = new SimpleSelector(resource, ORE.lineage, (RDFNode)null);
        SimpleSelector s6 = new SimpleSelector(resource, ORE.proxyFor, (RDFNode)null);
        SimpleSelector s7 = new SimpleSelector(resource, ORE.proxyIn, (RDFNode)null);
        StmtIterator itr1 = this.model.listStatements((Selector)s1);
        if (itr1.hasNext()) {
            predicates.add(Vocab.ore_aggregates);
        }
        if ((itr2 = this.model.listStatements((Selector)s2)).hasNext()) {
            predicates.add(Vocab.ore_describes);
        }
        if ((itr3 = this.model.listStatements((Selector)s3)).hasNext()) {
            predicates.add(Vocab.ore_isAggregatedBy);
        }
        if ((itr4 = this.model.listStatements((Selector)s4)).hasNext()) {
            predicates.add(Vocab.ore_isDescribedBy);
        }
        if ((itr5 = this.model.listStatements((Selector)s5)).hasNext()) {
            predicates.add(Vocab.ore_lineage);
        }
        if ((itr6 = this.model.listStatements((Selector)s6)).hasNext()) {
            predicates.add(Vocab.ore_proxyFor);
        }
        if ((itr7 = this.model.listStatements((Selector)s7)).hasNext()) {
            predicates.add(Vocab.ore_proxyIn);
        }
        return predicates;
    }
}

