/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid.authenticatedqueryservice;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import org.apache.axis.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.ecogrid.authenticatedqueryservice.stub.AuthenticatedQueryServiceLocator;
import org.ecoinformatics.ecogrid.authenticatedqueryservice.stub.AuthenticatedQueryServicePortType;
import org.ecoinformatics.ecogrid.authenticatedqueryservice.stub.QueryElementType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryType;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;
import org.ecoinformatics.ecogrid.queryservice.util.EcogridQueryParser;
import org.ecoinformatics.ecogrid.queryservice.util.EcogridResultsetTransformer;

public class AuthenticatedQueryServiceClient {
    private AuthenticatedQueryServicePortType ecogrid;
    static Log log = LogFactory.getLog((Class)AuthenticatedQueryServiceClient.class);

    public AuthenticatedQueryServiceClient(URL uRL) throws Exception {
        long l = System.currentTimeMillis();
        AuthenticatedQueryServiceLocator authenticatedQueryServiceLocator = new AuthenticatedQueryServiceLocator();
        this.ecogrid = authenticatedQueryServiceLocator.getQuery(uRL);
        Stub stub = (Stub)this.ecogrid;
        stub.setTimeout(10000000);
        long l2 = System.currentTimeMillis();
        log.debug((Object)("The time to create instance is =========== " + (l2 - l) / 1000L));
    }

    public AuthenticatedQueryServiceClient(String string) throws Exception {
        this(new URL(string));
    }

    public static QueryType reader2QueryType(Reader reader) {
        QueryType queryType = null;
        try {
            EcogridQueryParser ecogridQueryParser = new EcogridQueryParser(reader);
            ecogridQueryParser.parseXML();
            queryType = ecogridQueryParser.getEcogridQuery();
        }
        catch (Exception exception) {
            log.error((Object)("Error parsing the reader into QueryType object!  " + exception.getMessage()));
            exception.printStackTrace();
        }
        return queryType;
    }

    public ResultsetType query(QueryType queryType, String string) throws Exception {
        QueryElementType queryElementType = new QueryElementType(queryType, string);
        ResultsetType resultsetType = null;
        if (this.ecogrid != null) {
            long l = System.currentTimeMillis();
            resultsetType = this.ecogrid.query(queryElementType);
            long l2 = System.currentTimeMillis();
            log.debug((Object)("The authQuery time is ==============" + (l2 - l) / 1000L));
        }
        return resultsetType;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: java  AuthenticatedQueryServiceClient <service url> <query_filename> (outputfile) [sessionId]");
            System.exit(0);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = null;
        String string4 = null;
        if (stringArray.length == 3) {
            string3 = stringArray[2];
        }
        if (stringArray.length == 4) {
            string4 = stringArray[3];
        }
        try {
            AuthenticatedQueryServiceClient authenticatedQueryServiceClient = new AuthenticatedQueryServiceClient(string);
            String string5 = null;
            File file = new File(string2);
            FileReader fileReader = new FileReader(file);
            ResultsetType resultsetType = null;
            if (string4 != null) {
                resultsetType = authenticatedQueryServiceClient.query(AuthenticatedQueryServiceClient.reader2QueryType(fileReader), string4);
            }
            System.out.println("Result done");
            string5 = EcogridResultsetTransformer.toXMLString(resultsetType);
            System.out.println(string5);
            if (string3 != null) {
                System.out.println("Creating outputfile: " + string3);
                File file2 = new File(string3);
                FileWriter fileWriter = new FileWriter(file2);
                PrintWriter printWriter = new PrintWriter(fileWriter);
                printWriter.println(string5);
                printWriter.flush();
                printWriter.close();
            }
        }
        catch (Exception exception) {
            System.err.println("Exception in main : " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

