/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.AbstractCache$StatsCounter;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheLoader;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheLoader$InvalidCacheLoadException;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$AccessQueue;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$LoadingValueReference;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$ReferenceEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$Segment$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$ValueReference;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$WeightedStrongValueReference;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$WriteQueue;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.RemovalCause;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.RemovalNotification;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.ExecutionError;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.ListenableFuture;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.UncheckedExecutionException;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.Uninterruptibles;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class LocalCache$Segment
extends ReentrantLock {
    final LocalCache map;
    volatile int count;
    @GuardedBy(value="Segment.this")
    int totalWeight;
    int modCount;
    int threshold;
    volatile AtomicReferenceArray table;
    final long maxSegmentWeight;
    final ReferenceQueue keyReferenceQueue;
    final ReferenceQueue valueReferenceQueue;
    final Queue recencyQueue;
    final AtomicInteger readCount = new AtomicInteger();
    @GuardedBy(value="Segment.this")
    final Queue writeQueue;
    @GuardedBy(value="Segment.this")
    final Queue accessQueue;
    final AbstractCache$StatsCounter statsCounter;

    LocalCache$Segment(LocalCache localCache, int n, long l, AbstractCache$StatsCounter abstractCache$StatsCounter) {
        this.map = localCache;
        this.maxSegmentWeight = l;
        this.statsCounter = (AbstractCache$StatsCounter)Preconditions.checkNotNull(abstractCache$StatsCounter);
        this.initTable(this.newEntryArray(n));
        this.keyReferenceQueue = localCache.usesKeyReferences() ? new ReferenceQueue() : null;
        this.valueReferenceQueue = localCache.usesValueReferences() ? new ReferenceQueue() : null;
        this.recencyQueue = localCache.usesAccessQueue() ? new ConcurrentLinkedQueue() : LocalCache.discardingQueue();
        this.writeQueue = localCache.usesWriteQueue() ? new LocalCache$WriteQueue() : LocalCache.discardingQueue();
        this.accessQueue = localCache.usesAccessQueue() ? new LocalCache$AccessQueue() : LocalCache.discardingQueue();
    }

    AtomicReferenceArray newEntryArray(int n) {
        return new AtomicReferenceArray(n);
    }

    void initTable(AtomicReferenceArray atomicReferenceArray) {
        this.threshold = atomicReferenceArray.length() * 3 / 4;
        if (!this.map.customWeigher() && (long)this.threshold == this.maxSegmentWeight) {
            ++this.threshold;
        }
        this.table = atomicReferenceArray;
    }

    @GuardedBy(value="Segment.this")
    LocalCache$ReferenceEntry newEntry(Object object, int n, @Nullable LocalCache$ReferenceEntry localCache$ReferenceEntry) {
        return this.map.entryFactory.newEntry(this, Preconditions.checkNotNull(object), n, localCache$ReferenceEntry);
    }

    @GuardedBy(value="Segment.this")
    LocalCache$ReferenceEntry copyEntry(LocalCache$ReferenceEntry localCache$ReferenceEntry, LocalCache$ReferenceEntry localCache$ReferenceEntry2) {
        if (localCache$ReferenceEntry.getKey() == null) {
            return null;
        }
        LocalCache$ValueReference localCache$ValueReference = localCache$ReferenceEntry.getValueReference();
        Object object = localCache$ValueReference.get();
        if (object == null && localCache$ValueReference.isActive()) {
            return null;
        }
        LocalCache$ReferenceEntry localCache$ReferenceEntry3 = this.map.entryFactory.copyEntry(this, localCache$ReferenceEntry, localCache$ReferenceEntry2);
        localCache$ReferenceEntry3.setValueReference(localCache$ValueReference.copyFor(this.valueReferenceQueue, object, localCache$ReferenceEntry3));
        return localCache$ReferenceEntry3;
    }

    @GuardedBy(value="Segment.this")
    void setValue(LocalCache$ReferenceEntry localCache$ReferenceEntry, Object object, Object object2, long l) {
        LocalCache$ValueReference localCache$ValueReference = localCache$ReferenceEntry.getValueReference();
        int n = this.map.weigher.weigh(object, object2);
        Preconditions.checkState(n >= 0, "Weights must be non-negative");
        LocalCache$ValueReference localCache$ValueReference2 = this.map.valueStrength.referenceValue(this, localCache$ReferenceEntry, object2, n);
        localCache$ReferenceEntry.setValueReference(localCache$ValueReference2);
        this.recordWrite(localCache$ReferenceEntry, n, l);
        localCache$ValueReference.notifyNewValue(object2);
    }

    Object get(Object object, int n, CacheLoader cacheLoader) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(cacheLoader);
        try {
            Object object2;
            if (this.count != 0 && (object2 = this.getEntry(object, n)) != null) {
                long l = this.map.ticker.read();
                Object object3 = this.getLiveValue((LocalCache$ReferenceEntry)object2, l);
                if (object3 != null) {
                    this.recordRead((LocalCache$ReferenceEntry)object2, l);
                    this.statsCounter.recordHits(1);
                    Object object4 = this.scheduleRefresh((LocalCache$ReferenceEntry)object2, object, n, object3, l, cacheLoader);
                    return object4;
                }
                LocalCache$ValueReference localCache$ValueReference = object2.getValueReference();
                if (localCache$ValueReference.isLoading()) {
                    Object object5 = this.waitForLoadingValue((LocalCache$ReferenceEntry)object2, object, localCache$ValueReference);
                    return object5;
                }
            }
            object2 = this.lockedGetOrLoad(object, n, cacheLoader);
            return object2;
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof Error) {
                throw new ExecutionError((Error)throwable);
            }
            if (throwable instanceof RuntimeException) {
                throw new UncheckedExecutionException(throwable);
            }
            throw executionException;
        }
        finally {
            this.postReadCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object lockedGetOrLoad(Object object, int n, CacheLoader cacheLoader) {
        LocalCache$ReferenceEntry localCache$ReferenceEntry;
        LocalCache$ValueReference localCache$ValueReference = null;
        LocalCache$LoadingValueReference localCache$LoadingValueReference = null;
        boolean bl = true;
        this.lock();
        try {
            LocalCache$ReferenceEntry localCache$ReferenceEntry2;
            long l = this.map.ticker.read();
            this.preWriteCleanup(l);
            int n2 = this.count - 1;
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n3 = n & atomicReferenceArray.length() - 1;
            for (localCache$ReferenceEntry = localCache$ReferenceEntry2 = (LocalCache$ReferenceEntry)atomicReferenceArray.get(n3); localCache$ReferenceEntry != null; localCache$ReferenceEntry = localCache$ReferenceEntry.getNext()) {
                Object object2 = localCache$ReferenceEntry.getKey();
                if (localCache$ReferenceEntry.getHash() != n || object2 == null || !this.map.keyEquivalence.equivalent(object, object2)) continue;
                localCache$ValueReference = localCache$ReferenceEntry.getValueReference();
                if (localCache$ValueReference.isLoading()) {
                    bl = false;
                    break;
                }
                Object object3 = localCache$ValueReference.get();
                if (object3 == null) {
                    this.enqueueNotification(object2, n, localCache$ValueReference, RemovalCause.COLLECTED);
                } else if (this.map.isExpired(localCache$ReferenceEntry, l)) {
                    this.enqueueNotification(object2, n, localCache$ValueReference, RemovalCause.EXPIRED);
                } else {
                    this.recordLockedRead(localCache$ReferenceEntry, l);
                    this.statsCounter.recordHits(1);
                    Object object4 = object3;
                    return object4;
                }
                this.writeQueue.remove(localCache$ReferenceEntry);
                this.accessQueue.remove(localCache$ReferenceEntry);
                this.count = n2;
                break;
            }
            if (bl) {
                localCache$LoadingValueReference = new LocalCache$LoadingValueReference();
                if (localCache$ReferenceEntry == null) {
                    localCache$ReferenceEntry = this.newEntry(object, n, localCache$ReferenceEntry2);
                    localCache$ReferenceEntry.setValueReference(localCache$LoadingValueReference);
                    atomicReferenceArray.set(n3, localCache$ReferenceEntry);
                } else {
                    localCache$ReferenceEntry.setValueReference(localCache$LoadingValueReference);
                }
            }
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
        if (bl) {
            try {
                LocalCache$ReferenceEntry localCache$ReferenceEntry3 = localCache$ReferenceEntry;
                synchronized (localCache$ReferenceEntry3) {
                    Object object5 = this.loadSync(object, n, localCache$LoadingValueReference, cacheLoader);
                    return object5;
                }
            }
            finally {
                this.statsCounter.recordMisses(1);
            }
        }
        return this.waitForLoadingValue(localCache$ReferenceEntry, object, localCache$ValueReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object waitForLoadingValue(LocalCache$ReferenceEntry localCache$ReferenceEntry, Object object, LocalCache$ValueReference localCache$ValueReference) {
        if (!localCache$ValueReference.isLoading()) {
            throw new AssertionError();
        }
        Preconditions.checkState(!Thread.holdsLock(localCache$ReferenceEntry), "Recursive load of: %s", object);
        try {
            Object object2 = localCache$ValueReference.waitForValue();
            if (object2 == null) {
                throw new CacheLoader$InvalidCacheLoadException("CacheLoader returned null for key " + object + ".");
            }
            long l = this.map.ticker.read();
            this.recordRead(localCache$ReferenceEntry, l);
            Object object3 = object2;
            return object3;
        }
        finally {
            this.statsCounter.recordMisses(1);
        }
    }

    Object loadSync(Object object, int n, LocalCache$LoadingValueReference localCache$LoadingValueReference, CacheLoader cacheLoader) {
        ListenableFuture listenableFuture = localCache$LoadingValueReference.loadFuture(object, cacheLoader);
        return this.getAndRecordStats(object, n, localCache$LoadingValueReference, listenableFuture);
    }

    ListenableFuture loadAsync(Object object, int n, LocalCache$LoadingValueReference localCache$LoadingValueReference, CacheLoader cacheLoader) {
        ListenableFuture listenableFuture = localCache$LoadingValueReference.loadFuture(object, cacheLoader);
        listenableFuture.addListener(new LocalCache$Segment$1(this, object, n, localCache$LoadingValueReference, listenableFuture), LocalCache.sameThreadExecutor);
        return listenableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getAndRecordStats(Object object, int n, LocalCache$LoadingValueReference localCache$LoadingValueReference, ListenableFuture listenableFuture) {
        Object object2 = null;
        try {
            object2 = Uninterruptibles.getUninterruptibly(listenableFuture);
            if (object2 == null) {
                throw new CacheLoader$InvalidCacheLoadException("CacheLoader returned null for key " + object + ".");
            }
            this.statsCounter.recordLoadSuccess(localCache$LoadingValueReference.elapsedNanos());
            this.storeLoadedValue(object, n, localCache$LoadingValueReference, object2);
            Object object3 = object2;
            return object3;
        }
        finally {
            if (object2 == null) {
                this.statsCounter.recordLoadException(localCache$LoadingValueReference.elapsedNanos());
                this.removeLoadingValue(object, n, localCache$LoadingValueReference);
            }
        }
    }

    Object scheduleRefresh(LocalCache$ReferenceEntry localCache$ReferenceEntry, Object object, int n, Object object2, long l, CacheLoader cacheLoader) {
        Object object3;
        if (this.map.refreshes() && l - localCache$ReferenceEntry.getWriteTime() > this.map.refreshNanos && !localCache$ReferenceEntry.getValueReference().isLoading() && (object3 = this.refresh(object, n, cacheLoader, true)) != null) {
            return object3;
        }
        return object2;
    }

    @Nullable
    Object refresh(Object object, int n, CacheLoader cacheLoader, boolean bl) {
        LocalCache$LoadingValueReference localCache$LoadingValueReference = this.insertLoadingValueReference(object, n, bl);
        if (localCache$LoadingValueReference == null) {
            return null;
        }
        ListenableFuture listenableFuture = this.loadAsync(object, n, localCache$LoadingValueReference, cacheLoader);
        if (listenableFuture.isDone()) {
            try {
                return Uninterruptibles.getUninterruptibly(listenableFuture);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    LocalCache$LoadingValueReference insertLoadingValueReference(Object object, int n, boolean bl) {
        LocalCache$ReferenceEntry localCache$ReferenceEntry = null;
        this.lock();
        try {
            Object object2;
            LocalCache$ReferenceEntry localCache$ReferenceEntry2;
            long l = this.map.ticker.read();
            this.preWriteCleanup(l);
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n2 = n & atomicReferenceArray.length() - 1;
            for (localCache$ReferenceEntry = localCache$ReferenceEntry2 = (LocalCache$ReferenceEntry)atomicReferenceArray.get(n2); localCache$ReferenceEntry != null; localCache$ReferenceEntry = localCache$ReferenceEntry.getNext()) {
                object2 = localCache$ReferenceEntry.getKey();
                if (localCache$ReferenceEntry.getHash() != n || object2 == null || !this.map.keyEquivalence.equivalent(object, object2)) continue;
                LocalCache$ValueReference localCache$ValueReference = localCache$ReferenceEntry.getValueReference();
                if (localCache$ValueReference.isLoading() || bl && l - localCache$ReferenceEntry.getWriteTime() < this.map.refreshNanos) {
                    LocalCache$LoadingValueReference localCache$LoadingValueReference = null;
                    return localCache$LoadingValueReference;
                }
                ++this.modCount;
                LocalCache$LoadingValueReference localCache$LoadingValueReference = new LocalCache$LoadingValueReference(localCache$ValueReference);
                localCache$ReferenceEntry.setValueReference(localCache$LoadingValueReference);
                LocalCache$LoadingValueReference localCache$LoadingValueReference2 = localCache$LoadingValueReference;
                return localCache$LoadingValueReference2;
            }
            ++this.modCount;
            object2 = new LocalCache$LoadingValueReference();
            localCache$ReferenceEntry = this.newEntry(object, n, localCache$ReferenceEntry2);
            localCache$ReferenceEntry.setValueReference((LocalCache$ValueReference)object2);
            atomicReferenceArray.set(n2, localCache$ReferenceEntry);
            Object object3 = object2;
            return object3;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryDrainReferenceQueues() {
        if (this.tryLock()) {
            try {
                this.drainReferenceQueues();
            }
            finally {
                this.unlock();
            }
        }
    }

    @GuardedBy(value="Segment.this")
    void drainReferenceQueues() {
        if (this.map.usesKeyReferences()) {
            this.drainKeyReferenceQueue();
        }
        if (this.map.usesValueReferences()) {
            this.drainValueReferenceQueue();
        }
    }

    @GuardedBy(value="Segment.this")
    void drainKeyReferenceQueue() {
        Reference reference;
        int n = 0;
        while ((reference = this.keyReferenceQueue.poll()) != null) {
            LocalCache$ReferenceEntry localCache$ReferenceEntry = (LocalCache$ReferenceEntry)((Object)reference);
            this.map.reclaimKey(localCache$ReferenceEntry);
            if (++n != 16) continue;
            break;
        }
    }

    @GuardedBy(value="Segment.this")
    void drainValueReferenceQueue() {
        Reference reference;
        int n = 0;
        while ((reference = this.valueReferenceQueue.poll()) != null) {
            LocalCache$ValueReference localCache$ValueReference = (LocalCache$ValueReference)((Object)reference);
            this.map.reclaimValue(localCache$ValueReference);
            if (++n != 16) continue;
            break;
        }
    }

    void clearReferenceQueues() {
        if (this.map.usesKeyReferences()) {
            this.clearKeyReferenceQueue();
        }
        if (this.map.usesValueReferences()) {
            this.clearValueReferenceQueue();
        }
    }

    void clearKeyReferenceQueue() {
        while (this.keyReferenceQueue.poll() != null) {
        }
    }

    void clearValueReferenceQueue() {
        while (this.valueReferenceQueue.poll() != null) {
        }
    }

    void recordRead(LocalCache$ReferenceEntry localCache$ReferenceEntry, long l) {
        if (this.map.recordsAccess()) {
            localCache$ReferenceEntry.setAccessTime(l);
        }
        this.recencyQueue.add(localCache$ReferenceEntry);
    }

    @GuardedBy(value="Segment.this")
    void recordLockedRead(LocalCache$ReferenceEntry localCache$ReferenceEntry, long l) {
        if (this.map.recordsAccess()) {
            localCache$ReferenceEntry.setAccessTime(l);
        }
        this.accessQueue.add(localCache$ReferenceEntry);
    }

    @GuardedBy(value="Segment.this")
    void recordWrite(LocalCache$ReferenceEntry localCache$ReferenceEntry, int n, long l) {
        this.drainRecencyQueue();
        this.totalWeight += n;
        if (this.map.recordsAccess()) {
            localCache$ReferenceEntry.setAccessTime(l);
        }
        if (this.map.recordsWrite()) {
            localCache$ReferenceEntry.setWriteTime(l);
        }
        this.accessQueue.add(localCache$ReferenceEntry);
        this.writeQueue.add(localCache$ReferenceEntry);
    }

    @GuardedBy(value="Segment.this")
    void drainRecencyQueue() {
        LocalCache$ReferenceEntry localCache$ReferenceEntry;
        while ((localCache$ReferenceEntry = (LocalCache$ReferenceEntry)this.recencyQueue.poll()) != null) {
            if (!this.accessQueue.contains(localCache$ReferenceEntry)) continue;
            this.accessQueue.add(localCache$ReferenceEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryExpireEntries(long l) {
        if (this.tryLock()) {
            try {
                this.expireEntries(l);
            }
            finally {
                this.unlock();
            }
        }
    }

    @GuardedBy(value="Segment.this")
    void expireEntries(long l) {
        LocalCache$ReferenceEntry localCache$ReferenceEntry;
        this.drainRecencyQueue();
        while ((localCache$ReferenceEntry = (LocalCache$ReferenceEntry)this.writeQueue.peek()) != null && this.map.isExpired(localCache$ReferenceEntry, l)) {
            if (!this.removeEntry(localCache$ReferenceEntry, localCache$ReferenceEntry.getHash(), RemovalCause.EXPIRED)) {
                throw new AssertionError();
            }
        }
        while ((localCache$ReferenceEntry = (LocalCache$ReferenceEntry)this.accessQueue.peek()) != null && this.map.isExpired(localCache$ReferenceEntry, l)) {
            if (!this.removeEntry(localCache$ReferenceEntry, localCache$ReferenceEntry.getHash(), RemovalCause.EXPIRED)) {
                throw new AssertionError();
            }
        }
    }

    @GuardedBy(value="Segment.this")
    void enqueueNotification(LocalCache$ReferenceEntry localCache$ReferenceEntry, RemovalCause removalCause) {
        this.enqueueNotification(localCache$ReferenceEntry.getKey(), localCache$ReferenceEntry.getHash(), localCache$ReferenceEntry.getValueReference(), removalCause);
    }

    @GuardedBy(value="Segment.this")
    void enqueueNotification(@Nullable Object object, int n, LocalCache$ValueReference localCache$ValueReference, RemovalCause removalCause) {
        this.totalWeight -= localCache$ValueReference.getWeight();
        if (removalCause.wasEvicted()) {
            this.statsCounter.recordEviction();
        }
        if (this.map.removalNotificationQueue != LocalCache.DISCARDING_QUEUE) {
            Object object2 = localCache$ValueReference.get();
            RemovalNotification removalNotification = new RemovalNotification(object, object2, removalCause);
            this.map.removalNotificationQueue.offer(removalNotification);
        }
    }

    @GuardedBy(value="Segment.this")
    void evictEntries() {
        if (!this.map.evictsBySize()) {
            return;
        }
        this.drainRecencyQueue();
        while ((long)this.totalWeight > this.maxSegmentWeight) {
            LocalCache$ReferenceEntry localCache$ReferenceEntry = this.getNextEvictable();
            if (!this.removeEntry(localCache$ReferenceEntry, localCache$ReferenceEntry.getHash(), RemovalCause.SIZE)) {
                throw new AssertionError();
            }
        }
    }

    LocalCache$ReferenceEntry getNextEvictable() {
        for (LocalCache$ReferenceEntry localCache$ReferenceEntry : this.accessQueue) {
            int n = localCache$ReferenceEntry.getValueReference().getWeight();
            if (n <= 0) continue;
            return localCache$ReferenceEntry;
        }
        throw new AssertionError();
    }

    LocalCache$ReferenceEntry getFirst(int n) {
        AtomicReferenceArray atomicReferenceArray = this.table;
        return (LocalCache$ReferenceEntry)atomicReferenceArray.get(n & atomicReferenceArray.length() - 1);
    }

    @Nullable
    LocalCache$ReferenceEntry getEntry(Object object, int n) {
        for (LocalCache$ReferenceEntry localCache$ReferenceEntry = this.getFirst(n); localCache$ReferenceEntry != null; localCache$ReferenceEntry = localCache$ReferenceEntry.getNext()) {
            if (localCache$ReferenceEntry.getHash() != n) continue;
            Object object2 = localCache$ReferenceEntry.getKey();
            if (object2 == null) {
                this.tryDrainReferenceQueues();
                continue;
            }
            if (!this.map.keyEquivalence.equivalent(object, object2)) continue;
            return localCache$ReferenceEntry;
        }
        return null;
    }

    @Nullable
    LocalCache$ReferenceEntry getLiveEntry(Object object, int n, long l) {
        LocalCache$ReferenceEntry localCache$ReferenceEntry = this.getEntry(object, n);
        if (localCache$ReferenceEntry == null) {
            return null;
        }
        if (this.map.isExpired(localCache$ReferenceEntry, l)) {
            this.tryExpireEntries(l);
            return null;
        }
        return localCache$ReferenceEntry;
    }

    Object getLiveValue(LocalCache$ReferenceEntry localCache$ReferenceEntry, long l) {
        if (localCache$ReferenceEntry.getKey() == null) {
            this.tryDrainReferenceQueues();
            return null;
        }
        Object object = localCache$ReferenceEntry.getValueReference().get();
        if (object == null) {
            this.tryDrainReferenceQueues();
            return null;
        }
        if (this.map.isExpired(localCache$ReferenceEntry, l)) {
            this.tryExpireEntries(l);
            return null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Object get(Object object, int n) {
        try {
            if (this.count != 0) {
                long l = this.map.ticker.read();
                LocalCache$ReferenceEntry localCache$ReferenceEntry = this.getLiveEntry(object, n, l);
                if (localCache$ReferenceEntry == null) {
                    Object var6_6 = null;
                    return var6_6;
                }
                Object object2 = localCache$ReferenceEntry.getValueReference().get();
                if (object2 != null) {
                    this.recordRead(localCache$ReferenceEntry, l);
                    Object object3 = this.scheduleRefresh(localCache$ReferenceEntry, localCache$ReferenceEntry.getKey(), n, object2, l, this.map.defaultLoader);
                    return object3;
                }
                this.tryDrainReferenceQueues();
            }
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            this.postReadCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsKey(Object object, int n) {
        try {
            if (this.count != 0) {
                long l = this.map.ticker.read();
                LocalCache$ReferenceEntry localCache$ReferenceEntry = this.getLiveEntry(object, n, l);
                if (localCache$ReferenceEntry == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = localCache$ReferenceEntry.getValueReference().get() != null;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.postReadCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Object put(Object object, int n, Object object2, boolean bl) {
        this.lock();
        try {
            Object object3;
            LocalCache$ReferenceEntry localCache$ReferenceEntry;
            LocalCache$ReferenceEntry localCache$ReferenceEntry2;
            long l = this.map.ticker.read();
            this.preWriteCleanup(l);
            int n2 = this.count + 1;
            if (n2 > this.threshold) {
                this.expand();
                n2 = this.count + 1;
            }
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n3 = n & atomicReferenceArray.length() - 1;
            for (localCache$ReferenceEntry2 = localCache$ReferenceEntry = (LocalCache$ReferenceEntry)atomicReferenceArray.get(n3); localCache$ReferenceEntry2 != null; localCache$ReferenceEntry2 = localCache$ReferenceEntry2.getNext()) {
                object3 = localCache$ReferenceEntry2.getKey();
                if (localCache$ReferenceEntry2.getHash() != n || object3 == null || !this.map.keyEquivalence.equivalent(object, object3)) continue;
                LocalCache$ValueReference localCache$ValueReference = localCache$ReferenceEntry2.getValueReference();
                Object object4 = localCache$ValueReference.get();
                if (object4 == null) {
                    ++this.modCount;
                    if (localCache$ValueReference.isActive()) {
                        this.enqueueNotification(object, n, localCache$ValueReference, RemovalCause.COLLECTED);
                        this.setValue(localCache$ReferenceEntry2, object, object2, l);
                        n2 = this.count;
                    } else {
                        this.setValue(localCache$ReferenceEntry2, object, object2, l);
                        n2 = this.count + 1;
                    }
                    this.count = n2;
                    this.evictEntries();
                    Object var15_14 = null;
                    return var15_14;
                }
                if (bl) {
                    this.recordLockedRead(localCache$ReferenceEntry2, l);
                    Object object5 = object4;
                    return object5;
                }
                ++this.modCount;
                this.enqueueNotification(object, n, localCache$ValueReference, RemovalCause.REPLACED);
                this.setValue(localCache$ReferenceEntry2, object, object2, l);
                this.evictEntries();
                Object object6 = object4;
                return object6;
            }
            ++this.modCount;
            localCache$ReferenceEntry2 = this.newEntry(object, n, localCache$ReferenceEntry);
            this.setValue(localCache$ReferenceEntry2, object, object2, l);
            atomicReferenceArray.set(n3, localCache$ReferenceEntry2);
            this.count = n2 = this.count + 1;
            this.evictEntries();
            object3 = null;
            return object3;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    @GuardedBy(value="Segment.this")
    void expand() {
        AtomicReferenceArray atomicReferenceArray = this.table;
        int n = atomicReferenceArray.length();
        if (n >= 0x40000000) {
            return;
        }
        int n2 = this.count;
        AtomicReferenceArray atomicReferenceArray2 = this.newEntryArray(n << 1);
        this.threshold = atomicReferenceArray2.length() * 3 / 4;
        int n3 = atomicReferenceArray2.length() - 1;
        for (int i = 0; i < n; ++i) {
            int n4;
            LocalCache$ReferenceEntry localCache$ReferenceEntry;
            LocalCache$ReferenceEntry localCache$ReferenceEntry2 = (LocalCache$ReferenceEntry)atomicReferenceArray.get(i);
            if (localCache$ReferenceEntry2 == null) continue;
            LocalCache$ReferenceEntry localCache$ReferenceEntry3 = localCache$ReferenceEntry2.getNext();
            int n5 = localCache$ReferenceEntry2.getHash() & n3;
            if (localCache$ReferenceEntry3 == null) {
                atomicReferenceArray2.set(n5, localCache$ReferenceEntry2);
                continue;
            }
            LocalCache$ReferenceEntry localCache$ReferenceEntry4 = localCache$ReferenceEntry2;
            int n6 = n5;
            for (localCache$ReferenceEntry = localCache$ReferenceEntry3; localCache$ReferenceEntry != null; localCache$ReferenceEntry = localCache$ReferenceEntry.getNext()) {
                n4 = localCache$ReferenceEntry.getHash() & n3;
                if (n4 == n6) continue;
                n6 = n4;
                localCache$ReferenceEntry4 = localCache$ReferenceEntry;
            }
            atomicReferenceArray2.set(n6, localCache$ReferenceEntry4);
            for (localCache$ReferenceEntry = localCache$ReferenceEntry2; localCache$ReferenceEntry != localCache$ReferenceEntry4; localCache$ReferenceEntry = localCache$ReferenceEntry.getNext()) {
                n4 = localCache$ReferenceEntry.getHash() & n3;
                LocalCache$ReferenceEntry localCache$ReferenceEntry5 = (LocalCache$ReferenceEntry)atomicReferenceArray2.get(n4);
                LocalCache$ReferenceEntry localCache$ReferenceEntry6 = this.copyEntry(localCache$ReferenceEntry, localCache$ReferenceEntry5);
                if (localCache$ReferenceEntry6 != null) {
                    atomicReferenceArray2.set(n4, localCache$ReferenceEntry6);
                    continue;
                }
                this.removeCollectedEntry(localCache$ReferenceEntry);
                --n2;
            }
        }
        this.table = atomicReferenceArray2;
        this.count = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean replace(Object object, int n, Object object2, Object object3) {
        this.lock();
        try {
            LocalCache$ReferenceEntry localCache$ReferenceEntry;
            long l = this.map.ticker.read();
            this.preWriteCleanup(l);
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n2 = n & atomicReferenceArray.length() - 1;
            for (LocalCache$ReferenceEntry localCache$ReferenceEntry2 = localCache$ReferenceEntry = (LocalCache$ReferenceEntry)atomicReferenceArray.get(n2); localCache$ReferenceEntry2 != null; localCache$ReferenceEntry2 = localCache$ReferenceEntry2.getNext()) {
                Object object4 = localCache$ReferenceEntry2.getKey();
                if (localCache$ReferenceEntry2.getHash() != n || object4 == null || !this.map.keyEquivalence.equivalent(object, object4)) continue;
                LocalCache$ValueReference localCache$ValueReference = localCache$ReferenceEntry2.getValueReference();
                Object object5 = localCache$ValueReference.get();
                if (object5 == null) {
                    int n3;
                    if (localCache$ValueReference.isActive()) {
                        n3 = this.count - 1;
                        ++this.modCount;
                        LocalCache$ReferenceEntry localCache$ReferenceEntry3 = this.removeValueFromChain(localCache$ReferenceEntry, localCache$ReferenceEntry2, object4, n, localCache$ValueReference, RemovalCause.COLLECTED);
                        n3 = this.count - 1;
                        atomicReferenceArray.set(n2, localCache$ReferenceEntry3);
                        this.count = n3;
                    }
                    n3 = 0;
                    return n3 != 0;
                }
                if (this.map.valueEquivalence.equivalent(object2, object5)) {
                    ++this.modCount;
                    this.enqueueNotification(object, n, localCache$ValueReference, RemovalCause.REPLACED);
                    this.setValue(localCache$ReferenceEntry2, object, object3, l);
                    this.evictEntries();
                    boolean bl = true;
                    return bl;
                }
                this.recordLockedRead(localCache$ReferenceEntry2, l);
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Object replace(Object object, int n, Object object2) {
        this.lock();
        try {
            LocalCache$ReferenceEntry localCache$ReferenceEntry;
            LocalCache$ReferenceEntry localCache$ReferenceEntry2;
            long l = this.map.ticker.read();
            this.preWriteCleanup(l);
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n2 = n & atomicReferenceArray.length() - 1;
            for (localCache$ReferenceEntry2 = localCache$ReferenceEntry = (LocalCache$ReferenceEntry)atomicReferenceArray.get(n2); localCache$ReferenceEntry2 != null; localCache$ReferenceEntry2 = localCache$ReferenceEntry2.getNext()) {
                Object object3 = localCache$ReferenceEntry2.getKey();
                if (localCache$ReferenceEntry2.getHash() != n || object3 == null || !this.map.keyEquivalence.equivalent(object, object3)) continue;
                LocalCache$ValueReference localCache$ValueReference = localCache$ReferenceEntry2.getValueReference();
                Object object4 = localCache$ValueReference.get();
                if (object4 == null) {
                    if (localCache$ValueReference.isActive()) {
                        int n3 = this.count - 1;
                        ++this.modCount;
                        LocalCache$ReferenceEntry localCache$ReferenceEntry3 = this.removeValueFromChain(localCache$ReferenceEntry, localCache$ReferenceEntry2, object3, n, localCache$ValueReference, RemovalCause.COLLECTED);
                        n3 = this.count - 1;
                        atomicReferenceArray.set(n2, localCache$ReferenceEntry3);
                        this.count = n3;
                    }
                    Object var13_13 = null;
                    return var13_13;
                }
                ++this.modCount;
                this.enqueueNotification(object, n, localCache$ValueReference, RemovalCause.REPLACED);
                this.setValue(localCache$ReferenceEntry2, object, object2, l);
                this.evictEntries();
                Object object5 = object4;
                return object5;
            }
            localCache$ReferenceEntry2 = null;
            return localCache$ReferenceEntry2;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Object remove(Object object, int n) {
        this.lock();
        try {
            LocalCache$ReferenceEntry localCache$ReferenceEntry;
            LocalCache$ReferenceEntry localCache$ReferenceEntry2;
            long l = this.map.ticker.read();
            this.preWriteCleanup(l);
            int n2 = this.count - 1;
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n3 = n & atomicReferenceArray.length() - 1;
            for (localCache$ReferenceEntry2 = localCache$ReferenceEntry = (LocalCache$ReferenceEntry)atomicReferenceArray.get(n3); localCache$ReferenceEntry2 != null; localCache$ReferenceEntry2 = localCache$ReferenceEntry2.getNext()) {
                RemovalCause removalCause;
                Object object2 = localCache$ReferenceEntry2.getKey();
                if (localCache$ReferenceEntry2.getHash() != n || object2 == null || !this.map.keyEquivalence.equivalent(object, object2)) continue;
                LocalCache$ValueReference localCache$ValueReference = localCache$ReferenceEntry2.getValueReference();
                Object object3 = localCache$ValueReference.get();
                if (object3 != null) {
                    removalCause = RemovalCause.EXPLICIT;
                } else if (localCache$ValueReference.isActive()) {
                    removalCause = RemovalCause.COLLECTED;
                } else {
                    Object var14_13 = null;
                    return var14_13;
                }
                ++this.modCount;
                LocalCache$ReferenceEntry localCache$ReferenceEntry3 = this.removeValueFromChain(localCache$ReferenceEntry, localCache$ReferenceEntry2, object2, n, localCache$ValueReference, removalCause);
                n2 = this.count - 1;
                atomicReferenceArray.set(n3, localCache$ReferenceEntry3);
                this.count = n2;
                Object object4 = object3;
                return object4;
            }
            localCache$ReferenceEntry2 = null;
            return localCache$ReferenceEntry2;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean storeLoadedValue(Object object, int n, LocalCache$LoadingValueReference localCache$LoadingValueReference, Object object2) {
        this.lock();
        try {
            LocalCache$ReferenceEntry localCache$ReferenceEntry;
            LocalCache$ReferenceEntry localCache$ReferenceEntry2;
            long l = this.map.ticker.read();
            this.preWriteCleanup(l);
            int n2 = this.count + 1;
            if (n2 > this.threshold) {
                this.expand();
                n2 = this.count + 1;
            }
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n3 = n & atomicReferenceArray.length() - 1;
            for (localCache$ReferenceEntry2 = localCache$ReferenceEntry = (LocalCache$ReferenceEntry)atomicReferenceArray.get(n3); localCache$ReferenceEntry2 != null; localCache$ReferenceEntry2 = localCache$ReferenceEntry2.getNext()) {
                Object object3 = localCache$ReferenceEntry2.getKey();
                if (localCache$ReferenceEntry2.getHash() != n || object3 == null || !this.map.keyEquivalence.equivalent(object, object3)) continue;
                LocalCache$ValueReference localCache$ValueReference = localCache$ReferenceEntry2.getValueReference();
                Object object4 = localCache$ValueReference.get();
                if (localCache$LoadingValueReference == localCache$ValueReference || object4 == null && localCache$ValueReference != LocalCache.UNSET) {
                    ++this.modCount;
                    if (localCache$LoadingValueReference.isActive()) {
                        RemovalCause removalCause = object4 == null ? RemovalCause.COLLECTED : RemovalCause.REPLACED;
                        this.enqueueNotification(object, n, localCache$LoadingValueReference, removalCause);
                        --n2;
                    }
                    this.setValue(localCache$ReferenceEntry2, object, object2, l);
                    this.count = n2;
                    this.evictEntries();
                    boolean bl = true;
                    return bl;
                }
                localCache$ValueReference = new LocalCache$WeightedStrongValueReference(object2, 0);
                this.enqueueNotification(object, n, localCache$ValueReference, RemovalCause.REPLACED);
                boolean bl = false;
                return bl;
            }
            ++this.modCount;
            localCache$ReferenceEntry2 = this.newEntry(object, n, localCache$ReferenceEntry);
            this.setValue(localCache$ReferenceEntry2, object, object2, l);
            atomicReferenceArray.set(n3, localCache$ReferenceEntry2);
            this.count = n2;
            this.evictEntries();
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(Object object, int n, Object object2) {
        this.lock();
        try {
            LocalCache$ReferenceEntry localCache$ReferenceEntry;
            long l = this.map.ticker.read();
            this.preWriteCleanup(l);
            int n2 = this.count - 1;
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n3 = n & atomicReferenceArray.length() - 1;
            for (LocalCache$ReferenceEntry localCache$ReferenceEntry2 = localCache$ReferenceEntry = (LocalCache$ReferenceEntry)atomicReferenceArray.get(n3); localCache$ReferenceEntry2 != null; localCache$ReferenceEntry2 = localCache$ReferenceEntry2.getNext()) {
                RemovalCause removalCause;
                Object object3 = localCache$ReferenceEntry2.getKey();
                if (localCache$ReferenceEntry2.getHash() != n || object3 == null || !this.map.keyEquivalence.equivalent(object, object3)) continue;
                LocalCache$ValueReference localCache$ValueReference = localCache$ReferenceEntry2.getValueReference();
                Object object4 = localCache$ValueReference.get();
                if (this.map.valueEquivalence.equivalent(object2, object4)) {
                    removalCause = RemovalCause.EXPLICIT;
                } else if (object4 == null && localCache$ValueReference.isActive()) {
                    removalCause = RemovalCause.COLLECTED;
                } else {
                    boolean bl = false;
                    return bl;
                }
                ++this.modCount;
                LocalCache$ReferenceEntry localCache$ReferenceEntry3 = this.removeValueFromChain(localCache$ReferenceEntry, localCache$ReferenceEntry2, object3, n, localCache$ValueReference, removalCause);
                n2 = this.count - 1;
                atomicReferenceArray.set(n3, localCache$ReferenceEntry3);
                this.count = n2;
                boolean bl = removalCause == RemovalCause.EXPLICIT;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        if (this.count != 0) {
            this.lock();
            try {
                int n;
                AtomicReferenceArray atomicReferenceArray = this.table;
                for (n = 0; n < atomicReferenceArray.length(); ++n) {
                    for (LocalCache$ReferenceEntry localCache$ReferenceEntry = (LocalCache$ReferenceEntry)atomicReferenceArray.get(n); localCache$ReferenceEntry != null; localCache$ReferenceEntry = localCache$ReferenceEntry.getNext()) {
                        if (!localCache$ReferenceEntry.getValueReference().isActive()) continue;
                        this.enqueueNotification(localCache$ReferenceEntry, RemovalCause.EXPLICIT);
                    }
                }
                for (n = 0; n < atomicReferenceArray.length(); ++n) {
                    atomicReferenceArray.set(n, null);
                }
                this.clearReferenceQueues();
                this.writeQueue.clear();
                this.accessQueue.clear();
                this.readCount.set(0);
                ++this.modCount;
                this.count = 0;
            }
            finally {
                this.unlock();
                this.postWriteCleanup();
            }
        }
    }

    @Nullable
    @GuardedBy(value="Segment.this")
    LocalCache$ReferenceEntry removeValueFromChain(LocalCache$ReferenceEntry localCache$ReferenceEntry, LocalCache$ReferenceEntry localCache$ReferenceEntry2, @Nullable Object object, int n, LocalCache$ValueReference localCache$ValueReference, RemovalCause removalCause) {
        this.enqueueNotification(object, n, localCache$ValueReference, removalCause);
        this.writeQueue.remove(localCache$ReferenceEntry2);
        this.accessQueue.remove(localCache$ReferenceEntry2);
        if (localCache$ValueReference.isLoading()) {
            localCache$ValueReference.notifyNewValue(null);
            return localCache$ReferenceEntry;
        }
        return this.removeEntryFromChain(localCache$ReferenceEntry, localCache$ReferenceEntry2);
    }

    @Nullable
    @GuardedBy(value="Segment.this")
    LocalCache$ReferenceEntry removeEntryFromChain(LocalCache$ReferenceEntry localCache$ReferenceEntry, LocalCache$ReferenceEntry localCache$ReferenceEntry2) {
        int n = this.count;
        LocalCache$ReferenceEntry localCache$ReferenceEntry3 = localCache$ReferenceEntry2.getNext();
        for (LocalCache$ReferenceEntry localCache$ReferenceEntry4 = localCache$ReferenceEntry; localCache$ReferenceEntry4 != localCache$ReferenceEntry2; localCache$ReferenceEntry4 = localCache$ReferenceEntry4.getNext()) {
            LocalCache$ReferenceEntry localCache$ReferenceEntry5 = this.copyEntry(localCache$ReferenceEntry4, localCache$ReferenceEntry3);
            if (localCache$ReferenceEntry5 != null) {
                localCache$ReferenceEntry3 = localCache$ReferenceEntry5;
                continue;
            }
            this.removeCollectedEntry(localCache$ReferenceEntry4);
            --n;
        }
        this.count = n;
        return localCache$ReferenceEntry3;
    }

    @GuardedBy(value="Segment.this")
    void removeCollectedEntry(LocalCache$ReferenceEntry localCache$ReferenceEntry) {
        this.enqueueNotification(localCache$ReferenceEntry, RemovalCause.COLLECTED);
        this.writeQueue.remove(localCache$ReferenceEntry);
        this.accessQueue.remove(localCache$ReferenceEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean reclaimKey(LocalCache$ReferenceEntry localCache$ReferenceEntry, int n) {
        this.lock();
        try {
            LocalCache$ReferenceEntry localCache$ReferenceEntry2;
            int n2 = this.count - 1;
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n3 = n & atomicReferenceArray.length() - 1;
            for (LocalCache$ReferenceEntry localCache$ReferenceEntry3 = localCache$ReferenceEntry2 = (LocalCache$ReferenceEntry)atomicReferenceArray.get(n3); localCache$ReferenceEntry3 != null; localCache$ReferenceEntry3 = localCache$ReferenceEntry3.getNext()) {
                if (localCache$ReferenceEntry3 != localCache$ReferenceEntry) continue;
                ++this.modCount;
                LocalCache$ReferenceEntry localCache$ReferenceEntry4 = this.removeValueFromChain(localCache$ReferenceEntry2, localCache$ReferenceEntry3, localCache$ReferenceEntry3.getKey(), n, localCache$ReferenceEntry3.getValueReference(), RemovalCause.COLLECTED);
                n2 = this.count - 1;
                atomicReferenceArray.set(n3, localCache$ReferenceEntry4);
                this.count = n2;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean reclaimValue(Object object, int n, LocalCache$ValueReference localCache$ValueReference) {
        this.lock();
        try {
            LocalCache$ReferenceEntry localCache$ReferenceEntry;
            int n2 = this.count - 1;
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n3 = n & atomicReferenceArray.length() - 1;
            for (LocalCache$ReferenceEntry localCache$ReferenceEntry2 = localCache$ReferenceEntry = (LocalCache$ReferenceEntry)atomicReferenceArray.get(n3); localCache$ReferenceEntry2 != null; localCache$ReferenceEntry2 = localCache$ReferenceEntry2.getNext()) {
                Object object2 = localCache$ReferenceEntry2.getKey();
                if (localCache$ReferenceEntry2.getHash() != n || object2 == null || !this.map.keyEquivalence.equivalent(object, object2)) continue;
                LocalCache$ValueReference localCache$ValueReference2 = localCache$ReferenceEntry2.getValueReference();
                if (localCache$ValueReference2 == localCache$ValueReference) {
                    ++this.modCount;
                    LocalCache$ReferenceEntry localCache$ReferenceEntry3 = this.removeValueFromChain(localCache$ReferenceEntry, localCache$ReferenceEntry2, object2, n, localCache$ValueReference, RemovalCause.COLLECTED);
                    n2 = this.count - 1;
                    atomicReferenceArray.set(n3, localCache$ReferenceEntry3);
                    this.count = n2;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
            if (!this.isHeldByCurrentThread()) {
                this.postWriteCleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeLoadingValue(Object object, int n, LocalCache$LoadingValueReference localCache$LoadingValueReference) {
        this.lock();
        try {
            LocalCache$ReferenceEntry localCache$ReferenceEntry;
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n2 = n & atomicReferenceArray.length() - 1;
            for (LocalCache$ReferenceEntry localCache$ReferenceEntry2 = localCache$ReferenceEntry = (LocalCache$ReferenceEntry)atomicReferenceArray.get(n2); localCache$ReferenceEntry2 != null; localCache$ReferenceEntry2 = localCache$ReferenceEntry2.getNext()) {
                Object object2 = localCache$ReferenceEntry2.getKey();
                if (localCache$ReferenceEntry2.getHash() != n || object2 == null || !this.map.keyEquivalence.equivalent(object, object2)) continue;
                LocalCache$ValueReference localCache$ValueReference = localCache$ReferenceEntry2.getValueReference();
                if (localCache$ValueReference == localCache$LoadingValueReference) {
                    if (localCache$LoadingValueReference.isActive()) {
                        localCache$ReferenceEntry2.setValueReference(localCache$LoadingValueReference.getOldValue());
                    } else {
                        LocalCache$ReferenceEntry localCache$ReferenceEntry3 = this.removeEntryFromChain(localCache$ReferenceEntry, localCache$ReferenceEntry2);
                        atomicReferenceArray.set(n2, localCache$ReferenceEntry3);
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
            this.postWriteCleanup();
        }
    }

    @GuardedBy(value="Segment.this")
    boolean removeEntry(LocalCache$ReferenceEntry localCache$ReferenceEntry, int n, RemovalCause removalCause) {
        LocalCache$ReferenceEntry localCache$ReferenceEntry2;
        int n2 = this.count - 1;
        AtomicReferenceArray atomicReferenceArray = this.table;
        int n3 = n & atomicReferenceArray.length() - 1;
        for (LocalCache$ReferenceEntry localCache$ReferenceEntry3 = localCache$ReferenceEntry2 = (LocalCache$ReferenceEntry)atomicReferenceArray.get(n3); localCache$ReferenceEntry3 != null; localCache$ReferenceEntry3 = localCache$ReferenceEntry3.getNext()) {
            if (localCache$ReferenceEntry3 != localCache$ReferenceEntry) continue;
            ++this.modCount;
            LocalCache$ReferenceEntry localCache$ReferenceEntry4 = this.removeValueFromChain(localCache$ReferenceEntry2, localCache$ReferenceEntry3, localCache$ReferenceEntry3.getKey(), n, localCache$ReferenceEntry3.getValueReference(), removalCause);
            n2 = this.count - 1;
            atomicReferenceArray.set(n3, localCache$ReferenceEntry4);
            this.count = n2;
            return true;
        }
        return false;
    }

    void postReadCleanup() {
        if ((this.readCount.incrementAndGet() & 0x3F) == 0) {
            this.cleanUp();
        }
    }

    @GuardedBy(value="Segment.this")
    void preWriteCleanup(long l) {
        this.runLockedCleanup(l);
    }

    void postWriteCleanup() {
        this.runUnlockedCleanup();
    }

    void cleanUp() {
        long l = this.map.ticker.read();
        this.runLockedCleanup(l);
        this.runUnlockedCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runLockedCleanup(long l) {
        if (this.tryLock()) {
            try {
                this.drainReferenceQueues();
                this.expireEntries(l);
                this.readCount.set(0);
            }
            finally {
                this.unlock();
            }
        }
    }

    void runUnlockedCleanup() {
        if (!this.isHeldByCurrentThread()) {
            this.map.processPendingNotifications();
        }
    }
}

