/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.events.json;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.BiMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.HashBiMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Lists;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonDeserializationContext;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonDeserializer;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonElement;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonObject;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonParseException;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonPrimitive;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonSerializationContext;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonSerializer;
import com.carrotsearch.ant.tasks.junit4.events.json.JsonDescriptionAdapter$ComparableDescription;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.junit.runner.Description;

public class JsonDescriptionAdapter
implements JsonDeserializer,
JsonSerializer {
    private final BiMap identifiers = HashBiMap.create();
    private final BiMap identifiersInverse = this.identifiers.inverse();

    public JsonElement serialize(Description description, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonDescriptionAdapter$ComparableDescription jsonDescriptionAdapter$ComparableDescription = new JsonDescriptionAdapter$ComparableDescription(description);
        String string = (String)this.identifiers.get(jsonDescriptionAdapter$ComparableDescription);
        if (string != null) {
            return new JsonPrimitive(string);
        }
        string = jsonDescriptionAdapter$ComparableDescription.id;
        this.identifiers.put(jsonDescriptionAdapter$ComparableDescription, jsonDescriptionAdapter$ComparableDescription.id);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("id", string);
        jsonObject.addProperty("displayName", description.getDisplayName());
        jsonObject.addProperty("methodName", description.getMethodName());
        jsonObject.addProperty("className", description.getClassName());
        jsonObject.add("annotations", jsonSerializationContext.serialize(description.getAnnotations()));
        jsonObject.add("children", jsonSerializationContext.serialize(description.getChildren()));
        return jsonObject;
    }

    public Description deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        JsonElement jsonElement22;
        if (jsonElement.isJsonPrimitive()) {
            String string = jsonElement.getAsString();
            JsonDescriptionAdapter$ComparableDescription jsonDescriptionAdapter$ComparableDescription = (JsonDescriptionAdapter$ComparableDescription)this.identifiersInverse.get(string);
            if (jsonDescriptionAdapter$ComparableDescription == null) {
                throw new JsonParseException("No such reference: " + string);
            }
            return jsonDescriptionAdapter$ComparableDescription.description;
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        ArrayList arrayList = Lists.newArrayList();
        for (JsonElement jsonElement22 : jsonObject.getAsJsonArray("annotations")) {
            arrayList.add((Annotation)jsonDeserializationContext.deserialize(jsonElement22, (Type)((Object)Annotation.class)));
        }
        String string = jsonObject.getAsJsonPrimitive("displayName").getAsString();
        jsonElement22 = Description.createSuiteDescription((String)string, (Annotation[])arrayList.toArray(new Annotation[arrayList.size()]));
        for (JsonElement jsonElement3 : jsonObject.getAsJsonArray("children")) {
            jsonElement22.addChild(this.deserialize(jsonElement3, type, jsonDeserializationContext));
        }
        JsonDescriptionAdapter$ComparableDescription jsonDescriptionAdapter$ComparableDescription = new JsonDescriptionAdapter$ComparableDescription((Description)jsonElement22);
        this.identifiers.put(jsonDescriptionAdapter$ComparableDescription, jsonDescriptionAdapter$ComparableDescription.id);
        return jsonElement22;
    }
}

