/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4;

import com.carrotsearch.ant.tasks.junit4.PickFromListTask$StringValue;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.SeedUtils;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.SysGlobals;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Strings;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class PickFromListTask
extends Task {
    private String propertyName;
    private boolean allowUndefined = false;
    private String random;
    private List values = Lists.newArrayList();
    private static AtomicInteger executionId = new AtomicInteger();

    public void setProperty(String string) {
        this.propertyName = string;
    }

    public void setAllowUndefined(boolean bl) {
        this.allowUndefined = bl;
    }

    public void setSeed(String string) {
        if (!Strings.isNullOrEmpty(this.getProject().getUserProperty(SysGlobals.SYSPROP_RANDOM_SEED()))) {
            String string2 = this.getProject().getUserProperty(SysGlobals.SYSPROP_RANDOM_SEED());
            if (!string2.equals(string)) {
                this.log("Ignoring seed attribute because it is overridden by user properties.", 1);
            }
        } else if (!Strings.isNullOrEmpty(string)) {
            this.random = string;
        }
    }

    public PickFromListTask$StringValue createValue() {
        PickFromListTask$StringValue pickFromListTask$StringValue = new PickFromListTask$StringValue();
        this.values.add(pickFromListTask$StringValue);
        return pickFromListTask$StringValue;
    }

    public void execute() {
        this.validate();
        if (this.allowUndefined) {
            this.values.add(null);
        }
        long l = SeedUtils.parseSeedChain(this.random)[0];
        PickFromListTask$StringValue pickFromListTask$StringValue = (PickFromListTask$StringValue)((Object)RandomPicks.randomFrom(new Random(l ^= new Random(executionId.incrementAndGet()).nextLong()), this.values));
        if (pickFromListTask$StringValue != null) {
            this.getProject().setProperty(this.propertyName, pickFromListTask$StringValue.toString());
        }
    }

    private void validate() {
        if (Strings.emptyToNull(this.random) == null) {
            this.random = Strings.emptyToNull(this.getProject().getProperty(SysGlobals.SYSPROP_RANDOM_SEED()));
        }
        if (this.random == null) {
            throw new BuildException("Required attribute 'seed' must not be empty. Look at <junit4:pickseed>.");
        }
        long[] lArray = SeedUtils.parseSeedChain(this.random);
        if (lArray.length < 1) {
            throw new BuildException("Random seed is required.");
        }
        if (this.values.isEmpty() && !this.allowUndefined) {
            throw new BuildException("No values to pick from and allowUndefined=false.");
        }
    }
}

