/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.search.facet.DoubleFuncSlotAcc;
import org.apache.solr.search.facet.FacetContext;

class MaxSlotAcc
extends DoubleFuncSlotAcc {
    public MaxSlotAcc(ValueSource values, FacetContext fcontext, int numSlots) {
        super(values, fcontext, numSlots, Double.NaN);
    }

    @Override
    public void collect(int doc, int slotNum) {
        double val = this.values.doubleVal(doc);
        if (val == 0.0 && !this.values.exists(doc)) {
            return;
        }
        double currMax = this.result[slotNum];
        if (!(val <= currMax)) {
            this.result[slotNum] = val;
        }
    }
}

