/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.search.Query;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.JoinQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;

public class JoinQParserPlugin
extends QParserPlugin {
    public static final String NAME = "join";

    @Override
    public void init(NamedList args) {
    }

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public Query parse() throws SyntaxError {
                fromField = this.getParam("from");
                fromIndex = this.getParam("fromIndex");
                toField = this.getParam("to");
                v = this.localParams.get("v");
                fromCoreOpenTime = 0L;
                if (fromIndex != null && !fromIndex.equals(this.req.getCore().getCoreDescriptor().getName())) {
                    container = this.req.getCore().getCoreDescriptor().getCoreContainer();
                    if (container.isZooKeeperAware()) {
                        zkController = container.getZkController();
                        if (!zkController.getClusterState().hasCollection(fromIndex)) {
                            resolved = null;
                            aliases = zkController.getZkStateReader().getAliases();
                            if (aliases != null) {
                                collectionAliases = aliases.getCollectionAliasMap();
                                v0 = resolved = collectionAliases != null ? (String)collectionAliases.get(fromIndex) : null;
                                if (resolved != null && resolved.split(",").length > 1) {
                                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "SolrCloud join: Collection alias '" + fromIndex + "' maps to multiple collections (" + resolved + "), which is not currently supported for joins.");
                                }
                            }
                            if (resolved == null) {
                                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "SolrCloud join: Collection '" + fromIndex + "' not found!");
                            }
                            fromIndex = resolved;
                        }
                        fromIndex = JoinQParserPlugin.this.findLocalReplicaForFromIndex(zkController, fromIndex);
                    }
                    if ((fromCore = container.getCore(fromIndex)) == null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cross-core join: no such core " + fromIndex);
                    }
                    fromHolder = null;
                    otherReq = new LocalSolrQueryRequest(fromCore, this.params);
                    try {
                        parser = QParser.getParser(v, "lucene", otherReq);
                        fromQuery = parser.getQuery();
                        fromHolder = fromCore.getRegisteredSearcher();
                        if (fromHolder == null) ** GOTO lbl41
                        fromCoreOpenTime = fromHolder.get().getOpenTime();
                    }
                    finally {
                        otherReq.close();
                        fromCore.close();
                        if (fromHolder != null) {
                            fromHolder.decref();
                        }
                    }
                } else {
                    fromQueryParser = this.subQuery(v, null);
                    fromQuery = fromQueryParser.getQuery();
                }
lbl41:
                // 3 sources

                jq = new JoinQuery(fromField, toField, fromIndex, fromQuery);
                jq.fromCoreOpenTime = fromCoreOpenTime;
                return jq;
            }
        };
    }

    protected String findLocalReplicaForFromIndex(ZkController zkController, String fromIndex) {
        String fromReplica = null;
        String nodeName = zkController.getNodeName();
        block0: for (Slice slice : zkController.getClusterState().getActiveSlices(fromIndex)) {
            if (fromReplica != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "SolrCloud join: multiple shards not yet supported " + fromIndex);
            }
            for (Replica replica : slice.getReplicas()) {
                if (!replica.getNodeName().equals(nodeName)) continue;
                fromReplica = replica.getStr("core");
                if (replica.getState() == Replica.State.ACTIVE) continue block0;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "SolrCloud join: " + fromIndex + " has a local replica (" + fromReplica + ") on " + nodeName + ", but it is " + replica.getState());
            }
        }
        if (fromReplica == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "SolrCloud join: No active replicas for " + fromIndex + " found in node " + nodeName);
        }
        return fromReplica;
    }
}

