/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema;

import java.util.List;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchema;
import org.restlet.resource.ResourceException;

abstract class BaseFieldTypeResource
extends BaseSolrResource {
    private boolean showDefaults;

    protected BaseFieldTypeResource() {
    }

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
        if (this.isExisting()) {
            this.showDefaults = this.getSolrRequest().getParams().getBool("showDefaults", false);
        }
    }

    protected SimpleOrderedMap<Object> getFieldTypeProperties(FieldType fieldType) {
        SimpleOrderedMap<Object> properties = fieldType.getNamedPropertyValues(this.showDefaults);
        properties.add("fields", this.getFieldsWithFieldType(fieldType));
        properties.add("dynamicFields", this.getDynamicFieldsWithFieldType(fieldType));
        return properties;
    }

    protected abstract List<String> getFieldsWithFieldType(FieldType var1);

    protected abstract List<String> getDynamicFieldsWithFieldType(FieldType var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNewFieldTypes(List<FieldType> newFieldTypes, ManagedIndexSchema oldSchema) {
        CoreDescriptor cd;
        String collection;
        IndexSchema newSchema = null;
        boolean success = false;
        while (!success) {
            try {
                Object object = oldSchema.getSchemaUpdateLock();
                synchronized (object) {
                    newSchema = oldSchema.addFieldTypes((List)newFieldTypes, true);
                    this.getSolrCore().setLatestSchema(newSchema);
                    success = true;
                }
            }
            catch (ManagedIndexSchema.SchemaChangedInZkException e) {
                oldSchema = (ManagedIndexSchema)this.getSolrCore().getLatestSchema();
            }
        }
        if (this.getUpdateTimeoutSecs() > 0 && newSchema != null && newSchema.getResourceLoader() instanceof ZkSolrResourceLoader && (collection = (cd = this.getSolrCore().getCoreDescriptor()).getCollectionName()) != null) {
            ZkSolrResourceLoader zkLoader = (ZkSolrResourceLoader)newSchema.getResourceLoader();
            ManagedIndexSchema.waitForSchemaZkVersionAgreement(collection, cd.getCloudDescriptor().getCoreNodeName(), ((ManagedIndexSchema)newSchema).getSchemaZkVersion(), zkLoader.getZkController(), this.getUpdateTimeoutSecs());
        }
    }
}

