/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.stream;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.stream.JsonScope;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.stream.JsonToken;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.stream.MalformedJsonException;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.stream.StringPool;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class JsonReader
implements Closeable {
    private static final char[] NON_EXECUTE_PREFIX = ")]}'\n".toCharArray();
    private final StringPool stringPool = new StringPool();
    private final Reader in;
    private boolean lenient = false;
    private final char[] buffer = new char[1024];
    private int pos = 0;
    private int limit = 0;
    private int bufferStartLine = 1;
    private int bufferStartColumn = 1;
    private final List stack = new ArrayList();
    private boolean hasToken;
    private JsonToken token;
    private String name;
    private String value;
    private boolean skipping;

    public JsonReader(Reader reader) {
        this.push(JsonScope.EMPTY_DOCUMENT);
        this.skipping = false;
        if (reader == null) {
            throw new NullPointerException("in == null");
        }
        this.in = reader;
    }

    public final void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public final boolean isLenient() {
        return this.lenient;
    }

    public void beginArray() {
        this.expect(JsonToken.BEGIN_ARRAY);
    }

    public void endArray() {
        this.expect(JsonToken.END_ARRAY);
    }

    public void beginObject() {
        this.expect(JsonToken.BEGIN_OBJECT);
    }

    public void endObject() {
        this.expect(JsonToken.END_OBJECT);
    }

    private void expect(JsonToken jsonToken) {
        this.quickPeek();
        if (this.token != jsonToken) {
            throw new IllegalStateException("Expected " + (Object)((Object)jsonToken) + " but was " + (Object)((Object)this.peek()));
        }
        this.advance();
    }

    public boolean hasNext() {
        this.quickPeek();
        return this.token != JsonToken.END_OBJECT && this.token != JsonToken.END_ARRAY;
    }

    public JsonToken peek() {
        this.quickPeek();
        if (this.token == null) {
            this.decodeLiteral();
        }
        return this.token;
    }

    private JsonToken quickPeek() {
        if (this.hasToken) {
            return this.token;
        }
        switch (this.peekStack()) {
            case EMPTY_DOCUMENT: {
                if (this.lenient) {
                    this.consumeNonExecutePrefix();
                }
                this.replaceTop(JsonScope.NONEMPTY_DOCUMENT);
                JsonToken jsonToken = this.nextValue();
                if (!this.lenient && jsonToken != JsonToken.BEGIN_ARRAY && jsonToken != JsonToken.BEGIN_OBJECT) {
                    this.syntaxError("Expected JSON document to start with '[' or '{'");
                }
                return jsonToken;
            }
            case EMPTY_ARRAY: {
                return this.nextInArray(true);
            }
            case NONEMPTY_ARRAY: {
                return this.nextInArray(false);
            }
            case EMPTY_OBJECT: {
                return this.nextInObject(true);
            }
            case DANGLING_NAME: {
                return this.objectValue();
            }
            case NONEMPTY_OBJECT: {
                return this.nextInObject(false);
            }
            case NONEMPTY_DOCUMENT: {
                try {
                    JsonToken jsonToken = this.nextValue();
                    if (this.lenient) {
                        return jsonToken;
                    }
                    throw this.syntaxError("Expected EOF");
                }
                catch (EOFException eOFException) {
                    this.hasToken = true;
                    this.token = JsonToken.END_DOCUMENT;
                    return this.token;
                }
            }
            case CLOSED: {
                throw new IllegalStateException("JsonReader is closed");
            }
        }
        throw new AssertionError();
    }

    private void consumeNonExecutePrefix() {
        this.nextNonWhitespace();
        --this.pos;
        if (this.pos + NON_EXECUTE_PREFIX.length > this.limit && !this.fillBuffer(NON_EXECUTE_PREFIX.length)) {
            return;
        }
        for (int i = 0; i < NON_EXECUTE_PREFIX.length; ++i) {
            if (this.buffer[this.pos + i] == NON_EXECUTE_PREFIX[i]) continue;
            return;
        }
        this.pos += NON_EXECUTE_PREFIX.length;
    }

    private JsonToken advance() {
        this.quickPeek();
        JsonToken jsonToken = this.token;
        this.hasToken = false;
        this.token = null;
        this.value = null;
        this.name = null;
        return jsonToken;
    }

    public String nextName() {
        this.quickPeek();
        if (this.token != JsonToken.NAME) {
            throw new IllegalStateException("Expected a name but was " + (Object)((Object)this.peek()));
        }
        String string = this.name;
        this.advance();
        return string;
    }

    public String nextString() {
        this.peek();
        if (this.value == null || this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected a string but was " + (Object)((Object)this.peek()));
        }
        String string = this.value;
        this.advance();
        return string;
    }

    public boolean nextBoolean() {
        boolean bl;
        this.quickPeek();
        if (this.value == null || this.token == JsonToken.STRING) {
            throw new IllegalStateException("Expected a boolean but was " + (Object)((Object)this.peek()));
        }
        if (this.value.equalsIgnoreCase("true")) {
            bl = true;
        } else if (this.value.equalsIgnoreCase("false")) {
            bl = false;
        } else {
            throw new IllegalStateException("Not a boolean: " + this.value);
        }
        this.advance();
        return bl;
    }

    public void nextNull() {
        this.quickPeek();
        if (this.value == null || this.token == JsonToken.STRING) {
            throw new IllegalStateException("Expected null but was " + (Object)((Object)this.peek()));
        }
        if (!this.value.equalsIgnoreCase("null")) {
            throw new IllegalStateException("Not a null: " + this.value);
        }
        this.advance();
    }

    public double nextDouble() {
        this.quickPeek();
        if (this.value == null) {
            throw new IllegalStateException("Expected a double but was " + (Object)((Object)this.peek()));
        }
        double d = Double.parseDouble(this.value);
        if (d >= 1.0 && this.value.startsWith("0")) {
            throw new NumberFormatException("JSON forbids octal prefixes: " + this.value);
        }
        if (!this.lenient && (Double.isNaN(d) || Double.isInfinite(d))) {
            throw new NumberFormatException("JSON forbids NaN and infinities: " + this.value);
        }
        this.advance();
        return d;
    }

    public long nextLong() {
        long l;
        block4: {
            this.quickPeek();
            if (this.value == null) {
                throw new IllegalStateException("Expected a long but was " + (Object)((Object)this.peek()));
            }
            try {
                l = Long.parseLong(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                double d = Double.parseDouble(this.value);
                l = (long)d;
                if ((double)l == d) break block4;
                throw new NumberFormatException(this.value);
            }
        }
        if (l >= 1L && this.value.startsWith("0")) {
            throw new NumberFormatException("JSON forbids octal prefixes: " + this.value);
        }
        this.advance();
        return l;
    }

    public int nextInt() {
        int n;
        block4: {
            this.quickPeek();
            if (this.value == null) {
                throw new IllegalStateException("Expected an int but was " + (Object)((Object)this.peek()));
            }
            try {
                n = Integer.parseInt(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                double d = Double.parseDouble(this.value);
                n = (int)d;
                if ((double)n == d) break block4;
                throw new NumberFormatException(this.value);
            }
        }
        if ((long)n >= 1L && this.value.startsWith("0")) {
            throw new NumberFormatException("JSON forbids octal prefixes: " + this.value);
        }
        this.advance();
        return n;
    }

    public void close() {
        this.hasToken = false;
        this.value = null;
        this.token = null;
        this.stack.clear();
        this.stack.add(JsonScope.CLOSED);
        this.in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipValue() {
        this.skipping = true;
        try {
            int n = 0;
            do {
                JsonToken jsonToken;
                if ((jsonToken = this.advance()) == JsonToken.BEGIN_ARRAY || jsonToken == JsonToken.BEGIN_OBJECT) {
                    ++n;
                    continue;
                }
                if (jsonToken != JsonToken.END_ARRAY && jsonToken != JsonToken.END_OBJECT) continue;
                --n;
            } while (n != 0);
        }
        finally {
            this.skipping = false;
        }
    }

    private JsonScope peekStack() {
        return (JsonScope)((Object)this.stack.get(this.stack.size() - 1));
    }

    private JsonScope pop() {
        return (JsonScope)((Object)this.stack.remove(this.stack.size() - 1));
    }

    private void push(JsonScope jsonScope) {
        this.stack.add(jsonScope);
    }

    private void replaceTop(JsonScope jsonScope) {
        this.stack.set(this.stack.size() - 1, jsonScope);
    }

    private JsonToken nextInArray(boolean bl) {
        if (bl) {
            this.replaceTop(JsonScope.NONEMPTY_ARRAY);
        } else {
            switch (this.nextNonWhitespace()) {
                case 93: {
                    this.pop();
                    this.hasToken = true;
                    this.token = JsonToken.END_ARRAY;
                    return this.token;
                }
                case 59: {
                    this.checkLenient();
                }
                case 44: {
                    break;
                }
                default: {
                    throw this.syntaxError("Unterminated array");
                }
            }
        }
        switch (this.nextNonWhitespace()) {
            case 93: {
                if (bl) {
                    this.pop();
                    this.hasToken = true;
                    this.token = JsonToken.END_ARRAY;
                    return this.token;
                }
            }
            case 44: 
            case 59: {
                this.checkLenient();
                --this.pos;
                this.hasToken = true;
                this.value = "null";
                this.token = JsonToken.NULL;
                return this.token;
            }
        }
        --this.pos;
        return this.nextValue();
    }

    private JsonToken nextInObject(boolean bl) {
        if (bl) {
            switch (this.nextNonWhitespace()) {
                case 125: {
                    this.pop();
                    this.hasToken = true;
                    this.token = JsonToken.END_OBJECT;
                    return this.token;
                }
            }
            --this.pos;
        } else {
            switch (this.nextNonWhitespace()) {
                case 125: {
                    this.pop();
                    this.hasToken = true;
                    this.token = JsonToken.END_OBJECT;
                    return this.token;
                }
                case 44: 
                case 59: {
                    break;
                }
                default: {
                    throw this.syntaxError("Unterminated object");
                }
            }
        }
        int n = this.nextNonWhitespace();
        switch (n) {
            case 39: {
                this.checkLenient();
            }
            case 34: {
                this.name = this.nextString((char)n);
                break;
            }
            default: {
                this.checkLenient();
                --this.pos;
                this.name = this.nextLiteral();
                if (this.name.length() != 0) break;
                throw this.syntaxError("Expected name");
            }
        }
        this.replaceTop(JsonScope.DANGLING_NAME);
        this.hasToken = true;
        this.token = JsonToken.NAME;
        return this.token;
    }

    private JsonToken objectValue() {
        switch (this.nextNonWhitespace()) {
            case 58: {
                break;
            }
            case 61: {
                this.checkLenient();
                if (this.pos >= this.limit && !this.fillBuffer(1) || this.buffer[this.pos] != '>') break;
                ++this.pos;
                break;
            }
            default: {
                throw this.syntaxError("Expected ':'");
            }
        }
        this.replaceTop(JsonScope.NONEMPTY_OBJECT);
        return this.nextValue();
    }

    private JsonToken nextValue() {
        int n = this.nextNonWhitespace();
        switch (n) {
            case 123: {
                this.push(JsonScope.EMPTY_OBJECT);
                this.hasToken = true;
                this.token = JsonToken.BEGIN_OBJECT;
                return this.token;
            }
            case 91: {
                this.push(JsonScope.EMPTY_ARRAY);
                this.hasToken = true;
                this.token = JsonToken.BEGIN_ARRAY;
                return this.token;
            }
            case 39: {
                this.checkLenient();
            }
            case 34: {
                this.value = this.nextString((char)n);
                this.hasToken = true;
                this.token = JsonToken.STRING;
                return this.token;
            }
        }
        --this.pos;
        return this.readLiteral();
    }

    private boolean fillBuffer(int n) {
        int n2;
        for (n2 = 0; n2 < this.pos; ++n2) {
            if (this.buffer[n2] == '\n') {
                ++this.bufferStartLine;
                this.bufferStartColumn = 1;
                continue;
            }
            ++this.bufferStartColumn;
        }
        if (this.limit != this.pos) {
            this.limit -= this.pos;
            System.arraycopy(this.buffer, this.pos, this.buffer, 0, this.limit);
        } else {
            this.limit = 0;
        }
        this.pos = 0;
        while ((n2 = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit)) != -1) {
            this.limit += n2;
            if (this.bufferStartLine == 1 && this.bufferStartColumn == 1 && this.limit > 0 && this.buffer[0] == '\ufeff') {
                ++this.pos;
                --this.bufferStartColumn;
            }
            if (this.limit < n) continue;
            return true;
        }
        return false;
    }

    private int getLineNumber() {
        int n = this.bufferStartLine;
        for (int i = 0; i < this.pos; ++i) {
            if (this.buffer[i] != '\n') continue;
            ++n;
        }
        return n;
    }

    private int getColumnNumber() {
        int n = this.bufferStartColumn;
        for (int i = 0; i < this.pos; ++i) {
            if (this.buffer[i] == '\n') {
                n = 1;
                continue;
            }
            ++n;
        }
        return n;
    }

    private int nextNonWhitespace() {
        block9: while (this.pos < this.limit || this.fillBuffer(1)) {
            char c = this.buffer[this.pos++];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block9;
                }
                case '/': {
                    if (this.pos == this.limit && !this.fillBuffer(1)) {
                        return c;
                    }
                    this.checkLenient();
                    char c2 = this.buffer[this.pos];
                    switch (c2) {
                        case '*': {
                            ++this.pos;
                            if (!this.skipTo("*/")) {
                                throw this.syntaxError("Unterminated comment");
                            }
                            this.pos += 2;
                            continue block9;
                        }
                        case '/': {
                            ++this.pos;
                            this.skipToEndOfLine();
                            continue block9;
                        }
                    }
                    return c;
                }
                case '#': {
                    this.checkLenient();
                    this.skipToEndOfLine();
                    continue block9;
                }
            }
            return c;
        }
        throw new EOFException("End of input");
    }

    private void checkLenient() {
        if (!this.lenient) {
            throw this.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
        }
    }

    private void skipToEndOfLine() {
        char c;
        while ((this.pos < this.limit || this.fillBuffer(1)) && (c = this.buffer[this.pos++]) != '\r' && c != '\n') {
        }
    }

    private boolean skipTo(String string) {
        while (this.pos + string.length() <= this.limit || this.fillBuffer(string.length())) {
            block3: {
                for (int i = 0; i < string.length(); ++i) {
                    if (this.buffer[this.pos + i] == string.charAt(i)) {
                        continue;
                    }
                    break block3;
                }
                return true;
            }
            ++this.pos;
        }
        return false;
    }

    private String nextString(char c) {
        StringBuilder stringBuilder = null;
        do {
            int n = this.pos;
            while (this.pos < this.limit) {
                char c2;
                if ((c2 = this.buffer[this.pos++]) == c) {
                    if (this.skipping) {
                        return "skipped!";
                    }
                    if (stringBuilder == null) {
                        return this.stringPool.get(this.buffer, n, this.pos - n - 1);
                    }
                    stringBuilder.append(this.buffer, n, this.pos - n - 1);
                    return stringBuilder.toString();
                }
                if (c2 != '\\') continue;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                }
                stringBuilder.append(this.buffer, n, this.pos - n - 1);
                stringBuilder.append(this.readEscapeCharacter());
                n = this.pos;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(this.buffer, n, this.pos - n);
        } while (this.fillBuffer(1));
        throw this.syntaxError("Unterminated string");
    }

    private String nextLiteral() {
        StringBuilder stringBuilder = null;
        do {
            int n = this.pos;
            while (this.pos < this.limit) {
                char c = this.buffer[this.pos++];
                switch (c) {
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        this.checkLenient();
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        --this.pos;
                        if (this.skipping) {
                            return "skipped!";
                        }
                        if (stringBuilder == null) {
                            return this.stringPool.get(this.buffer, n, this.pos - n);
                        }
                        stringBuilder.append(this.buffer, n, this.pos - n);
                        return stringBuilder.toString();
                    }
                }
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(this.buffer, n, this.pos - n);
        } while (this.fillBuffer(1));
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " near " + this.getSnippet();
    }

    private char readEscapeCharacter() {
        if (this.pos == this.limit && !this.fillBuffer(1)) {
            throw this.syntaxError("Unterminated escape sequence");
        }
        char c = this.buffer[this.pos++];
        switch (c) {
            case 'u': {
                if (this.pos + 4 > this.limit && !this.fillBuffer(4)) {
                    throw this.syntaxError("Unterminated escape sequence");
                }
                String string = this.stringPool.get(this.buffer, this.pos, 4);
                this.pos += 4;
                return (char)Integer.parseInt(string, 16);
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
        }
        return c;
    }

    private JsonToken readLiteral() {
        String string = this.nextLiteral();
        if (string.length() == 0) {
            throw this.syntaxError("Expected literal value");
        }
        this.value = string;
        this.hasToken = true;
        this.token = null;
        return null;
    }

    private void decodeLiteral() {
        if (this.value.equalsIgnoreCase("null")) {
            this.token = JsonToken.NULL;
        } else if (this.value.equalsIgnoreCase("true") || this.value.equalsIgnoreCase("false")) {
            this.token = JsonToken.BOOLEAN;
        } else {
            try {
                Double.parseDouble(this.value);
                this.token = JsonToken.NUMBER;
            }
            catch (NumberFormatException numberFormatException) {
                this.checkLenient();
                this.token = JsonToken.STRING;
            }
        }
    }

    private IOException syntaxError(String string) {
        throw new MalformedJsonException(string + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
    }

    private CharSequence getSnippet() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = Math.min(this.pos, 20);
        stringBuilder.append(this.buffer, this.pos - n, n);
        int n2 = Math.min(this.limit - this.pos, 20);
        stringBuilder.append(this.buffer, this.pos, n2);
        return stringBuilder;
    }
}

