/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import javax.annotation.Nullable;

final class AbstractFuture$Sync
extends AbstractQueuedSynchronizer {
    private Object value;
    private Throwable exception;

    AbstractFuture$Sync() {
    }

    @Override
    protected int tryAcquireShared(int n) {
        if (this.isDone()) {
            return 1;
        }
        return -1;
    }

    @Override
    protected boolean tryReleaseShared(int n) {
        this.setState(n);
        return true;
    }

    Object get(long l) {
        if (!this.tryAcquireSharedNanos(-1, l)) {
            throw new TimeoutException("Timeout waiting for task.");
        }
        return this.getValue();
    }

    Object get() {
        this.acquireSharedInterruptibly(-1);
        return this.getValue();
    }

    private Object getValue() {
        int n = this.getState();
        switch (n) {
            case 2: {
                if (this.exception != null) {
                    throw new ExecutionException(this.exception);
                }
                return this.value;
            }
            case 4: 
            case 8: {
                throw AbstractFuture.cancellationExceptionWithCause("Task was cancelled.", this.exception);
            }
        }
        throw new IllegalStateException("Error, synchronizer in invalid state: " + n);
    }

    boolean isDone() {
        return (this.getState() & 0xE) != 0;
    }

    boolean isCancelled() {
        return (this.getState() & 0xC) != 0;
    }

    boolean wasInterrupted() {
        return this.getState() == 8;
    }

    boolean set(@Nullable Object object) {
        return this.complete(object, null, 2);
    }

    boolean setException(Throwable throwable) {
        return this.complete(null, throwable, 2);
    }

    boolean cancel(boolean bl) {
        return this.complete(null, null, bl ? 8 : 4);
    }

    private boolean complete(@Nullable Object object, @Nullable Throwable throwable, int n) {
        boolean bl = this.compareAndSetState(0, 1);
        if (bl) {
            this.value = object;
            this.exception = (n & 0xC) != 0 ? new CancellationException("Future.cancel() was called.") : throwable;
            this.releaseShared(n);
        } else if (this.getState() == 1) {
            this.acquireShared(-1);
        }
        return bl;
    }
}

