/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Platform;
import java.util.Collection;

public final class ObjectArrays {
    static final Object[] EMPTY_ARRAY = new Object[0];

    public static Object[] newArray(Object[] objectArray, int n) {
        return Platform.newArray(objectArray, n);
    }

    static Object[] arraysCopyOf(Object[] objectArray, int n) {
        Object[] objectArray2 = ObjectArrays.newArray(objectArray, n);
        System.arraycopy(objectArray, 0, objectArray2, 0, Math.min(objectArray.length, n));
        return objectArray2;
    }

    static Object[] toArrayImpl(Collection collection, Object[] objectArray) {
        int n = collection.size();
        if (objectArray.length < n) {
            objectArray = ObjectArrays.newArray(objectArray, n);
        }
        ObjectArrays.fillArray(collection, objectArray);
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    private static Object[] fillArray(Iterable iterable, Object[] objectArray) {
        int n = 0;
        for (Object t : iterable) {
            objectArray[n++] = t;
        }
        return objectArray;
    }

    static Object[] checkElementsNotNull(Object ... objectArray) {
        return ObjectArrays.checkElementsNotNull(objectArray, objectArray.length);
    }

    static Object[] checkElementsNotNull(Object[] objectArray, int n) {
        for (int i = 0; i < n; ++i) {
            ObjectArrays.checkElementNotNull(objectArray[i], i);
        }
        return objectArray;
    }

    static Object checkElementNotNull(Object object, int n) {
        if (object == null) {
            throw new NullPointerException("at index " + n);
        }
        return object;
    }
}

