/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Ascii;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Equivalence;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Objects;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Objects$ToStringHelper;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Supplier;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Suppliers;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Ticker;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder$2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder$3;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder$NullListener;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder$OneWeigher;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheLoader;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheStats;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LoadingCache;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$LocalLoadingCache;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$Strength;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.RemovalListener;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.Weigher;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CacheBuilder {
    static final Supplier NULL_STATS_COUNTER = Suppliers.ofInstance(new CacheBuilder$1());
    static final CacheStats EMPTY_STATS = new CacheStats(0L, 0L, 0L, 0L, 0L, 0L);
    static final Supplier CACHE_STATS_COUNTER = new CacheBuilder$2();
    static final Ticker NULL_TICKER = new CacheBuilder$3();
    private static final Logger logger = Logger.getLogger(CacheBuilder.class.getName());
    boolean strictParsing = true;
    int initialCapacity = -1;
    int concurrencyLevel = -1;
    long maximumSize = -1L;
    long maximumWeight = -1L;
    Weigher weigher;
    LocalCache$Strength keyStrength;
    LocalCache$Strength valueStrength;
    long expireAfterWriteNanos = -1L;
    long expireAfterAccessNanos = -1L;
    long refreshNanos = -1L;
    Equivalence keyEquivalence;
    Equivalence valueEquivalence;
    RemovalListener removalListener;
    Ticker ticker;
    Supplier statsCounterSupplier = NULL_STATS_COUNTER;

    CacheBuilder() {
    }

    public static CacheBuilder newBuilder() {
        return new CacheBuilder();
    }

    Equivalence getKeyEquivalence() {
        return (Equivalence)Objects.firstNonNull(this.keyEquivalence, this.getKeyStrength().defaultEquivalence());
    }

    Equivalence getValueEquivalence() {
        return (Equivalence)Objects.firstNonNull(this.valueEquivalence, this.getValueStrength().defaultEquivalence());
    }

    int getInitialCapacity() {
        return this.initialCapacity == -1 ? 16 : this.initialCapacity;
    }

    int getConcurrencyLevel() {
        return this.concurrencyLevel == -1 ? 4 : this.concurrencyLevel;
    }

    long getMaximumWeight() {
        if (this.expireAfterWriteNanos == 0L || this.expireAfterAccessNanos == 0L) {
            return 0L;
        }
        return this.weigher == null ? this.maximumSize : this.maximumWeight;
    }

    Weigher getWeigher() {
        return (Weigher)Objects.firstNonNull(this.weigher, CacheBuilder$OneWeigher.INSTANCE);
    }

    public CacheBuilder weakKeys() {
        return this.setKeyStrength(LocalCache$Strength.WEAK);
    }

    CacheBuilder setKeyStrength(LocalCache$Strength localCache$Strength) {
        Preconditions.checkState(this.keyStrength == null, "Key strength was already set to %s", new Object[]{this.keyStrength});
        this.keyStrength = (LocalCache$Strength)((Object)Preconditions.checkNotNull((Object)localCache$Strength));
        return this;
    }

    LocalCache$Strength getKeyStrength() {
        return (LocalCache$Strength)((Object)Objects.firstNonNull((Object)this.keyStrength, (Object)LocalCache$Strength.STRONG));
    }

    LocalCache$Strength getValueStrength() {
        return (LocalCache$Strength)((Object)Objects.firstNonNull((Object)this.valueStrength, (Object)LocalCache$Strength.STRONG));
    }

    long getExpireAfterWriteNanos() {
        return this.expireAfterWriteNanos == -1L ? 0L : this.expireAfterWriteNanos;
    }

    long getExpireAfterAccessNanos() {
        return this.expireAfterAccessNanos == -1L ? 0L : this.expireAfterAccessNanos;
    }

    long getRefreshNanos() {
        return this.refreshNanos == -1L ? 0L : this.refreshNanos;
    }

    Ticker getTicker(boolean bl) {
        if (this.ticker != null) {
            return this.ticker;
        }
        return bl ? Ticker.systemTicker() : NULL_TICKER;
    }

    RemovalListener getRemovalListener() {
        return (RemovalListener)Objects.firstNonNull(this.removalListener, CacheBuilder$NullListener.INSTANCE);
    }

    Supplier getStatsCounterSupplier() {
        return this.statsCounterSupplier;
    }

    public LoadingCache build(CacheLoader cacheLoader) {
        this.checkWeightWithWeigher();
        return new LocalCache$LocalLoadingCache(this, cacheLoader);
    }

    private void checkWeightWithWeigher() {
        if (this.weigher == null) {
            Preconditions.checkState(this.maximumWeight == -1L, "maximumWeight requires weigher");
        } else if (this.strictParsing) {
            Preconditions.checkState(this.maximumWeight != -1L, "weigher requires maximumWeight");
        } else if (this.maximumWeight == -1L) {
            logger.log(Level.WARNING, "ignoring weigher specified without maximumWeight");
        }
    }

    public String toString() {
        Objects$ToStringHelper objects$ToStringHelper = Objects.toStringHelper(this);
        if (this.initialCapacity != -1) {
            objects$ToStringHelper.add("initialCapacity", this.initialCapacity);
        }
        if (this.concurrencyLevel != -1) {
            objects$ToStringHelper.add("concurrencyLevel", this.concurrencyLevel);
        }
        if (this.maximumSize != -1L) {
            objects$ToStringHelper.add("maximumSize", this.maximumSize);
        }
        if (this.maximumWeight != -1L) {
            objects$ToStringHelper.add("maximumWeight", this.maximumWeight);
        }
        if (this.expireAfterWriteNanos != -1L) {
            objects$ToStringHelper.add("expireAfterWrite", this.expireAfterWriteNanos + "ns");
        }
        if (this.expireAfterAccessNanos != -1L) {
            objects$ToStringHelper.add("expireAfterAccess", this.expireAfterAccessNanos + "ns");
        }
        if (this.keyStrength != null) {
            objects$ToStringHelper.add("keyStrength", Ascii.toLowerCase(this.keyStrength.toString()));
        }
        if (this.valueStrength != null) {
            objects$ToStringHelper.add("valueStrength", Ascii.toLowerCase(this.valueStrength.toString()));
        }
        if (this.keyEquivalence != null) {
            objects$ToStringHelper.addValue("keyEquivalence");
        }
        if (this.valueEquivalence != null) {
            objects$ToStringHelper.addValue("valueEquivalence");
        }
        if (this.removalListener != null) {
            objects$ToStringHelper.addValue("removalListener");
        }
        return objects$ToStringHelper.toString();
    }
}

