/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Attribute;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Element;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementArray;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementList;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementListUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementMapUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.ElementUnion;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Order;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Text;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Version;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.AttributeException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Comparer;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ConstructorException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Contact;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Creator;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ElementException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Expression;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ExpressionBuilder;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Initializer;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Label;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.LabelFactory;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.LabelMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.LabelResolver;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Model;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ModelAssembler;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Parameter;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.PersistenceException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Scanner;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Structure;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.TextException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.TreeModel;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.UnionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class StructureBuilder {
    private ExpressionBuilder builder;
    private ModelAssembler assembler;
    private LabelResolver resolver;
    private LabelMap attributes;
    private LabelMap elements;
    private LabelMap texts;
    private Comparer comparer;
    private Scanner scanner;
    private Label version;
    private Label text;
    private Model root;
    private Class type;
    private boolean primitive;

    public StructureBuilder(Scanner scanner, Class clazz) {
        this.builder = new ExpressionBuilder(clazz);
        this.assembler = new ModelAssembler(this.builder, clazz);
        this.root = new TreeModel(scanner, clazz);
        this.attributes = new LabelMap(scanner);
        this.elements = new LabelMap(scanner);
        this.texts = new LabelMap(scanner);
        this.resolver = new LabelResolver();
        this.comparer = new Comparer();
        this.scanner = scanner;
        this.type = clazz;
    }

    public void assemble(Class clazz) {
        Order order = this.scanner.getOrder();
        if (order != null) {
            this.assembler.assemble(this.root, order);
        }
    }

    public void process(Contact contact, Annotation annotation) {
        if (annotation instanceof Attribute) {
            this.process(contact, annotation, this.attributes);
        }
        if (annotation instanceof ElementUnion) {
            this.union(contact, annotation, this.elements);
        }
        if (annotation instanceof ElementListUnion) {
            this.union(contact, annotation, this.elements);
        }
        if (annotation instanceof ElementMapUnion) {
            this.union(contact, annotation, this.elements);
        }
        if (annotation instanceof ElementList) {
            this.process(contact, annotation, this.elements);
        }
        if (annotation instanceof ElementArray) {
            this.process(contact, annotation, this.elements);
        }
        if (annotation instanceof ElementMap) {
            this.process(contact, annotation, this.elements);
        }
        if (annotation instanceof Element) {
            this.process(contact, annotation, this.elements);
        }
        if (annotation instanceof Version) {
            this.version(contact, annotation);
        }
        if (annotation instanceof Text) {
            this.text(contact, annotation);
        }
    }

    private void union(Contact contact, Annotation annotation, LabelMap labelMap) {
        Annotation[] annotationArray;
        for (Annotation annotation2 : annotationArray = this.extract(annotation)) {
            Label label = LabelFactory.getInstance(contact, annotation, annotation2);
            String string = label.getPath();
            String string2 = label.getName();
            if (labelMap.get(string) != null) {
                throw new PersistenceException("Duplicate annotation of name '%s' on %s", string2, label);
            }
            this.process(contact, label, labelMap);
            this.validate(label, string);
        }
    }

    private void process(Contact contact, Annotation annotation, LabelMap labelMap) {
        Label label = LabelFactory.getInstance(contact, annotation);
        String string = label.getPath();
        String string2 = label.getName();
        if (labelMap.get(string) != null) {
            throw new PersistenceException("Duplicate annotation of name '%s' on %s", string2, contact);
        }
        this.process(contact, label, labelMap);
        this.validate(label, string);
    }

    private void process(Contact contact, Label label, LabelMap labelMap) {
        Expression expression = label.getExpression();
        String string = label.getPath();
        Model model = this.root;
        if (!expression.isEmpty()) {
            model = this.register(expression);
        }
        this.resolver.register(label);
        model.register(label);
        labelMap.put(string, label);
    }

    private void text(Contact contact, Annotation annotation) {
        Label label = LabelFactory.getInstance(contact, annotation);
        Expression expression = label.getExpression();
        String string = label.getPath();
        Model model = this.root;
        if (!expression.isEmpty()) {
            model = this.register(expression);
        }
        if (this.texts.get(string) != null) {
            throw new TextException("Multiple text annotations in %s", annotation);
        }
        this.resolver.register(label);
        model.register(label);
        this.texts.put(string, label);
    }

    private void version(Contact contact, Annotation annotation) {
        Label label = LabelFactory.getInstance(contact, annotation);
        if (this.version != null) {
            throw new AttributeException("Multiple version annotations in %s", annotation);
        }
        this.version = label;
    }

    private Annotation[] extract(Annotation annotation) {
        Class<? extends Annotation> clazz = annotation.annotationType();
        Method[] methodArray = clazz.getDeclaredMethods();
        if (methodArray.length != 1) {
            throw new UnionException("Annotation '%s' is not a valid union for %s", annotation, this.type);
        }
        Method method = methodArray[0];
        Object object = method.invoke((Object)annotation, new Object[0]);
        return (Annotation[])object;
    }

    public Structure build(Class clazz) {
        return new Structure(this.root, this.version, this.text, this.primitive);
    }

    private boolean isElement(String string) {
        Expression expression = this.builder.build(string);
        Model model = this.lookup(expression);
        if (model != null) {
            String string2 = expression.getLast();
            int n = expression.getIndex();
            if (model.isElement(string2)) {
                return true;
            }
            if (model.isModel(string2)) {
                Model model2 = model.lookup(string2, n);
                return !model2.isEmpty();
            }
        }
        return false;
    }

    private boolean isAttribute(String string) {
        Expression expression = this.builder.build(string);
        Model model = this.lookup(expression);
        if (model != null) {
            String string2 = expression.getLast();
            return model.isAttribute(string2);
        }
        return false;
    }

    private Model lookup(Expression expression) {
        Expression expression2 = expression.getPath(0, 1);
        if (expression.isPath()) {
            return this.root.lookup(expression2);
        }
        return this.root;
    }

    private Model register(Expression expression) {
        Model model = this.root.lookup(expression);
        if (model != null) {
            return model;
        }
        return this.create(expression);
    }

    private Model create(Expression expression) {
        Model model = this.root;
        while (model != null) {
            String string = expression.getPrefix();
            String string2 = expression.getFirst();
            int n = expression.getIndex();
            if (string2 != null) {
                model = model.register(string2, string, n);
            }
            if (!expression.isPath()) break;
            expression = expression.getPath(1);
        }
        return model;
    }

    public void validate(Class clazz) {
        Creator creator = this.scanner.getCreator();
        Order order = this.scanner.getOrder();
        this.validateUnions(clazz);
        this.validateElements(clazz, order);
        this.validateAttributes(clazz, order);
        this.validateParameters(creator);
        this.validateConstructors(clazz);
        this.validateModel(clazz);
        this.validateText(clazz);
    }

    private void validateModel(Class clazz) {
        if (!this.root.isEmpty()) {
            this.root.validate(clazz);
        }
    }

    private void validateText(Class clazz) {
        if (this.root.getText() != null) {
            if (!this.elements.isEmpty()) {
                throw new TextException("Elements used with %s in %s", this.text, clazz);
            }
            if (this.root.isComposite()) {
                throw new TextException("Paths used with %s in %s", this.text, clazz);
            }
        } else if (this.scanner.isEmpty()) {
            this.primitive = this.isEmpty();
        }
    }

    private void validateUnions(Class clazz) {
        for (Label label : this.elements) {
            Collection collection = label.getPaths();
            Contact contact = label.getContact();
            for (String string : collection) {
                Annotation annotation = contact.getAnnotation();
                Label label2 = (Label)this.elements.get(string);
                if (label.isInline() != label2.isInline()) {
                    throw new UnionException("Inline must be consistent in %s for %s", annotation, contact);
                }
                if (label.isRequired() == label2.isRequired()) continue;
                throw new UnionException("Required must be consistent in %s for %s", annotation, contact);
            }
        }
    }

    private void validateElements(Class clazz, Order order) {
        if (order != null) {
            for (String string : order.elements()) {
                if (this.isElement(string)) continue;
                throw new ElementException("Ordered element '%s' missing for %s", string, clazz);
            }
        }
    }

    private void validateAttributes(Class clazz, Order order) {
        if (order != null) {
            for (String string : order.attributes()) {
                if (this.isAttribute(string)) continue;
                throw new AttributeException("Ordered attribute '%s' missing in %s", string, clazz);
            }
        }
    }

    private void validateConstructors(Class clazz) {
        Creator creator = this.scanner.getCreator();
        List list = creator.getInitializers();
        if (creator.isDefault()) {
            this.validateConstructors(this.elements);
            this.validateConstructors(this.attributes);
        }
        if (!list.isEmpty()) {
            this.validateConstructors(this.elements, list);
            this.validateConstructors(this.attributes, list);
        }
    }

    private void validateConstructors(LabelMap labelMap) {
        for (Label label : labelMap) {
            Contact contact;
            if (label == null || !(contact = label.getContact()).isReadOnly()) continue;
            throw new ConstructorException("Default constructor can not accept read only %s in %s", label, this.type);
        }
    }

    private void validateConstructors(LabelMap labelMap, List list) {
        for (Label label : labelMap) {
            if (label == null) continue;
            this.validateConstructor(label, list);
        }
        if (list.isEmpty()) {
            throw new ConstructorException("No constructor accepts all read only values in %s", this.type);
        }
    }

    private void validateConstructor(Label label, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Initializer initializer = (Initializer)iterator.next();
            Contact contact = label.getContact();
            String string = label.getPath();
            if (!contact.isReadOnly()) continue;
            Parameter parameter = initializer.getParameter(string);
            Collection collection = label.getNames();
            if (parameter == null) {
                String string2;
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext() && (parameter = initializer.getParameter(string2 = (String)iterator2.next())) == null) {
                }
            }
            if (parameter != null) continue;
            iterator.remove();
        }
    }

    private void validateParameters(Creator creator) {
        List list = creator.getParameters();
        for (Parameter parameter : list) {
            Label label = this.resolver.resolve(parameter);
            String string = parameter.getPath();
            if (label != null) continue;
            throw new ConstructorException("Parameter '%s' does not have a match in %s", string, this.type);
        }
    }

    private void validate(Label label, String string) {
        Creator creator = this.scanner.getCreator();
        Parameter parameter = creator.getParameter(string);
        if (parameter != null) {
            this.validate(label, parameter);
        }
    }

    private void validate(Label label, Parameter parameter) {
        String string;
        Collection collection = label.getNames();
        Contact contact = label.getContact();
        String string2 = parameter.getName();
        Class clazz = contact.getType();
        if (clazz != parameter.getType()) {
            throw new ConstructorException("Type does not match %s for '%s' in %s", label, string2, parameter);
        }
        if (!collection.contains(string2) && string2 != (string = label.getName())) {
            if (string2 == null || string == null) {
                throw new ConstructorException("Annotation does not match %s for '%s' in %s", label, string2, parameter);
            }
            if (!string2.equals(string)) {
                throw new ConstructorException("Annotation does not match %s for '%s' in %s", label, string2, parameter);
            }
        }
        this.validateAnnotations(label, parameter);
    }

    private void validateAnnotations(Label label, Parameter parameter) {
        Class<? extends Annotation> clazz;
        Class<? extends Annotation> clazz2;
        Annotation annotation = label.getAnnotation();
        Annotation annotation2 = parameter.getAnnotation();
        String string = parameter.getName();
        if (!this.comparer.equals(annotation, annotation2) && !(clazz2 = annotation.annotationType()).equals(clazz = annotation2.annotationType())) {
            throw new ConstructorException("Annotation %s does not match %s for '%s' in %s", clazz, clazz2, string, parameter);
        }
    }

    private boolean isEmpty() {
        if (this.text != null) {
            return false;
        }
        return this.root.isEmpty();
    }
}

