/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4;

import com.carrotsearch.ant.tasks.junit4.LocalSlaveStreamHandler$1;
import com.carrotsearch.ant.tasks.junit4.LocalSlaveStreamHandler$2;
import com.carrotsearch.ant.tasks.junit4.LocalSlaveStreamHandler$3;
import com.carrotsearch.ant.tasks.junit4.LocalSlaveStreamHandler$4;
import com.carrotsearch.ant.tasks.junit4.LocalSlaveStreamHandler$OnDiskStreamEvent;
import com.carrotsearch.ant.tasks.junit4.SlaveIdle;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Lists;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus;
import com.carrotsearch.ant.tasks.junit4.events.BootstrapEvent;
import com.carrotsearch.ant.tasks.junit4.events.Deserializer;
import com.carrotsearch.ant.tasks.junit4.events.IEvent;
import com.carrotsearch.ant.tasks.junit4.events.IStreamEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.StreamPumper;

public class LocalSlaveStreamHandler
implements ExecuteStreamHandler {
    private final EventBus eventBus;
    private final ClassLoader refLoader;
    private InputStream stdout;
    private InputStream stderr;
    private OutputStream stdin;
    private OutputStreamWriter stdinWriter;
    private final PrintStream warnStream;
    private final InputStream eventStream;
    private volatile boolean stopping;
    private List pumpers = Lists.newArrayList();
    private final OutputStream sysout;
    private final OutputStream syserr;
    private final long heartbeat;
    private final RandomAccessFile streamsBuffer;
    private final OutputStream streamsBufferWrapper;
    private volatile Long lastActivity;
    private Thread watchdog;
    private Charset clientCharset;

    public LocalSlaveStreamHandler(EventBus eventBus, ClassLoader classLoader, PrintStream printStream, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, long l, RandomAccessFile randomAccessFile) {
        this.eventBus = eventBus;
        this.warnStream = printStream;
        this.refLoader = classLoader;
        this.eventStream = inputStream;
        this.sysout = outputStream;
        this.syserr = outputStream2;
        this.heartbeat = l;
        this.streamsBuffer = randomAccessFile;
        this.streamsBufferWrapper = new LocalSlaveStreamHandler$1(this, randomAccessFile);
    }

    public void setProcessErrorStream(InputStream inputStream) {
        this.stderr = inputStream;
    }

    public void setProcessOutputStream(InputStream inputStream) {
        this.stdout = inputStream;
    }

    public void setProcessInputStream(OutputStream outputStream) {
        this.stdin = outputStream;
    }

    public void start() {
        this.lastActivity = System.currentTimeMillis();
        this.pumpers.add(new Thread((Runnable)new StreamPumper(this.stdout, this.sysout), "pumper-stdout"));
        this.pumpers.add(new Thread((Runnable)new StreamPumper(this.stderr, this.syserr), "pumper-stderr"));
        this.pumpers.add(new LocalSlaveStreamHandler$2(this, "pumper-events"));
        if (this.heartbeat > 0L) {
            this.watchdog = new LocalSlaveStreamHandler$3(this, "pumper-watchdog");
            this.pumpers.add(this.watchdog);
        }
        LocalSlaveStreamHandler$4 localSlaveStreamHandler$4 = new LocalSlaveStreamHandler$4(this);
        for (Thread thread : this.pumpers) {
            thread.setUncaughtExceptionHandler(localSlaveStreamHandler$4);
            thread.setDaemon(true);
            thread.start();
        }
    }

    void pumpEvents(InputStream inputStream) {
        block15: {
            try {
                Deserializer deserializer = new Deserializer(inputStream, this.refLoader);
                IEvent iEvent = null;
                block13: while ((iEvent = deserializer.deserialize()) != null) {
                    switch (iEvent.getType()) {
                        case APPEND_STDERR: 
                        case APPEND_STDOUT: {
                            break;
                        }
                        default: {
                            this.lastActivity = System.currentTimeMillis();
                        }
                    }
                    try {
                        switch (iEvent.getType()) {
                            case QUIT: {
                                this.eventBus.post(iEvent);
                                return;
                            }
                            case IDLE: {
                                this.eventBus.post(new SlaveIdle(this.stdinWriter));
                                continue block13;
                            }
                            case BOOTSTRAP: {
                                this.clientCharset = Charset.forName(((BootstrapEvent)iEvent).getDefaultCharsetName());
                                this.stdinWriter = new OutputStreamWriter(this.stdin, this.clientCharset);
                                this.eventBus.post(iEvent);
                                continue block13;
                            }
                            case APPEND_STDERR: 
                            case APPEND_STDOUT: {
                                assert (this.streamsBuffer.getFilePointer() == this.streamsBuffer.length());
                                long l = this.streamsBuffer.getFilePointer();
                                IStreamEvent iStreamEvent = (IStreamEvent)((Object)iEvent);
                                iStreamEvent.copyTo(this.streamsBufferWrapper);
                                long l2 = this.streamsBuffer.getFilePointer();
                                iEvent = new LocalSlaveStreamHandler$OnDiskStreamEvent(iEvent.getType(), this.streamsBuffer, l, l2);
                                this.eventBus.post(iEvent);
                                continue block13;
                            }
                        }
                        this.eventBus.post(iEvent);
                    }
                    catch (Throwable throwable) {
                        this.warnStream.println("Event bus dispatch error: " + throwable.toString());
                        throwable.printStackTrace(this.warnStream);
                    }
                }
                this.lastActivity = null;
            }
            catch (Throwable throwable) {
                if (this.stopping) break block15;
                this.warnStream.println("Event stream error: " + throwable.toString());
                throwable.printStackTrace(this.warnStream);
            }
        }
    }

    public void stop() {
        this.lastActivity = null;
        this.stopping = true;
        try {
            if (this.watchdog != null) {
                this.watchdog.interrupt();
            }
            int n = 2000;
            for (Thread thread : this.pumpers) {
                thread.join(2000L);
                thread.interrupt();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static /* synthetic */ InputStream access$000(LocalSlaveStreamHandler localSlaveStreamHandler) {
        return localSlaveStreamHandler.eventStream;
    }

    static /* synthetic */ long access$100(LocalSlaveStreamHandler localSlaveStreamHandler) {
        return localSlaveStreamHandler.heartbeat;
    }

    static /* synthetic */ Long access$200(LocalSlaveStreamHandler localSlaveStreamHandler) {
        return localSlaveStreamHandler.lastActivity;
    }

    static /* synthetic */ EventBus access$300(LocalSlaveStreamHandler localSlaveStreamHandler) {
        return localSlaveStreamHandler.eventBus;
    }

    static /* synthetic */ PrintStream access$400(LocalSlaveStreamHandler localSlaveStreamHandler) {
        return localSlaveStreamHandler.warnStream;
    }
}

