/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.events.json;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonDeserializationContext;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonDeserializer;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonElement;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonParseException;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonPrimitive;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonSerializationContext;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonSerializer;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Type;

public class JsonByteArrayAdapter
implements JsonDeserializer,
JsonSerializer {
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();
    private final StringBuilder bb = new StringBuilder();
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

    public JsonElement serialize(byte[] byArray, Type type, JsonSerializationContext jsonSerializationContext) {
        return new JsonPrimitive(this.toAscii(byArray));
    }

    private String toAscii(byte[] byArray) {
        this.bb.setLength(0);
        for (byte by : byArray) {
            if (by >= 32 && by <= 126 && by != 37) {
                this.bb.append((char)by);
                continue;
            }
            this.bb.append('%');
            this.bb.append(HEX[by >> 4 & 0xF]);
            this.bb.append(HEX[by & 0xF]);
        }
        return this.bb.toString();
    }

    private int hexValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new JsonParseException("Unexpected character in binary stream: " + c);
    }

    public byte[] deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        if (type.equals(byte[].class)) {
            throw new JsonParseException("Not a byte[]: " + type);
        }
        String string = jsonElement.getAsString();
        this.baos.reset();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '%') {
                this.baos.write(c);
                continue;
            }
            this.baos.write(this.hexValue(string.charAt(++i)) << 4 | this.hexValue(string.charAt(++i)));
        }
        return this.baos.toByteArray();
    }
}

