/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Throwables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheBuilder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LoadingCache;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.HashMultimap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Multimap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.SetMultimap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.AnnotatedSubscriberFinder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.DeadEvent;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus$2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus$3;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus$EventWithSubscriber;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus$LoggingSubscriberExceptionHandler;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventSubscriber;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.SubscriberExceptionContext;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.SubscriberExceptionHandler;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.SubscriberFindingStrategy;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.InvocationTargetException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventBus {
    private static final LoadingCache flattenHierarchyCache = CacheBuilder.newBuilder().weakKeys().build(new EventBus$1());
    private final SetMultimap subscribersByType = HashMultimap.create();
    private final ReadWriteLock subscribersByTypeLock = new ReentrantReadWriteLock();
    private final SubscriberFindingStrategy finder = new AnnotatedSubscriberFinder();
    private final ThreadLocal eventsToDispatch = new EventBus$2(this);
    private final ThreadLocal isDispatching = new EventBus$3(this);
    private SubscriberExceptionHandler subscriberExceptionHandler;

    public EventBus() {
        this("default");
    }

    public EventBus(String string) {
        this(new EventBus$LoggingSubscriberExceptionHandler(string));
    }

    public EventBus(SubscriberExceptionHandler subscriberExceptionHandler) {
        this.subscriberExceptionHandler = (SubscriberExceptionHandler)Preconditions.checkNotNull(subscriberExceptionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Object object) {
        Multimap multimap = this.finder.findAllSubscribers(object);
        this.subscribersByTypeLock.writeLock().lock();
        try {
            this.subscribersByType.putAll(multimap);
        }
        finally {
            this.subscribersByTypeLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Object object) {
        Set set = this.flattenHierarchy(object.getClass());
        boolean bl = false;
        for (Class clazz : set) {
            this.subscribersByTypeLock.readLock().lock();
            try {
                Set set2 = this.subscribersByType.get(clazz);
                if (set2.isEmpty()) continue;
                bl = true;
                for (EventSubscriber eventSubscriber : set2) {
                    this.enqueueEvent(object, eventSubscriber);
                }
            }
            finally {
                this.subscribersByTypeLock.readLock().unlock();
            }
        }
        if (!bl && !(object instanceof DeadEvent)) {
            this.post(new DeadEvent(this, object));
        }
        this.dispatchQueuedEvents();
    }

    void enqueueEvent(Object object, EventSubscriber eventSubscriber) {
        ((Queue)this.eventsToDispatch.get()).offer(new EventBus$EventWithSubscriber(object, eventSubscriber));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchQueuedEvents() {
        if (((Boolean)this.isDispatching.get()).booleanValue()) {
            return;
        }
        this.isDispatching.set(true);
        try {
            EventBus$EventWithSubscriber eventBus$EventWithSubscriber;
            Queue queue = (Queue)this.eventsToDispatch.get();
            while ((eventBus$EventWithSubscriber = (EventBus$EventWithSubscriber)queue.poll()) != null) {
                this.dispatch(eventBus$EventWithSubscriber.event, eventBus$EventWithSubscriber.subscriber);
            }
        }
        finally {
            this.isDispatching.remove();
            this.eventsToDispatch.remove();
        }
    }

    void dispatch(Object object, EventSubscriber eventSubscriber) {
        try {
            eventSubscriber.handleEvent(object);
        }
        catch (InvocationTargetException invocationTargetException) {
            try {
                this.subscriberExceptionHandler.handleException(invocationTargetException.getCause(), new SubscriberExceptionContext(this, object, eventSubscriber.getSubscriber(), eventSubscriber.getMethod()));
            }
            catch (Throwable throwable) {
                Logger.getLogger(EventBus.class.getName()).log(Level.SEVERE, String.format("Exception %s thrown while handling exception: %s", throwable, invocationTargetException.getCause()), throwable);
            }
        }
    }

    Set flattenHierarchy(Class clazz) {
        try {
            return (Set)flattenHierarchyCache.getUnchecked(clazz);
        }
        catch (UncheckedExecutionException uncheckedExecutionException) {
            throw Throwables.propagate(uncheckedExecutionException.getCause());
        }
    }
}

