/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.noggit.CharArr;
import org.noggit.JSONParser;
import org.noggit.JSONWriter;
import org.noggit.ObjectBuilder;

public class SolrCLI {
    public static Logger log = Logger.getLogger(SolrCLI.class);
    public static final String DEFAULT_SOLR_URL = "http://localhost:8983/solr";
    public static final String ZK_HOST = "localhost:9983";
    public static Option[] cloudOptions;
    private static final String DEFAULT_CONFIG_SET = "data_driven_schema_configs";
    private static final long MS_IN_MIN = 60000L;
    private static final long MS_IN_HOUR = 3600000L;
    private static final long MS_IN_DAY = 86400000L;
    private static final Option[] CREATE_COLLECTION_OPTIONS;
    public static final String JSON_CONTENT_TYPE = "application/json";

    public static void main(String[] args) throws Exception {
        String configurerClassName;
        if (args == null || args.length == 0 || args[0] == null || args[0].trim().length() == 0) {
            System.err.println("Invalid command-line args! Must pass the name of a tool to run.\nSupported tools:\n");
            SolrCLI.displayToolOptions(System.err);
            System.exit(1);
        }
        if ((configurerClassName = System.getProperty("solr.authentication.httpclient.configurer")) != null) {
            try {
                Class<?> c = Class.forName(configurerClassName);
                HttpClientConfigurer configurer = (HttpClientConfigurer)c.newInstance();
                HttpClientUtil.setConfigurer((HttpClientConfigurer)configurer);
                log.info((Object)("Set HttpClientConfigurer from: " + configurerClassName));
            }
            catch (Exception ex) {
                throw new RuntimeException("Error during loading of configurer '" + configurerClassName + "'.", ex);
            }
        }
        String toolType = args[0].trim().toLowerCase(Locale.ROOT);
        Tool tool = SolrCLI.newTool(toolType);
        String[] toolArgs = new String[args.length - 1];
        System.arraycopy(args, 1, toolArgs, 0, toolArgs.length);
        CommandLine cli = SolrCLI.processCommandLineArgs(SolrCLI.joinCommonAndToolOptions(tool.getOptions()), toolArgs);
        String solrInstallDir = System.getProperty("solr.install.dir");
        if (solrInstallDir != null) {
            SolrCLI.checkSslStoreSysProp(solrInstallDir, "keyStore");
            SolrCLI.checkSslStoreSysProp(solrInstallDir, "trustStore");
        }
        System.exit(tool.runTool(cli));
    }

    protected static void checkSslStoreSysProp(String solrInstallDir, String key) {
        String sysProp = "javax.net.ssl." + key;
        String keyStore = System.getProperty(sysProp);
        if (keyStore == null) {
            return;
        }
        File keyStoreFile = new File(keyStore);
        if (keyStoreFile.isFile()) {
            return;
        }
        keyStoreFile = new File(solrInstallDir, "server/" + keyStore);
        if (keyStoreFile.isFile()) {
            System.setProperty(sysProp, keyStoreFile.getAbsolutePath());
        } else {
            System.err.println("WARNING: " + sysProp + " file " + keyStore + " not found! https requests to Solr will likely fail; please update your " + sysProp + " setting to use an absolute path.");
        }
    }

    public static Option[] getCommonToolOptions() {
        return new Option[0];
    }

    private static Tool newTool(String toolType) throws Exception {
        if ("healthcheck".equals(toolType)) {
            return new HealthcheckTool();
        }
        if ("status".equals(toolType)) {
            return new StatusTool();
        }
        if ("api".equals(toolType)) {
            return new ApiTool();
        }
        if ("create_collection".equals(toolType)) {
            return new CreateCollectionTool();
        }
        if ("create_core".equals(toolType)) {
            return new CreateCoreTool();
        }
        if ("create".equals(toolType)) {
            return new CreateTool();
        }
        if ("delete".equals(toolType)) {
            return new DeleteTool();
        }
        if ("config".equals(toolType)) {
            return new ConfigTool();
        }
        for (Class<Tool> next : SolrCLI.findToolClassesInPackage("org.apache.solr.util")) {
            Tool tool = next.newInstance();
            if (!toolType.equals(tool.getName())) continue;
            return tool;
        }
        throw new IllegalArgumentException(toolType + " not supported!");
    }

    private static void displayToolOptions(PrintStream out) throws Exception {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("healthcheck", SolrCLI.getToolOptions(new HealthcheckTool()));
        formatter.printHelp("status", SolrCLI.getToolOptions(new StatusTool()));
        formatter.printHelp("api", SolrCLI.getToolOptions(new ApiTool()));
        formatter.printHelp("create_collection", SolrCLI.getToolOptions(new CreateCollectionTool()));
        formatter.printHelp("create_core", SolrCLI.getToolOptions(new CreateCoreTool()));
        formatter.printHelp("create", SolrCLI.getToolOptions(new CreateTool()));
        formatter.printHelp("delete", SolrCLI.getToolOptions(new DeleteTool()));
        formatter.printHelp("config", SolrCLI.getToolOptions(new ConfigTool()));
        List<Class<Tool>> toolClasses = SolrCLI.findToolClassesInPackage("org.apache.solr.util");
        for (Class<Tool> next : toolClasses) {
            Tool tool = next.newInstance();
            formatter.printHelp(tool.getName(), SolrCLI.getToolOptions(tool));
        }
    }

    private static Options getToolOptions(Tool tool) {
        Options options = new Options();
        options.addOption("h", "help", false, "Print this message");
        options.addOption("v", "verbose", false, "Generate verbose log messages");
        Option[] toolOpts = SolrCLI.joinCommonAndToolOptions(tool.getOptions());
        for (int i = 0; i < toolOpts.length; ++i) {
            options.addOption(toolOpts[i]);
        }
        return options;
    }

    public static Option[] joinCommonAndToolOptions(Option[] toolOpts) {
        return SolrCLI.joinOptions(SolrCLI.getCommonToolOptions(), toolOpts);
    }

    public static Option[] joinOptions(Option[] lhs, Option[] rhs) {
        ArrayList<Option> options = new ArrayList<Option>();
        if (lhs != null && lhs.length > 0) {
            for (Option opt : lhs) {
                options.add(opt);
            }
        }
        if (rhs != null) {
            for (Option opt : rhs) {
                options.add(opt);
            }
        }
        return options.toArray(new Option[0]);
    }

    public static CommandLine processCommandLineArgs(Option[] customOptions, String[] args) {
        Options options = new Options();
        options.addOption("h", "help", false, "Print this message");
        options.addOption("v", "verbose", false, "Generate verbose log messages");
        if (customOptions != null) {
            for (int i = 0; i < customOptions.length; ++i) {
                options.addOption(customOptions[i]);
            }
        }
        CommandLine cli = null;
        try {
            cli = new GnuParser().parse(options, args);
        }
        catch (ParseException exp) {
            boolean hasHelpArg = false;
            if (args != null && args.length > 0) {
                for (int z = 0; z < args.length; ++z) {
                    if (!"-h".equals(args[z]) && !"-help".equals(args[z])) continue;
                    hasHelpArg = true;
                    break;
                }
            }
            if (!hasHelpArg) {
                System.err.println("Failed to parse command-line arguments due to: " + exp.getMessage());
            }
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(SolrCLI.class.getName(), options);
            System.exit(1);
        }
        if (cli.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(SolrCLI.class.getName(), options);
            System.exit(0);
        }
        return cli;
    }

    private static List<Class<Tool>> findToolClassesInPackage(String packageName) {
        ArrayList<Class<Tool>> toolClasses = new ArrayList<Class<Tool>>();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String path = packageName.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(path);
            TreeSet<String> classes = new TreeSet<String>();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                classes.addAll(SolrCLI.findClasses(resource.getFile(), packageName));
            }
            for (String classInPackage : classes) {
                Class<?> theClass = Class.forName(classInPackage);
                if (!Tool.class.isAssignableFrom(theClass)) continue;
                toolClasses.add(theClass);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return toolClasses;
    }

    private static Set<String> findClasses(String path, String packageName) throws Exception {
        TreeSet<String> classes = new TreeSet<String>();
        if (path.startsWith("file:") && path.contains("!")) {
            ZipEntry entry;
            String[] split = path.split("!");
            URL jar = new URL(split[0]);
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            while ((entry = zip.getNextEntry()) != null) {
                String className;
                if (!entry.getName().endsWith(".class") || !(className = entry.getName().replaceAll("[$].*", "").replaceAll("[.]class", "").replace('/', '.')).startsWith(packageName)) continue;
                classes.add(className);
            }
        }
        return classes;
    }

    public static boolean checkCommunicationError(Exception exc) {
        Throwable rootCause = SolrException.getRootCause((Throwable)exc);
        boolean wasCommError = rootCause instanceof ConnectException || rootCause instanceof ConnectTimeoutException || rootCause instanceof NoHttpResponseException || rootCause instanceof SocketException;
        return wasCommError;
    }

    public static CloseableHttpClient getHttpClient() {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("maxConnections", 128);
        params.set("maxConnectionsPerHost", 32);
        params.set("followRedirects", false);
        return HttpClientUtil.createClient((SolrParams)params);
    }

    public static void closeHttpClient(CloseableHttpClient httpClient) {
        if (httpClient != null) {
            try {
                HttpClientUtil.close((HttpClient)httpClient);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getJson(String getUrl) throws Exception {
        Map<String, Object> json = null;
        CloseableHttpClient httpClient = SolrCLI.getHttpClient();
        try {
            json = SolrCLI.getJson((HttpClient)httpClient, getUrl, 2);
        }
        finally {
            SolrCLI.closeHttpClient(httpClient);
        }
        return json;
    }

    public static Map<String, Object> getJson(HttpClient httpClient, String getUrl, int attempts) throws Exception {
        Map<String, Object> json = null;
        if (attempts >= 1) {
            try {
                json = SolrCLI.getJson(httpClient, getUrl);
            }
            catch (Exception exc) {
                if (--attempts > 0 && SolrCLI.checkCommunicationError(exc)) {
                    log.warn((Object)("Request to " + getUrl + " failed due to: " + exc.getMessage() + ", sleeping for 5 seconds before re-trying the request ..."));
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.interrupted();
                    }
                    json = SolrCLI.getJson(httpClient, getUrl, attempts);
                }
                throw exc;
            }
        }
        return json;
    }

    public static Map<String, Object> getJson(HttpClient httpClient, String getUrl) throws Exception {
        HttpGet httpGet = new HttpGet(new URIBuilder(getUrl).setParameter("wt", "json").build());
        Map json = (Map)httpClient.execute((HttpUriRequest)httpGet, (ResponseHandler)new SolrResponseHandler());
        Long statusCode = SolrCLI.asLong("/responseHeader/status", json);
        if (statusCode == -1L) {
            throw new SolrServerException("Unable to determine outcome of GET request to: " + getUrl + "! Response: " + json);
        }
        if (statusCode != 0L) {
            String errMsg = SolrCLI.asString("/error/msg", json);
            if (errMsg == null) {
                errMsg = String.valueOf(json);
            }
            throw new SolrServerException(errMsg);
        }
        return json;
    }

    public static String asString(String jsonPath, Map<String, Object> json) {
        return SolrCLI.pathAs(String.class, jsonPath, json);
    }

    public static Long asLong(String jsonPath, Map<String, Object> json) {
        return SolrCLI.pathAs(Long.class, jsonPath, json);
    }

    public static List<String> asList(String jsonPath, Map<String, Object> json) {
        return SolrCLI.pathAs(List.class, jsonPath, json);
    }

    public static Map<String, Object> asMap(String jsonPath, Map<String, Object> json) {
        return SolrCLI.pathAs(Map.class, jsonPath, json);
    }

    public static <T> T pathAs(Class<T> clazz, String jsonPath, Map<String, Object> json) {
        Object val = null;
        Object obj = SolrCLI.atPath(jsonPath, json);
        if (obj != null) {
            if (clazz.isAssignableFrom(obj.getClass())) {
                val = obj;
            } else {
                throw new IllegalStateException("Expected a " + clazz.getName() + " at path " + jsonPath + " but found " + obj + " instead! " + json);
            }
        }
        return (T)val;
    }

    public static Object atPath(String jsonPath, Map<String, Object> json) {
        Object child;
        if ("/".equals(jsonPath)) {
            return json;
        }
        if (!jsonPath.startsWith("/")) {
            throw new IllegalArgumentException("Invalid JSON path: " + jsonPath + "! Must start with a /");
        }
        Map parent = json;
        Object result = null;
        String[] path = jsonPath.split("/");
        for (int p = 1; p < path.length && (child = parent.get(path[p])) != null; ++p) {
            if (p == path.length - 1) {
                result = child;
                continue;
            }
            if (!(child instanceof Map)) break;
            parent = (Map)child;
        }
        return result;
    }

    private static final String uptime(long uptimeMs) {
        if (uptimeMs <= 0L) {
            return "?";
        }
        long numDays = uptimeMs >= 86400000L ? (long)Math.floor(uptimeMs / 86400000L) : 0L;
        long rem = uptimeMs - numDays * 86400000L;
        long numHours = rem >= 3600000L ? (long)Math.floor(rem / 3600000L) : 0L;
        long numMinutes = (rem -= numHours * 3600000L) >= 60000L ? (long)Math.floor(rem / 60000L) : 0L;
        long numSeconds = Math.round((rem -= numMinutes * 60000L) / 1000L);
        return String.format(Locale.ROOT, "%d days, %d hours, %d minutes, %d seconds", numDays, numHours, numMinutes, numSeconds);
    }

    public static String resolveSolrUrl(CommandLine cli) throws Exception {
        String solrUrl = cli.getOptionValue("solrUrl");
        if (solrUrl == null) {
            String zkHost = cli.getOptionValue("zkHost");
            if (zkHost == null) {
                throw new IllegalStateException("Must provide either the '-solrUrl' or '-zkHost' parameters!");
            }
            LogManager.getLogger((String)"org.apache.zookeeper").setLevel(Level.ERROR);
            LogManager.getLogger((String)"org.apache.solr.common.cloud").setLevel(Level.WARN);
            try (CloudSolrClient cloudSolrClient = new CloudSolrClient(zkHost);){
                cloudSolrClient.connect();
                Set liveNodes = cloudSolrClient.getZkStateReader().getClusterState().getLiveNodes();
                if (liveNodes.isEmpty()) {
                    throw new IllegalStateException("No live nodes found! Cannot determine 'solrUrl' from ZooKeeper: " + zkHost);
                }
                String firstLiveNode = (String)liveNodes.iterator().next();
                solrUrl = cloudSolrClient.getZkStateReader().getBaseUrlForNodeName(firstLiveNode);
            }
        }
        return solrUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getZkHost(CommandLine cli) throws Exception {
        String zkHost = cli.getOptionValue("zkHost");
        if (zkHost != null) {
            return zkHost;
        }
        String solrUrl = cli.getOptionValue("solrUrl");
        if (solrUrl == null) {
            throw new IllegalStateException("Must provide either the -zkHost or -solrUrl parameters to use the create_collection command!");
        }
        if (!solrUrl.endsWith("/")) {
            solrUrl = solrUrl + "/";
        }
        String systemInfoUrl = solrUrl + "admin/info/system";
        CloseableHttpClient httpClient = SolrCLI.getHttpClient();
        try {
            Map<String, Object> systemInfo = SolrCLI.getJson((HttpClient)httpClient, systemInfoUrl, 2);
            StatusTool statusTool = new StatusTool();
            Map<String, Object> status = statusTool.reportStatus(solrUrl, systemInfo, (HttpClient)httpClient);
            Map cloud = (Map)status.get("cloud");
            if (cloud != null) {
                String zookeeper = (String)cloud.get("ZooKeeper");
                if (zookeeper.endsWith("(embedded)")) {
                    zookeeper = zookeeper.substring(0, zookeeper.length() - "(embedded)".length());
                }
                zkHost = zookeeper;
            }
        }
        finally {
            HttpClientUtil.close((HttpClient)httpClient);
        }
        return zkHost;
    }

    public static boolean safeCheckCollectionExists(String url, String collection) {
        boolean exists = false;
        try {
            Map<String, Object> existsCheckResult = SolrCLI.getJson(url);
            List collections = (List)existsCheckResult.get("collections");
            exists = collections != null && collections.contains(collection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exists;
    }

    public static NamedList<Object> postJsonToSolr(SolrClient solrClient, String updatePath, String jsonBody) throws Exception {
        ContentStreamBase.StringStream contentStream = new ContentStreamBase.StringStream(jsonBody);
        contentStream.setContentType(JSON_CONTENT_TYPE);
        ContentStreamUpdateRequest req = new ContentStreamUpdateRequest(updatePath);
        req.addContentStream((ContentStream)contentStream);
        return solrClient.request((SolrRequest)req);
    }

    static {
        Option[] optionArray = new Option[2];
        OptionBuilder.withArgName((String)"HOST");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Address of the Zookeeper ensemble; defaults to: localhost:9983");
        optionArray[0] = OptionBuilder.create((String)"zkHost");
        OptionBuilder.withArgName((String)"COLLECTION");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Name of collection; no default");
        optionArray[1] = OptionBuilder.create((String)"collection");
        cloudOptions = optionArray;
        Option[] optionArray2 = new Option[9];
        OptionBuilder.withArgName((String)"HOST");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Address of the Zookeeper ensemble; defaults to: localhost:9983");
        optionArray2[0] = OptionBuilder.create((String)"zkHost");
        OptionBuilder.withArgName((String)"HOST");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Base Solr URL, which can be used to determine the zkHost if that's not known");
        optionArray2[1] = OptionBuilder.create((String)"solrUrl");
        OptionBuilder.withArgName((String)"NAME");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Name of collection to create.");
        optionArray2[2] = OptionBuilder.create((String)"name");
        OptionBuilder.withArgName((String)"#");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Number of shards; default is 1");
        optionArray2[3] = OptionBuilder.create((String)"shards");
        OptionBuilder.withArgName((String)"#");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Number of copies of each document across the collection (replicas per shard); default is 1");
        optionArray2[4] = OptionBuilder.create((String)"replicationFactor");
        OptionBuilder.withArgName((String)"#");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Maximum number of shards per Solr node; default is determined based on the number of shards, replication factor, and live nodes.");
        optionArray2[5] = OptionBuilder.create((String)"maxShardsPerNode");
        OptionBuilder.withArgName((String)"NAME");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Configuration directory to copy when creating the new collection; default is data_driven_schema_configs");
        optionArray2[6] = OptionBuilder.create((String)"confdir");
        OptionBuilder.withArgName((String)"NAME");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Configuration name; default is the collection name");
        optionArray2[7] = OptionBuilder.create((String)"confname");
        OptionBuilder.withArgName((String)"DIR");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Path to configsets directory on the local system.");
        optionArray2[8] = OptionBuilder.create((String)"configsetsDir");
        CREATE_COLLECTION_OPTIONS = optionArray2;
    }

    public static class ConfigTool
    implements Tool {
        @Override
        public String getName() {
            return "config";
        }

        @Override
        public Option[] getOptions() {
            Option[] optionArray = new Option[6];
            OptionBuilder.withArgName((String)"ACTION");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Config API action, one of: set-property, unset-property; default is set-property");
            optionArray[0] = OptionBuilder.create((String)"action");
            OptionBuilder.withArgName((String)"PROP");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)true);
            OptionBuilder.withDescription((String)"Name of the Config API property to apply the action to, such as: updateHandler.autoSoftCommit.maxTime");
            optionArray[1] = OptionBuilder.create((String)"property");
            OptionBuilder.withArgName((String)"VALUE");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Set the property to this value; accepts JSON objects and strings");
            optionArray[2] = OptionBuilder.create((String)"value");
            OptionBuilder.withArgName((String)"COLL");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Collection; defaults to gettingstarted");
            optionArray[3] = OptionBuilder.create((String)"collection");
            OptionBuilder.withArgName((String)"HOST");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Address of the Zookeeper ensemble");
            optionArray[4] = OptionBuilder.create((String)"zkHost");
            OptionBuilder.withArgName((String)"HOST");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Base Solr URL, which can be used to determine the zkHost if that's not known");
            optionArray[5] = OptionBuilder.create((String)"solrUrl");
            return optionArray;
        }

        @Override
        public int runTool(CommandLine cli) throws Exception {
            String solrUrl = SolrCLI.resolveSolrUrl(cli);
            String action = cli.getOptionValue("action", "set-property");
            String collection = cli.getOptionValue("collection", "gettingstarted");
            String property = cli.getOptionValue("property");
            String value = cli.getOptionValue("value");
            HashMap<String, Object> jsonObj = new HashMap<String, Object>();
            if (value != null) {
                HashMap<String, String> setMap = new HashMap<String, String>();
                setMap.put(property, value);
                jsonObj.put(action, setMap);
            } else {
                jsonObj.put(action, property);
            }
            CharArr arr = new CharArr();
            new JSONWriter(arr, 0).write(jsonObj);
            String jsonBody = arr.toString();
            String updatePath = "/" + collection + "/config";
            System.out.println("\nPOSTing request to Config API: " + solrUrl + updatePath);
            System.out.println(jsonBody);
            System.out.println();
            int exitStatus = 0;
            try (HttpSolrClient solrClient = new HttpSolrClient(solrUrl);){
                NamedList<Object> result = SolrCLI.postJsonToSolr((SolrClient)solrClient, updatePath, jsonBody);
                Integer statusCode = (Integer)((NamedList)result.get("responseHeader")).get("status");
                if (statusCode == 0) {
                    if (value != null) {
                        System.out.println("Successfully " + action + " " + property + " to " + value);
                    } else {
                        System.out.println("Successfully " + action + " " + property);
                    }
                } else {
                    String errMsg = "Failed to " + action + " property due to:\n" + result;
                    System.err.println("\nERROR: " + errMsg + "\n");
                    exitStatus = 1;
                }
            }
            return exitStatus;
        }
    }

    public static class DeleteTool
    implements Tool {
        @Override
        public String getName() {
            return "delete";
        }

        @Override
        public Option[] getOptions() {
            Option[] optionArray = new Option[5];
            OptionBuilder.withArgName((String)"URL");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Base Solr URL, default is http://localhost:8983/solr");
            optionArray[0] = OptionBuilder.create((String)"solrUrl");
            OptionBuilder.withArgName((String)"NAME");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)true);
            OptionBuilder.withDescription((String)"Name of the core / collection to delete.");
            optionArray[1] = OptionBuilder.create((String)"name");
            OptionBuilder.withArgName((String)"true|false");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Flag to indicate if the underlying configuration directory for a collection should also be deleted; default is true");
            optionArray[2] = OptionBuilder.create((String)"deleteConfig");
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Skip safety checks when deleting the configuration directory used by a collection");
            optionArray[3] = OptionBuilder.create((String)"forceDeleteConfig");
            OptionBuilder.withArgName((String)"HOST");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Address of the Zookeeper ensemble; defaults to: localhost:9983");
            optionArray[4] = OptionBuilder.create((String)"zkHost");
            return optionArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int runTool(CommandLine cli) throws Exception {
            LogManager.getLogger((String)"org.apache.zookeeper").setLevel(Level.ERROR);
            LogManager.getLogger((String)"org.apache.solr.common.cloud").setLevel(Level.WARN);
            String solrUrl = cli.getOptionValue("solrUrl", SolrCLI.DEFAULT_SOLR_URL);
            if (!solrUrl.endsWith("/")) {
                solrUrl = solrUrl + "/";
            }
            String systemInfoUrl = solrUrl + "admin/info/system";
            CloseableHttpClient httpClient = SolrCLI.getHttpClient();
            int result = 0;
            try {
                Map<String, Object> systemInfo = SolrCLI.getJson((HttpClient)httpClient, systemInfoUrl, 2);
                result = "solrcloud".equals(systemInfo.get("mode")) ? this.deleteCollection(cli) : this.deleteCore(cli, httpClient, solrUrl);
            }
            finally {
                SolrCLI.closeHttpClient(httpClient);
            }
            return result;
        }

        protected int deleteCollection(CommandLine cli) throws Exception {
            String zkHost = SolrCLI.getZkHost(cli);
            int toolExitStatus = 0;
            try (CloudSolrClient cloudSolrClient = new CloudSolrClient(zkHost);){
                System.out.println("Connecting to ZooKeeper at " + zkHost);
                cloudSolrClient.connect();
                toolExitStatus = this.deleteCollection(cloudSolrClient, cli);
            }
            catch (Exception exc) {
                String excMsg = exc.getMessage();
                if (excMsg != null) {
                    System.err.println("\nERROR: " + excMsg + "\n");
                    toolExitStatus = 1;
                }
                throw exc;
            }
            return toolExitStatus;
        }

        protected int deleteCollection(CloudSolrClient cloudSolrClient, CommandLine cli) throws Exception {
            Set liveNodes = cloudSolrClient.getZkStateReader().getClusterState().getLiveNodes();
            if (liveNodes.isEmpty()) {
                throw new IllegalStateException("No live nodes found! Cannot delete a collection until there is at least 1 live node in the cluster.");
            }
            String firstLiveNode = (String)liveNodes.iterator().next();
            ZkStateReader zkStateReader = cloudSolrClient.getZkStateReader();
            String baseUrl = zkStateReader.getBaseUrlForNodeName(firstLiveNode);
            String collectionName = cli.getOptionValue("name");
            if (!zkStateReader.getClusterState().hasCollection(collectionName)) {
                System.err.println("\nERROR: Collection " + collectionName + " not found!");
                System.err.println();
                return 1;
            }
            String configName = zkStateReader.readConfigName(collectionName);
            boolean deleteConfig = "true".equals(cli.getOptionValue("deleteConfig", "true"));
            if (deleteConfig && configName != null) {
                if (cli.hasOption("forceDeleteConfig")) {
                    log.warn((Object)("Skipping safety checks, configuration directory " + configName + " will be deleted with impunity."));
                } else {
                    Set collections = zkStateReader.getClusterState().getCollections();
                    if (collections.size() > 50) {
                        log.info((Object)("Scanning " + collections.size() + " to ensure no other collections are using config " + configName));
                    }
                    for (String next : collections) {
                        if (collectionName.equals(next) || !configName.equals(zkStateReader.readConfigName(next))) continue;
                        deleteConfig = false;
                        log.warn((Object)("Configuration directory " + configName + " is also being used by " + next + "; configuration will not be deleted from ZooKeeper. You can pass the -forceDeleteConfig flag to force delete."));
                        break;
                    }
                }
            }
            String deleteCollectionUrl = String.format(Locale.ROOT, "%s/admin/collections?action=DELETE&name=%s", baseUrl, collectionName);
            System.out.println("\nDeleting collection '" + collectionName + "' using command:\n" + deleteCollectionUrl + "\n");
            Map<String, Object> json = null;
            try {
                json = SolrCLI.getJson(deleteCollectionUrl);
            }
            catch (SolrServerException sse) {
                System.err.println("Failed to delete collection '" + collectionName + "' due to: " + sse.getMessage());
                System.err.println();
                return 1;
            }
            if (deleteConfig) {
                String configZnode = "/configs/" + configName;
                try {
                    zkStateReader.getZkClient().clean(configZnode);
                }
                catch (Exception exc) {
                    System.err.println("\nERROR: Failed to delete configuration directory " + configZnode + " in ZooKeeper due to: " + exc.getMessage() + "\nYou'll need to manually delete this znode using the zkcli script.");
                }
            }
            if (json != null) {
                CharArr arr = new CharArr();
                new JSONWriter(arr, 2).write(json);
                System.out.println(arr.toString());
                System.out.println();
            }
            return 0;
        }

        protected int deleteCore(CommandLine cli, CloseableHttpClient httpClient, String solrUrl) throws Exception {
            int status = 0;
            String coreName = cli.getOptionValue("name");
            String deleteCoreUrl = String.format(Locale.ROOT, "%sadmin/cores?action=UNLOAD&core=%s&deleteIndex=true&deleteDataDir=true&deleteInstanceDir=true", solrUrl, coreName);
            System.out.println("\nDeleting core '" + coreName + "' using command:\n" + deleteCoreUrl + "\n");
            Map<String, Object> json = null;
            try {
                json = SolrCLI.getJson(deleteCoreUrl);
            }
            catch (SolrServerException sse) {
                System.err.println("Failed to delete core '" + coreName + "' due to: " + sse.getMessage());
                System.err.println();
                status = 1;
            }
            if (json != null) {
                CharArr arr = new CharArr();
                new JSONWriter(arr, 2).write(json);
                System.out.println(arr.toString());
                System.out.println();
            }
            return status;
        }
    }

    public static class CreateTool
    implements Tool {
        @Override
        public String getName() {
            return "create";
        }

        @Override
        public Option[] getOptions() {
            return CREATE_COLLECTION_OPTIONS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int runTool(CommandLine cli) throws Exception {
            String solrUrl = cli.getOptionValue("solrUrl", SolrCLI.DEFAULT_SOLR_URL);
            if (!solrUrl.endsWith("/")) {
                solrUrl = solrUrl + "/";
            }
            String systemInfoUrl = solrUrl + "admin/info/system";
            CloseableHttpClient httpClient = SolrCLI.getHttpClient();
            int result = -1;
            Tool tool = null;
            try {
                Map<String, Object> systemInfo = SolrCLI.getJson((HttpClient)httpClient, systemInfoUrl, 2);
                tool = "solrcloud".equals(systemInfo.get("mode")) ? new CreateCollectionTool() : new CreateCoreTool();
                result = tool.runTool(cli);
            }
            catch (Exception exc) {
                System.err.println("ERROR: create failed due to: " + exc.getMessage());
                System.err.println();
                result = 1;
            }
            finally {
                SolrCLI.closeHttpClient(httpClient);
            }
            return result;
        }
    }

    public static class CreateCoreTool
    implements Tool {
        @Override
        public String getName() {
            return "create_core";
        }

        @Override
        public Option[] getOptions() {
            Option[] optionArray = new Option[4];
            OptionBuilder.withArgName((String)"URL");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Base Solr URL, default is http://localhost:8983/solr");
            optionArray[0] = OptionBuilder.create((String)"solrUrl");
            OptionBuilder.withArgName((String)"NAME");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)true);
            OptionBuilder.withDescription((String)"Name of the core to create.");
            optionArray[1] = OptionBuilder.create((String)"name");
            OptionBuilder.withArgName((String)"CONFIG");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Configuration directory to copy when creating the new core; default is data_driven_schema_configs");
            optionArray[2] = OptionBuilder.create((String)"confdir");
            OptionBuilder.withArgName((String)"DIR");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)true);
            OptionBuilder.withDescription((String)"Path to configsets directory on the local system.");
            optionArray[3] = OptionBuilder.create((String)"configsetsDir");
            return optionArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int runTool(CommandLine cli) throws Exception {
            File configsetsDir;
            String solrUrl = cli.getOptionValue("solrUrl", SolrCLI.DEFAULT_SOLR_URL);
            if (!solrUrl.endsWith("/")) {
                solrUrl = solrUrl + "/";
            }
            if (!(configsetsDir = new File(cli.getOptionValue("configsetsDir"))).isDirectory()) {
                throw new FileNotFoundException(configsetsDir.getAbsolutePath() + " not found!");
            }
            String configSet = cli.getOptionValue("confdir", SolrCLI.DEFAULT_CONFIG_SET);
            File configSetDir = new File(configsetsDir, configSet);
            if (!configSetDir.isDirectory()) {
                File possibleConfigDir = new File(configSet);
                if (possibleConfigDir.isDirectory()) {
                    configSetDir = possibleConfigDir;
                } else {
                    throw new FileNotFoundException("Specified config directory " + configSet + " not found in " + configsetsDir.getAbsolutePath());
                }
            }
            String coreName = cli.getOptionValue("name");
            String systemInfoUrl = solrUrl + "admin/info/system";
            CloseableHttpClient httpClient = SolrCLI.getHttpClient();
            String solrHome = null;
            try {
                Map<String, Object> systemInfo = SolrCLI.getJson((HttpClient)httpClient, systemInfoUrl, 2);
                if ("solrcloud".equals(systemInfo.get("mode"))) {
                    System.err.println("\nERROR: Solr at " + solrUrl + " is running in SolrCloud mode, please use create_collection command instead.\n");
                    int n = 1;
                    return n;
                }
                solrHome = (String)systemInfo.get("solr_home");
                if (solrHome == null) {
                    solrHome = configsetsDir.getParentFile().getAbsolutePath();
                }
            }
            finally {
                SolrCLI.closeHttpClient(httpClient);
            }
            String coreStatusUrl = solrUrl + "admin/cores?action=STATUS&core=" + coreName;
            if (this.safeCheckCoreExists(coreStatusUrl, coreName)) {
                System.err.println("\nCore '" + coreName + "' already exists!");
                System.err.println("\nChecked core existence using Core API command:\n" + coreStatusUrl);
                System.err.println();
                return 1;
            }
            File coreInstanceDir = new File(solrHome, coreName);
            File confDir = new File(configSetDir, "conf");
            if (!coreInstanceDir.isDirectory()) {
                coreInstanceDir.mkdirs();
                if (!coreInstanceDir.isDirectory()) {
                    throw new IOException("Failed to create new core instance directory: " + coreInstanceDir.getAbsolutePath());
                }
                if (confDir.isDirectory()) {
                    FileUtils.copyDirectoryToDirectory((File)confDir, (File)coreInstanceDir);
                } else if (new File(configSetDir, "solrconfig.xml").isFile()) {
                    FileUtils.copyDirectory((File)configSetDir, (File)new File(coreInstanceDir, "conf"));
                } else {
                    System.err.println("\n" + configSetDir.getAbsolutePath() + " doesn't contain a conf subdirectory or solrconfig.xml\n");
                    return 1;
                }
                System.out.println("\nSetup new core instance directory:\n" + coreInstanceDir.getAbsolutePath());
            }
            String createCoreUrl = String.format(Locale.ROOT, "%sadmin/cores?action=CREATE&name=%s&instanceDir=%s", solrUrl, coreName, coreName);
            System.out.println("\nCreating new core '" + coreName + "' using command:\n" + createCoreUrl + "\n");
            Map<String, Object> json = null;
            try {
                json = SolrCLI.getJson(createCoreUrl);
            }
            catch (SolrServerException sse) {
                if (this.safeCheckCoreExists(coreStatusUrl, coreName)) {
                    System.err.println("Core '" + coreName + "' already exists!");
                    System.err.println("\nChecked core existence using Core API command:\n" + coreStatusUrl);
                } else {
                    System.err.println("Failed to create core '" + coreName + "' due to: " + sse.getMessage());
                }
                System.err.println();
                return 1;
            }
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(json);
            System.out.println(arr.toString());
            System.out.println();
            return 0;
        }

        protected boolean safeCheckCoreExists(String coreStatusUrl, String coreName) {
            boolean exists = false;
            try {
                Map<String, Object> existsCheckResult = SolrCLI.getJson(coreStatusUrl);
                Map status = (Map)existsCheckResult.get("status");
                Map coreStatus = (Map)status.get(coreName);
                exists = coreStatus != null && coreStatus.containsKey("name");
            }
            catch (Exception exc) {
                // empty catch block
            }
            return exists;
        }
    }

    public static class CreateCollectionTool
    implements Tool {
        @Override
        public String getName() {
            return "create_collection";
        }

        @Override
        public Option[] getOptions() {
            return CREATE_COLLECTION_OPTIONS;
        }

        @Override
        public int runTool(CommandLine cli) throws Exception {
            LogManager.getLogger((String)"org.apache.zookeeper").setLevel(Level.ERROR);
            LogManager.getLogger((String)"org.apache.solr.common.cloud").setLevel(Level.WARN);
            String zkHost = SolrCLI.getZkHost(cli);
            if (zkHost == null) {
                System.err.println("\nERROR: Solr at " + cli.getOptionValue("solrUrl") + " is running in standalone server mode, please use the create_core command instead;\n" + "create_collection can only be used when running in SolrCloud mode.\n");
                return 1;
            }
            int toolExitStatus = 0;
            try (CloudSolrClient cloudSolrServer = new CloudSolrClient(zkHost);){
                System.out.println("Connecting to ZooKeeper at " + zkHost);
                cloudSolrServer.connect();
                toolExitStatus = this.runCloudTool(cloudSolrServer, cli);
            }
            catch (Exception exc) {
                String excMsg = exc.getMessage();
                if (excMsg != null) {
                    System.err.println("\nERROR: " + excMsg + "\n");
                    toolExitStatus = 1;
                }
                throw exc;
            }
            return toolExitStatus;
        }

        protected int runCloudTool(CloudSolrClient cloudSolrClient, CommandLine cli) throws Exception {
            String baseUrl;
            String collectionListUrl;
            Set liveNodes = cloudSolrClient.getZkStateReader().getClusterState().getLiveNodes();
            if (liveNodes.isEmpty()) {
                throw new IllegalStateException("No live nodes found! Cannot create a collection until there is at least 1 live node in the cluster.");
            }
            String firstLiveNode = (String)liveNodes.iterator().next();
            String collectionName = cli.getOptionValue("name");
            int numShards = this.optionAsInt(cli, "shards", 1);
            int replicationFactor = this.optionAsInt(cli, "replicationFactor", 1);
            int maxShardsPerNode = -1;
            if (cli.hasOption("maxShardsPerNode")) {
                maxShardsPerNode = Integer.parseInt(cli.getOptionValue("maxShardsPerNode"));
            } else {
                int numNodes = liveNodes.size();
                maxShardsPerNode = (numShards * replicationFactor + numNodes - 1) / numNodes;
            }
            String confname = cli.getOptionValue("confname", collectionName);
            boolean configExistsInZk = cloudSolrClient.getZkStateReader().getZkClient().exists("/configs/" + confname, true);
            if (!".system".equals(collectionName)) {
                if (configExistsInZk) {
                    System.out.println("Re-using existing configuration directory " + confname);
                } else {
                    String configSet = cli.getOptionValue("confdir", SolrCLI.DEFAULT_CONFIG_SET);
                    File configSetDir = null;
                    File possibleConfigDir = new File(configSet);
                    if (possibleConfigDir.isDirectory()) {
                        configSetDir = possibleConfigDir;
                    } else {
                        File configsetsDir = new File(cli.getOptionValue("configsetsDir"));
                        if (!configsetsDir.isDirectory()) {
                            throw new FileNotFoundException(configsetsDir.getAbsolutePath() + " not found!");
                        }
                        configSetDir = new File(configsetsDir, configSet);
                        if (!configSetDir.isDirectory()) {
                            throw new FileNotFoundException("Specified config " + configSet + " not found in " + configsetsDir.getAbsolutePath());
                        }
                    }
                    File confDir = new File(configSetDir, "conf");
                    if (!confDir.isDirectory()) {
                        if (new File(configSetDir, "solrconfig.xml").isFile()) {
                            confDir = configSetDir;
                        } else {
                            System.err.println("Specified configuration directory " + configSetDir.getAbsolutePath() + " is invalid;\nit should contain either conf sub-directory or solrconfig.xml");
                            return 1;
                        }
                    }
                    System.out.println("Uploading " + confDir.getAbsolutePath() + " for config " + confname + " to ZooKeeper at " + cloudSolrClient.getZkHost());
                    cloudSolrClient.uploadConfig(confDir.toPath(), confname);
                }
            }
            if (SolrCLI.safeCheckCollectionExists(collectionListUrl = (baseUrl = cloudSolrClient.getZkStateReader().getBaseUrlForNodeName(firstLiveNode)) + "/admin/collections?action=list", collectionName)) {
                System.err.println("\nCollection '" + collectionName + "' already exists!");
                System.err.println("\nChecked collection existence using Collections API command:\n" + collectionListUrl);
                System.err.println();
                return 1;
            }
            String createCollectionUrl = String.format(Locale.ROOT, "%s/admin/collections?action=CREATE&name=%s&numShards=%d&replicationFactor=%d&maxShardsPerNode=%d&collection.configName=%s", baseUrl, collectionName, numShards, replicationFactor, maxShardsPerNode, confname);
            System.out.println("\nCreating new collection '" + collectionName + "' using command:\n" + createCollectionUrl + "\n");
            Map<String, Object> json = null;
            try {
                json = SolrCLI.getJson(createCollectionUrl);
            }
            catch (SolrServerException sse) {
                if (SolrCLI.safeCheckCollectionExists(collectionListUrl, collectionName)) {
                    System.err.println("Collection '" + collectionName + "' already exists!");
                    System.err.println("\nChecked collection existence using Collections API command:\n" + collectionListUrl);
                } else {
                    System.err.println("Failed to create collection '" + collectionName + "' due to: " + sse.getMessage());
                }
                System.err.println();
                return 1;
            }
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(json);
            System.out.println(arr.toString());
            System.out.println();
            return 0;
        }

        protected int optionAsInt(CommandLine cli, String option, int defaultVal) {
            return Integer.parseInt(cli.getOptionValue(option, String.valueOf(defaultVal)));
        }
    }

    public static class HealthcheckTool
    extends SolrCloudTool {
        @Override
        public String getName() {
            return "healthcheck";
        }

        @Override
        protected int runCloudTool(CloudSolrClient cloudSolrClient, CommandLine cli) throws Exception {
            String collection = cli.getOptionValue("collection");
            if (collection == null) {
                throw new IllegalArgumentException("Must provide a collection to run a healthcheck against!");
            }
            log.debug((Object)("Running healthcheck for " + collection));
            ZkStateReader zkStateReader = cloudSolrClient.getZkStateReader();
            ClusterState clusterState = zkStateReader.getClusterState();
            Set liveNodes = clusterState.getLiveNodes();
            Collection slices = clusterState.getSlices(collection);
            if (slices == null) {
                throw new IllegalArgumentException("Collection " + collection + " not found!");
            }
            SolrQuery q = new SolrQuery("*:*");
            q.setRows(Integer.valueOf(0));
            QueryResponse qr = cloudSolrClient.query((SolrParams)q);
            String collErr = null;
            long docCount = -1L;
            try {
                docCount = qr.getResults().getNumFound();
            }
            catch (Exception exc) {
                collErr = String.valueOf(exc);
            }
            ArrayList<Map<String, Object>> shardList = new ArrayList<Map<String, Object>>();
            boolean collectionIsHealthy = docCount != -1L;
            for (Slice slice : slices) {
                String shardName = slice.getName();
                String leaderUrl = null;
                try {
                    leaderUrl = zkStateReader.getLeaderUrl(collection, shardName, 1000);
                }
                catch (Exception exc) {
                    log.warn((Object)("Failed to get leader for shard " + shardName + " due to: " + exc));
                }
                ArrayList<ReplicaHealth> replicaList = new ArrayList<ReplicaHealth>();
                for (Replica r : slice.getReplicas()) {
                    String uptime = null;
                    String memory = null;
                    String replicaStatus = null;
                    long numDocs = -1L;
                    ZkCoreNodeProps replicaCoreProps = new ZkCoreNodeProps((ZkNodeProps)r);
                    String coreUrl = replicaCoreProps.getCoreUrl();
                    boolean isLeader = coreUrl.equals(leaderUrl);
                    String nodeName = replicaCoreProps.getNodeName();
                    if (nodeName == null || !liveNodes.contains(nodeName)) {
                        replicaStatus = Replica.State.DOWN.toString();
                    } else {
                        q = new SolrQuery("*:*");
                        q.setRows(Integer.valueOf(0));
                        q.set("distrib", new String[]{"false"});
                        try (HttpSolrClient solr = new HttpSolrClient(coreUrl);){
                            String solrUrl = solr.getBaseURL();
                            qr = solr.query((SolrParams)q);
                            numDocs = qr.getResults().getNumFound();
                            int lastSlash = solrUrl.lastIndexOf(47);
                            String systemInfoUrl = solrUrl.substring(0, lastSlash) + "/admin/info/system";
                            Map<String, Object> info = SolrCLI.getJson(solr.getHttpClient(), systemInfoUrl, 2);
                            uptime = SolrCLI.uptime(SolrCLI.asLong("/jvm/jmx/upTimeMS", info));
                            String usedMemory = SolrCLI.asString("/jvm/memory/used", info);
                            String totalMemory = SolrCLI.asString("/jvm/memory/total", info);
                            memory = usedMemory + " of " + totalMemory;
                            replicaStatus = replicaCoreProps.getState();
                        }
                        catch (Exception exc) {
                            log.error((Object)("ERROR: " + exc + " when trying to reach: " + coreUrl));
                            replicaStatus = SolrCLI.checkCommunicationError(exc) ? Replica.State.DOWN.toString() : "error: " + exc;
                        }
                    }
                    replicaList.add(new ReplicaHealth(shardName, r.getName(), coreUrl, replicaStatus, numDocs, isLeader, uptime, memory));
                }
                ShardHealth shardHealth = new ShardHealth(shardName, replicaList);
                if (ShardState.healthy != shardHealth.getShardState()) {
                    collectionIsHealthy = false;
                }
                shardList.add(shardHealth.asMap());
            }
            LinkedHashMap<String, Object> report = new LinkedHashMap<String, Object>();
            report.put("collection", collection);
            report.put("status", collectionIsHealthy ? "healthy" : "degraded");
            if (collErr != null) {
                report.put("error", collErr);
            }
            report.put("numDocs", docCount);
            report.put("numShards", slices.size());
            report.put("shards", shardList);
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(report);
            System.out.println(arr.toString());
            return 0;
        }
    }

    static class ShardHealth {
        String shard;
        List<ReplicaHealth> replicas;

        ShardHealth(String shard, List<ReplicaHealth> replicas) {
            this.shard = shard;
            this.replicas = replicas;
        }

        public ShardState getShardState() {
            boolean healthy = true;
            boolean hasLeader = false;
            boolean atLeastOneActive = false;
            for (ReplicaHealth replicaHealth : this.replicas) {
                if (replicaHealth.isLeader) {
                    hasLeader = true;
                }
                if (!Replica.State.ACTIVE.toString().equals(replicaHealth.status)) {
                    healthy = false;
                    continue;
                }
                atLeastOneActive = true;
            }
            if (!hasLeader) {
                return ShardState.no_leader;
            }
            return healthy ? ShardState.healthy : (atLeastOneActive ? ShardState.degraded : ShardState.down);
        }

        public Map<String, Object> asMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("shard", this.shard);
            map.put("status", this.getShardState().toString());
            ArrayList<Map<String, Object>> replicaList = new ArrayList<Map<String, Object>>();
            for (ReplicaHealth replica : this.replicas) {
                replicaList.add(replica.asMap());
            }
            map.put("replicas", replicaList);
            return map;
        }

        public String toString() {
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(this.asMap());
            return arr.toString();
        }
    }

    static enum ShardState {
        healthy,
        degraded,
        down,
        no_leader;

    }

    static class ReplicaHealth
    implements Comparable<ReplicaHealth> {
        String shard;
        String name;
        String url;
        String status;
        long numDocs;
        boolean isLeader;
        String uptime;
        String memory;

        ReplicaHealth(String shard, String name, String url, String status, long numDocs, boolean isLeader, String uptime, String memory) {
            this.shard = shard;
            this.name = name;
            this.url = url;
            this.numDocs = numDocs;
            this.status = status;
            this.isLeader = isLeader;
            this.uptime = uptime;
            this.memory = memory;
        }

        public Map<String, Object> asMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", this.name);
            map.put("url", this.url);
            map.put("numDocs", this.numDocs);
            map.put("status", this.status);
            if (this.uptime != null) {
                map.put("uptime", this.uptime);
            }
            if (this.memory != null) {
                map.put("memory", this.memory);
            }
            if (this.isLeader) {
                map.put("leader", true);
            }
            return map;
        }

        public String toString() {
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(this.asMap());
            return arr.toString();
        }

        public int hashCode() {
            return this.shard.hashCode() + (this.isLeader ? 1 : 0);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ReplicaHealth)) {
                return true;
            }
            ReplicaHealth that = (ReplicaHealth)obj;
            return this.shard.equals(that.shard) && this.isLeader == that.isLeader;
        }

        @Override
        public int compareTo(ReplicaHealth other) {
            int otherShardIndex;
            if (this == other) {
                return 0;
            }
            if (other == null) {
                return 1;
            }
            int myShardIndex = Integer.parseInt(this.shard.substring("shard".length()));
            if (myShardIndex == (otherShardIndex = Integer.parseInt(other.shard.substring("shard".length())))) {
                return this.isLeader ? -1 : 1;
            }
            return myShardIndex - otherShardIndex;
        }
    }

    public static class ApiTool
    implements Tool {
        @Override
        public String getName() {
            return "api";
        }

        @Override
        public Option[] getOptions() {
            Option[] optionArray = new Option[1];
            OptionBuilder.withArgName((String)"URL");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Send a GET request to a Solr API endpoint");
            optionArray[0] = OptionBuilder.create((String)"get");
            return optionArray;
        }

        @Override
        public int runTool(CommandLine cli) throws Exception {
            String getUrl = cli.getOptionValue("get");
            if (getUrl != null) {
                Map<String, Object> json = SolrCLI.getJson(getUrl);
                CharArr arr = new CharArr();
                new JSONWriter(arr, 2).write(json);
                System.out.println(arr.toString());
            }
            return 0;
        }
    }

    public static class StatusTool
    implements Tool {
        @Override
        public String getName() {
            return "status";
        }

        @Override
        public Option[] getOptions() {
            Option[] optionArray = new Option[1];
            OptionBuilder.withArgName((String)"URL");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Address of the Solr Web application, defaults to: http://localhost:8983/solr");
            optionArray[0] = OptionBuilder.create((String)"solr");
            return optionArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int runTool(CommandLine cli) throws Exception {
            String solrUrl = cli.getOptionValue("solr", SolrCLI.DEFAULT_SOLR_URL);
            if (!solrUrl.endsWith("/")) {
                solrUrl = solrUrl + "/";
            }
            int exitCode = 0;
            String systemInfoUrl = solrUrl + "admin/info/system";
            CloseableHttpClient httpClient = SolrCLI.getHttpClient();
            try {
                Map<String, Object> systemInfo = SolrCLI.getJson((HttpClient)httpClient, systemInfoUrl, 2);
                Map<String, Object> status = this.reportStatus(solrUrl, systemInfo, (HttpClient)httpClient);
                CharArr arr = new CharArr();
                new JSONWriter(arr, 2).write(status);
                System.out.println(arr.toString());
            }
            catch (Exception exc) {
                if (SolrCLI.checkCommunicationError(exc)) {
                    System.err.println("Solr at " + solrUrl + " not online.");
                } else {
                    System.err.print("Failed to get system information from " + solrUrl + " due to: ");
                    exc.printStackTrace(System.err);
                    exitCode = 1;
                }
            }
            finally {
                SolrCLI.closeHttpClient(httpClient);
            }
            return exitCode;
        }

        public Map<String, Object> reportStatus(String solrUrl, Map<String, Object> info, HttpClient httpClient) throws Exception {
            LinkedHashMap<String, Object> status = new LinkedHashMap<String, Object>();
            String solrHome = (String)info.get("solr_home");
            status.put("solr_home", solrHome != null ? solrHome : "?");
            status.put("version", SolrCLI.asString("/lucene/solr-impl-version", info));
            status.put("startTime", SolrCLI.asString("/jvm/jmx/startTime", info));
            status.put("uptime", SolrCLI.uptime(SolrCLI.asLong("/jvm/jmx/upTimeMS", info)));
            String usedMemory = SolrCLI.asString("/jvm/memory/used", info);
            String totalMemory = SolrCLI.asString("/jvm/memory/total", info);
            status.put("memory", usedMemory + " of " + totalMemory);
            if ("solrcloud".equals(info.get("mode"))) {
                String zkHost = (String)info.get("zkHost");
                status.put("cloud", this.getCloudStatus(httpClient, solrUrl, zkHost));
            }
            return status;
        }

        protected Map<String, String> getCloudStatus(HttpClient httpClient, String solrUrl, String zkHost) throws Exception {
            LinkedHashMap<String, String> cloudStatus = new LinkedHashMap<String, String>();
            cloudStatus.put("ZooKeeper", zkHost != null ? zkHost : "?");
            String clusterStatusUrl = solrUrl + "admin/collections?action=CLUSTERSTATUS";
            Map<String, Object> json = SolrCLI.getJson(httpClient, clusterStatusUrl, 2);
            List<String> liveNodes = SolrCLI.asList("/cluster/live_nodes", json);
            cloudStatus.put("liveNodes", String.valueOf(liveNodes.size()));
            Map<String, Object> collections = SolrCLI.asMap("/cluster/collections", json);
            cloudStatus.put("collections", String.valueOf(collections.size()));
            return cloudStatus;
        }
    }

    private static class SolrResponseHandler
    implements ResponseHandler<Map<String, Object>> {
        private SolrResponseHandler() {
        }

        public Map<String, Object> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                String respBody = EntityUtils.toString((HttpEntity)entity);
                Object resp = null;
                try {
                    resp = ObjectBuilder.getVal((JSONParser)new JSONParser(respBody));
                }
                catch (JSONParser.ParseException pe) {
                    throw new ClientProtocolException("Expected JSON response from server but received: " + respBody + "\nTypically, this indicates a problem with the Solr server; check the Solr server logs for more information.");
                }
                if (resp != null && resp instanceof Map) {
                    return (Map)resp;
                }
                throw new ClientProtocolException("Expected JSON object in response but received " + resp);
            }
            StatusLine statusLine = response.getStatusLine();
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
    }

    public static abstract class SolrCloudTool
    implements Tool {
        @Override
        public Option[] getOptions() {
            return cloudOptions;
        }

        @Override
        public int runTool(CommandLine cli) throws Exception {
            LogManager.getLogger((String)"org.apache.zookeeper").setLevel(Level.ERROR);
            LogManager.getLogger((String)"org.apache.solr.common.cloud").setLevel(Level.WARN);
            String zkHost = cli.getOptionValue("zkHost", SolrCLI.ZK_HOST);
            log.debug((Object)("Connecting to Solr cluster: " + zkHost));
            int exitStatus = 0;
            try (CloudSolrClient cloudSolrClient = new CloudSolrClient(zkHost);){
                String collection = cli.getOptionValue("collection");
                if (collection != null) {
                    cloudSolrClient.setDefaultCollection(collection);
                }
                cloudSolrClient.connect();
                exitStatus = this.runCloudTool(cloudSolrClient, cli);
            }
            catch (Exception exc) {
                String excMsg = exc.getMessage();
                if (excMsg != null) {
                    System.err.println("\nERROR: " + excMsg + "\n");
                    exitStatus = 1;
                }
                throw exc;
            }
            return exitStatus;
        }

        protected abstract int runCloudTool(CloudSolrClient var1, CommandLine var2) throws Exception;
    }

    public static interface Tool {
        public String getName();

        public Option[] getOptions();

        public int runTool(CommandLine var1) throws Exception;
    }
}

