/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessorFactory;
import org.apache.solr.update.processor.FieldValueMutatingUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;

public final class HTMLStripFieldUpdateProcessorFactory
extends FieldMutatingUpdateProcessorFactory {
    @Override
    public FieldMutatingUpdateProcessor.FieldNameSelector getDefaultSelector(SolrCore core) {
        return FieldMutatingUpdateProcessor.SELECT_NO_FIELDS;
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new FieldValueMutatingUpdateProcessor(this.getSelector(), next){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Object mutateValue(Object src) {
                if (src instanceof CharSequence) {
                    CharSequence s = (CharSequence)src;
                    StringWriter result = new StringWriter(s.length());
                    HTMLStripCharFilter in = null;
                    try {
                        in = new HTMLStripCharFilter((Reader)new StringReader(s.toString()));
                        IOUtils.copy((Reader)in, (Writer)result);
                        String string = result.toString();
                        IOUtils.closeQuietly((Reader)in);
                        return string;
                    }
                    catch (IOException e) {
                        CharSequence charSequence = s;
                        return charSequence;
                    }
                    finally {
                        IOUtils.closeQuietly(in);
                    }
                }
                return src;
            }
        };
    }
}

