/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.LoggingHandler;
import org.apache.solr.handler.admin.PropertiesRequestHandler;
import org.apache.solr.handler.admin.SystemInfoHandler;
import org.apache.solr.handler.admin.ThreadDumpHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoHandler
extends RequestHandlerBase {
    protected static Logger log = LoggerFactory.getLogger(InfoHandler.class);
    protected final CoreContainer coreContainer;
    private ThreadDumpHandler threadDumpHandler = new ThreadDumpHandler();
    private PropertiesRequestHandler propertiesHandler = new PropertiesRequestHandler();
    private LoggingHandler loggingHandler;
    private SystemInfoHandler systemInfoHandler;

    public InfoHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        this.systemInfoHandler = new SystemInfoHandler(coreContainer);
        this.loggingHandler = new LoggingHandler(coreContainer);
    }

    @Override
    public final void init(NamedList args) {
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        int i;
        CoreContainer cores = this.getCoreContainer();
        if (cores == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        String path = (String)req.getContext().get("path");
        String name = path.substring((i = path.lastIndexOf(47)) + 1, path.length());
        if (name.equalsIgnoreCase("properties")) {
            this.propertiesHandler.handleRequest(req, rsp);
        } else if (name.equalsIgnoreCase("threads")) {
            this.threadDumpHandler.handleRequest(req, rsp);
        } else if (name.equalsIgnoreCase("logging")) {
            this.loggingHandler.handleRequest(req, rsp);
        } else if (name.equalsIgnoreCase("system")) {
            this.systemInfoHandler.handleRequest(req, rsp);
        } else {
            if (name.equalsIgnoreCase("info")) {
                name = "";
            }
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Info Handler not found: " + name);
        }
        rsp.setHttpCaching(false);
    }

    @Override
    public String getDescription() {
        return "System Information";
    }

    protected PropertiesRequestHandler getPropertiesHandler() {
        return this.propertiesHandler;
    }

    protected ThreadDumpHandler getThreadDumpHandler() {
        return this.threadDumpHandler;
    }

    protected LoggingHandler getLoggingHandler() {
        return this.loggingHandler;
    }

    protected SystemInfoHandler getSystemInfoHandler() {
        return this.systemInfoHandler;
    }

    protected void setPropertiesHandler(PropertiesRequestHandler propertiesHandler) {
        this.propertiesHandler = propertiesHandler;
    }

    protected void setThreadDumpHandler(ThreadDumpHandler threadDumpHandler) {
        this.threadDumpHandler = threadDumpHandler;
    }

    protected void setLoggingHandler(LoggingHandler loggingHandler) {
        this.loggingHandler = loggingHandler;
    }

    protected void setSystemInfoHandler(SystemInfoHandler systemInfoHandler) {
        this.systemInfoHandler = systemInfoHandler;
    }

    @Override
    public SolrRequestHandler getSubHandler(String subPath) {
        return this;
    }
}

