/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.google.common.base.Strings;
import java.util.Properties;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.util.PropertiesUtil;

public class CloudDescriptor {
    private final CoreDescriptor cd;
    private String shardId;
    private String collectionName;
    private SolrParams params;
    private String roles = null;
    private Integer numShards;
    private String nodeName = null;
    volatile String shardRange = null;
    volatile Slice.State shardState = Slice.State.ACTIVE;
    volatile String shardParent = null;
    volatile boolean isLeader = false;
    volatile Replica.State lastPublished = Replica.State.ACTIVE;
    public static final String NUM_SHARDS = "numShards";

    public CloudDescriptor(String coreName, Properties props, CoreDescriptor cd) {
        this.cd = cd;
        this.shardId = props.getProperty("shard", null);
        if (Strings.isNullOrEmpty((String)this.shardId)) {
            this.shardId = null;
        }
        this.collectionName = props.getProperty("collection", coreName);
        this.roles = props.getProperty("roles", null);
        this.nodeName = props.getProperty("coreNodeName");
        if (Strings.isNullOrEmpty((String)this.nodeName)) {
            this.nodeName = null;
        }
        this.numShards = PropertiesUtil.toInteger(props.getProperty(NUM_SHARDS), null);
    }

    public Replica.State getLastPublished() {
        return this.lastPublished;
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public void setLeader(boolean isLeader) {
        this.isLeader = isLeader;
    }

    public void setShardId(String shardId) {
        this.shardId = shardId;
    }

    public String getShardId() {
        return this.shardId;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getRoles() {
        return this.roles;
    }

    public void setRoles(String roles) {
        this.roles = roles;
    }

    public SolrParams getParams() {
        return this.params;
    }

    public void setParams(SolrParams params) {
        this.params = params;
    }

    public Integer getNumShards() {
        return this.numShards;
    }

    public void setNumShards(int numShards) {
        this.numShards = numShards;
    }

    public String getCoreNodeName() {
        return this.nodeName;
    }

    public void setCoreNodeName(String nodeName) {
        this.nodeName = nodeName;
        if (nodeName == null) {
            this.cd.getPersistableStandardProperties().remove("coreNodeName");
        } else {
            this.cd.getPersistableStandardProperties().setProperty("coreNodeName", nodeName);
        }
    }
}

