/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.mlt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrIndexSearcher;

public class SimpleMLTQParser
extends QParser {
    public SimpleMLTQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() {
        String defaultField = this.req.getSchema().getUniqueKeyField().getName();
        String uniqueValue = this.localParams.get("v");
        String[] qf = this.localParams.getParams("qf");
        SolrIndexSearcher searcher = this.req.getSearcher();
        Query docIdQuery = this.createIdQuery(defaultField, uniqueValue);
        try {
            TopDocs td = searcher.search(docIdQuery, 1);
            if (td.totalHits != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error completing MLT request. Could not fetch document with id [" + uniqueValue + "]");
            }
            ScoreDoc[] scoreDocs = td.scoreDocs;
            MoreLikeThis mlt = new MoreLikeThis((IndexReader)this.req.getSearcher().getIndexReader());
            mlt.setMinTermFreq(this.localParams.getInt("mintf", 1));
            mlt.setMinDocFreq(this.localParams.getInt("mindf", 1));
            if (this.localParams.get("minwl") != null) {
                mlt.setMinWordLen(this.localParams.getInt("minwl").intValue());
            }
            if (this.localParams.get("maxwl") != null) {
                mlt.setMaxWordLen(this.localParams.getInt("maxwl").intValue());
            }
            ArrayList<String> fields = new ArrayList<String>();
            if (qf != null) {
                mlt.setFieldNames(qf);
            } else {
                Map<String, SchemaField> fieldNames = this.req.getSearcher().getSchema().getFields();
                for (String fieldName : fieldNames.keySet()) {
                    if (!fieldNames.get(fieldName).indexed() || !fieldNames.get(fieldName).stored() || fieldNames.get(fieldName).getType().getNumericType() != null) continue;
                    fields.add(fieldName);
                }
                mlt.setFieldNames(fields.toArray(new String[fields.size()]));
            }
            mlt.setAnalyzer(this.req.getSchema().getIndexAnalyzer());
            return mlt.like(scoreDocs[0].doc);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error completing MLT request" + e.getMessage());
        }
    }

    private Query createIdQuery(String defaultField, String uniqueValue) {
        return new TermQuery(this.req.getSchema().getField(defaultField).getType().getNumericType() != null ? this.createNumericTerm(defaultField, uniqueValue) : new Term(defaultField, uniqueValue));
    }

    private Term createNumericTerm(String field, String uniqueValue) {
        BytesRefBuilder bytesRefBuilder = new BytesRefBuilder();
        bytesRefBuilder.grow(6);
        NumericUtils.intToPrefixCoded((int)Integer.parseInt(uniqueValue), (int)0, (BytesRefBuilder)bytesRefBuilder);
        return new Term(field, bytesRefBuilder.toBytesRef());
    }
}

