/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.AbstractSecondPassGroupingCollector;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.search.grouping.function.FunctionSecondPassGroupingCollector;
import org.apache.lucene.search.grouping.term.TermSecondPassGroupingCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.grouping.Command;
import org.apache.solr.search.grouping.distributed.command.GroupConverter;

public class TopGroupsFieldCommand
implements Command<TopGroups<BytesRef>> {
    private final SchemaField field;
    private final Sort groupSort;
    private final Sort sortWithinGroup;
    private final Collection<SearchGroup<BytesRef>> firstPhaseGroups;
    private final int maxDocPerGroup;
    private final boolean needScores;
    private final boolean needMaxScore;
    private AbstractSecondPassGroupingCollector secondPassCollector;

    private TopGroupsFieldCommand(SchemaField field, Sort groupSort, Sort sortWithinGroup, Collection<SearchGroup<BytesRef>> firstPhaseGroups, int maxDocPerGroup, boolean needScores, boolean needMaxScore) {
        this.field = field;
        this.groupSort = groupSort;
        this.sortWithinGroup = sortWithinGroup;
        this.firstPhaseGroups = firstPhaseGroups;
        this.maxDocPerGroup = maxDocPerGroup;
        this.needScores = needScores;
        this.needMaxScore = needMaxScore;
    }

    @Override
    public List<Collector> create() throws IOException {
        if (this.firstPhaseGroups.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Collector> collectors = new ArrayList<Collector>();
        FieldType fieldType = this.field.getType();
        if (fieldType.getNumericType() != null) {
            ValueSource vs = fieldType.getValueSource(this.field, null);
            Collection<SearchGroup<MutableValue>> v = GroupConverter.toMutable(this.field, this.firstPhaseGroups);
            this.secondPassCollector = new FunctionSecondPassGroupingCollector(v, this.groupSort, this.sortWithinGroup, this.maxDocPerGroup, this.needScores, this.needMaxScore, true, vs, new HashMap());
        } else {
            this.secondPassCollector = new TermSecondPassGroupingCollector(this.field.getName(), this.firstPhaseGroups, this.groupSort, this.sortWithinGroup, this.maxDocPerGroup, this.needScores, this.needMaxScore, true);
        }
        collectors.add((Collector)this.secondPassCollector);
        return collectors;
    }

    @Override
    public TopGroups<BytesRef> result() {
        if (this.firstPhaseGroups.isEmpty()) {
            return new TopGroups(this.groupSort.getSort(), this.sortWithinGroup.getSort(), 0, 0, new GroupDocs[0], Float.NaN);
        }
        FieldType fieldType = this.field.getType();
        if (fieldType.getNumericType() != null) {
            return GroupConverter.fromMutable(this.field, (TopGroups<MutableValue>)this.secondPassCollector.getTopGroups(0));
        }
        return this.secondPassCollector.getTopGroups(0);
    }

    @Override
    public String getKey() {
        return this.field.getName();
    }

    @Override
    public Sort getGroupSort() {
        return this.groupSort;
    }

    @Override
    public Sort getSortWithinGroup() {
        return this.sortWithinGroup;
    }

    public static class Builder {
        private SchemaField field;
        private Sort groupSort;
        private Sort sortWithinGroup;
        private Collection<SearchGroup<BytesRef>> firstPhaseGroups;
        private Integer maxDocPerGroup;
        private boolean needScores = false;
        private boolean needMaxScore = false;

        public Builder setField(SchemaField field) {
            this.field = field;
            return this;
        }

        public Builder setGroupSort(Sort groupSort) {
            this.groupSort = groupSort;
            return this;
        }

        public Builder setSortWithinGroup(Sort sortWithinGroup) {
            this.sortWithinGroup = sortWithinGroup;
            return this;
        }

        public Builder setFirstPhaseGroups(Collection<SearchGroup<BytesRef>> firstPhaseGroups) {
            this.firstPhaseGroups = firstPhaseGroups;
            return this;
        }

        public Builder setMaxDocPerGroup(int maxDocPerGroup) {
            this.maxDocPerGroup = maxDocPerGroup;
            return this;
        }

        public Builder setNeedScores(Boolean needScores) {
            this.needScores = needScores;
            return this;
        }

        public Builder setNeedMaxScore(Boolean needMaxScore) {
            this.needMaxScore = needMaxScore;
            return this;
        }

        public TopGroupsFieldCommand build() {
            if (this.field == null || this.groupSort == null || this.sortWithinGroup == null || this.firstPhaseGroups == null || this.maxDocPerGroup == null) {
                throw new IllegalStateException("All required fields must be set");
            }
            return new TopGroupsFieldCommand(this.field, this.groupSort, this.sortWithinGroup, this.firstPhaseGroups, this.maxDocPerGroup, this.needScores, this.needMaxScore);
        }
    }
}

