/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.BitSet;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.PivotFacetField;
import org.apache.solr.handler.component.PivotFacetHelper;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.StatsComponent;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.util.PivotListEntry;

public class PivotFacetValue {
    private final BitSet sourceShards = new BitSet();
    private final PivotFacetField parentPivot;
    private final Comparable value;
    private PivotFacetField childPivot = null;
    private int count;
    private Map<String, StatsValues> statsValues = null;

    private PivotFacetValue(PivotFacetField parent, Comparable val) {
        this.parentPivot = parent;
        this.value = val;
    }

    public Comparable getValue() {
        return this.value;
    }

    public int getCount() {
        return this.count;
    }

    public PivotFacetField getChildPivot() {
        return this.childPivot;
    }

    public List<String> getValuePath() {
        List<String> out = this.parentPivot.getValuePath();
        if (null == this.value) {
            out.add(null);
        } else if (this.value instanceof Date) {
            out.add(TrieDateField.formatExternal((Date)this.value));
        } else {
            out.add(this.value.toString());
        }
        return out;
    }

    public static PivotFacetValue createFromNamedList(int shardNumber, ResponseBuilder rb, PivotFacetField parentField, NamedList<Object> pivotData) {
        Comparable pivotVal = null;
        int pivotCount = 0;
        List childPivotData = null;
        NamedList statsValues = null;
        block7: for (int i = 0; i < pivotData.size(); ++i) {
            String key = pivotData.getName(i);
            Object value = pivotData.getVal(i);
            PivotListEntry entry = PivotListEntry.get(key);
            switch (entry) {
                case VALUE: {
                    pivotVal = (Comparable)value;
                    continue block7;
                }
                case FIELD: {
                    assert (parentField.field.equals(value)) : "Parent Field mismatch: " + parentField.field + "!=" + value;
                    continue block7;
                }
                case COUNT: {
                    pivotCount = (Integer)value;
                    continue block7;
                }
                case PIVOT: {
                    childPivotData = (List)value;
                    continue block7;
                }
                case STATS: {
                    statsValues = (NamedList)value;
                    continue block7;
                }
                default: {
                    throw new RuntimeException("PivotListEntry contains unaccounted for item: " + (Object)((Object)entry));
                }
            }
        }
        PivotFacetValue newPivotFacet = new PivotFacetValue(parentField, pivotVal);
        newPivotFacet.count = pivotCount;
        newPivotFacet.sourceShards.set(shardNumber);
        if (statsValues != null) {
            newPivotFacet.statsValues = PivotFacetHelper.mergeStats(null, statsValues, rb._statsInfo);
        }
        newPivotFacet.childPivot = PivotFacetField.createFromListOfNamedLists(shardNumber, rb, newPivotFacet, childPivotData);
        return newPivotFacet;
    }

    public boolean shardHasContributed(int shardNum) {
        return this.sourceShards.get(shardNum);
    }

    public NamedList<Object> convertToNamedList() {
        SimpleOrderedMap newList = new SimpleOrderedMap();
        newList.add(PivotListEntry.FIELD.getName(), (Object)this.parentPivot.field);
        newList.add(PivotListEntry.VALUE.getName(), (Object)this.value);
        newList.add(PivotListEntry.COUNT.getName(), (Object)this.count);
        if (this.childPivot != null && this.childPivot.convertToListOfNamedLists() != null) {
            newList.add(PivotListEntry.PIVOT.getName(), this.childPivot.convertToListOfNamedLists());
        }
        if (null != this.statsValues) {
            newList.add(PivotListEntry.STATS.getName(), StatsComponent.convertToResponse(this.statsValues));
        }
        return newList;
    }

    public void mergeContributionFromShard(int shardNumber, ResponseBuilder rb, NamedList<Object> value) {
        assert (null != value) : "can't merge in null data";
        if (!this.shardHasContributed(shardNumber)) {
            this.sourceShards.set(shardNumber);
            this.count += PivotFacetHelper.getCount(value).intValue();
            NamedList<NamedList<NamedList<?>>> stats = PivotFacetHelper.getStats(value);
            if (stats != null) {
                this.statsValues = PivotFacetHelper.mergeStats(this.statsValues, stats, rb._statsInfo);
            }
        }
        List<NamedList<Object>> shardChildPivots = PivotFacetHelper.getPivots(value);
        if (null == this.childPivot) {
            this.childPivot = PivotFacetField.createFromListOfNamedLists(shardNumber, rb, this, shardChildPivots);
        } else {
            this.childPivot.contributeFromShard(shardNumber, rb, shardChildPivots);
        }
    }

    public String toString() {
        return String.format(Locale.ROOT, "F:%s V:%s Co:%d Ch?:%s", this.parentPivot.field, this.value, this.count, this.childPivot != null);
    }
}

