/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.solr.search.ExtendedQuery;
import org.apache.solr.search.ExtendedQueryBase;
import org.apache.solr.search.SolrFilter;

public class SolrConstantScoreQuery
extends ConstantScoreQuery
implements ExtendedQuery {
    private final Filter filter;
    boolean cache = true;
    int cost;

    public SolrConstantScoreQuery(Filter filter) {
        super((Query)filter);
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setCache(boolean cache) {
        this.cache = cache;
    }

    @Override
    public boolean getCache() {
        return this.cache;
    }

    @Override
    public void setCacheSep(boolean cacheSep) {
    }

    @Override
    public boolean getCacheSep() {
        return false;
    }

    @Override
    public void setCost(int cost) {
        this.cost = cost;
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantWeight(searcher);
    }

    public String toString(String field) {
        return ExtendedQueryBase.getOptionsString(this) + "ConstantScore(" + this.filter.toString() + ((double)this.getBoost() == 1.0 ? ")" : "^" + this.getBoost());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        SolrConstantScoreQuery other = (SolrConstantScoreQuery)o;
        return this.filter.equals((Object)other.filter);
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.filter.hashCode();
    }

    protected class ConstantWeight
    extends ConstantScoreWeight {
        private Map context;

        public ConstantWeight(IndexSearcher searcher) throws IOException {
            super((Query)SolrConstantScoreQuery.this);
            this.context = ValueSource.newContext((IndexSearcher)searcher);
            if (SolrConstantScoreQuery.this.filter instanceof SolrFilter) {
                ((SolrFilter)SolrConstantScoreQuery.this.filter).createWeight(this.context, searcher);
            }
        }

        public Scorer scorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
            DocIdSet docIdSet;
            DocIdSet docIdSet2 = docIdSet = SolrConstantScoreQuery.this.filter instanceof SolrFilter ? ((SolrFilter)SolrConstantScoreQuery.this.filter).getDocIdSet(this.context, context, acceptDocs) : SolrConstantScoreQuery.this.filter.getDocIdSet(context, acceptDocs);
            if (docIdSet == null) {
                return null;
            }
            DocIdSetIterator iterator = docIdSet.iterator();
            if (iterator == null) {
                return null;
            }
            return new ConstantScoreScorer((Weight)this, this.score(), iterator);
        }
    }
}

