/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.util.CommandOperation;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class SchemaManager {
    private static final Logger log = LoggerFactory.getLogger(SchemaManager.class);
    final SolrQueryRequest req;
    ManagedIndexSchema managedIndexSchema;

    public SchemaManager(SolrQueryRequest req) {
        this.req = req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List performOperations(Reader reader) throws Exception {
        List<CommandOperation> ops;
        try {
            ops = CommandOperation.parse(reader);
        }
        catch (Exception e) {
            String msg = "Error parsing schema operations ";
            log.warn(msg, (Throwable)e);
            return Collections.singletonList(Collections.singletonMap("errorMessages", msg + ":" + e.getMessage()));
        }
        List<Map> errs = CommandOperation.captureErrors(ops);
        if (!errs.isEmpty()) {
            return errs;
        }
        IndexSchema schema = this.req.getCore().getLatestSchema();
        if (!(schema instanceof ManagedIndexSchema)) {
            return Collections.singletonList(Collections.singletonMap("errorMessages", "schema is not editable"));
        }
        Object object = schema.getSchemaUpdateLock();
        synchronized (object) {
            return this.doOperations(ops);
        }
    }

    private List doOperations(List<CommandOperation> operations) throws InterruptedException, IOException, KeeperException {
        int timeout = this.req.getParams().getInt("updateTimeoutSecs", -1);
        long startTime = System.nanoTime();
        long endTime = timeout > 0 ? System.nanoTime() + (long)(timeout * 1000 * 1000) : Long.MAX_VALUE;
        SolrCore core = this.req.getCore();
        while (System.nanoTime() < endTime) {
            String s;
            this.managedIndexSchema = this.getFreshManagedSchema();
            for (CommandOperation op : operations) {
                OpType opType = OpType.get(op.name);
                if (opType != null) {
                    opType.perform(op, this);
                    continue;
                }
                op.addError("No such operation : " + op.name);
            }
            List<Map> errs = CommandOperation.captureErrors(operations);
            if (!errs.isEmpty()) {
                return errs;
            }
            SolrResourceLoader loader = this.req.getCore().getResourceLoader();
            if (loader instanceof ZkSolrResourceLoader) {
                ZkSolrResourceLoader zkLoader = (ZkSolrResourceLoader)loader;
                StringWriter sw = new StringWriter();
                try {
                    this.managedIndexSchema.persist(sw);
                }
                catch (IOException e) {
                    log.info("race condition ");
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "unable to serialize schema");
                }
                try {
                    ZkController.persistConfigResourceToZooKeeper(zkLoader, this.managedIndexSchema.getSchemaZkVersion(), this.managedIndexSchema.getResourceName(), sw.toString().getBytes(StandardCharsets.UTF_8), true);
                    this.waitForOtherReplicasToUpdate(timeout, startTime);
                    return Collections.emptyList();
                }
                catch (ZkController.ResourceModifiedInZkException e) {
                    log.info("Race condition schema modified by another node");
                    continue;
                }
                catch (Exception e) {
                    String s2 = "Exception persisting schema";
                    log.warn(s2, (Throwable)e);
                    return Collections.singletonList(s2 + e.getMessage());
                }
            }
            try {
                this.managedIndexSchema.persistManagedSchema(false);
                core.setLatestSchema(this.managedIndexSchema);
                return Collections.emptyList();
            }
            catch (ManagedIndexSchema.SchemaChangedInZkException e) {
                s = "Failed to update schema because schema is modified";
                log.warn(s, (Throwable)((Object)e));
            }
            catch (Exception e) {
                s = "Exception persisting schema";
                log.warn(s, (Throwable)e);
                return Collections.singletonList(s + e.getMessage());
            }
        }
        return Collections.singletonList("Unable to persist schema");
    }

    private void waitForOtherReplicasToUpdate(int timeout, long startTime) {
        CoreDescriptor cd;
        String collection;
        if (timeout > 0 && this.managedIndexSchema.getResourceLoader() instanceof ZkSolrResourceLoader && (collection = (cd = this.req.getCore().getCoreDescriptor()).getCollectionName()) != null) {
            ZkSolrResourceLoader zkLoader = (ZkSolrResourceLoader)this.managedIndexSchema.getResourceLoader();
            long timeLeftSecs = (long)timeout - TimeUnit.SECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
            if (timeLeftSecs <= 0L) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Not enough time left to update replicas. However, the schema is updated already.");
            }
            ManagedIndexSchema.waitForSchemaZkVersionAgreement(collection, cd.getCloudDescriptor().getCoreNodeName(), this.managedIndexSchema.getSchemaZkVersion(), zkLoader.getZkController(), (int)timeLeftSecs);
        }
    }

    public static String getErrorStr(Exception e) {
        StringBuilder sb = new StringBuilder();
        Throwable cause = e;
        for (int i = 0; i < 5; ++i) {
            sb.append(cause.getMessage()).append("\n");
            if (cause.getCause() == null || cause.getCause() == cause) break;
            cause = cause.getCause();
        }
        return sb.toString();
    }

    public ManagedIndexSchema getFreshManagedSchema() throws IOException, KeeperException, InterruptedException {
        SolrResourceLoader resourceLoader = this.req.getCore().getResourceLoader();
        if (resourceLoader instanceof ZkSolrResourceLoader) {
            InputStream in = resourceLoader.openResource(this.req.getSchema().getResourceName());
            if (in instanceof ZkSolrResourceLoader.ZkByteArrayInputStream) {
                int version = ((ZkSolrResourceLoader.ZkByteArrayInputStream)in).getStat().getVersion();
                log.info("managed schema loaded . version : {} ", (Object)version);
                return new ManagedIndexSchema(this.req.getCore().getSolrConfig(), this.req.getSchema().getResourceName(), new InputSource(in), true, this.req.getSchema().getResourceName(), version, this.req.getSchema().getSchemaUpdateLock());
            }
            return (ManagedIndexSchema)this.req.getCore().getLatestSchema();
        }
        return (ManagedIndexSchema)this.req.getCore().getLatestSchema();
    }

    public static enum OpType {
        ADD_FIELD_TYPE("add-field-type"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String name = op.getStr("name");
                String className = op.getStr("class");
                if (op.hasError()) {
                    return false;
                }
                try {
                    FieldType fieldType = mgr.managedIndexSchema.newFieldType(name, className, op.getDataMap());
                    mgr.managedIndexSchema = mgr.managedIndexSchema.addFieldTypes((List)Collections.singletonList(fieldType), false);
                    return true;
                }
                catch (Exception e) {
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        ADD_COPY_FIELD("add-copy-field"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String src = op.getStr("source");
                List<String> dests = op.getStrs("dest");
                if (op.hasError()) {
                    return false;
                }
                if (!op.getValuesExcluding("source", "dest").isEmpty()) {
                    op.addError("Only the 'source' and 'dest' params are allowed with the 'add-copy-field' operation");
                    return false;
                }
                try {
                    mgr.managedIndexSchema = mgr.managedIndexSchema.addCopyFields(Collections.singletonMap(src, dests), false);
                    return true;
                }
                catch (Exception e) {
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        ADD_FIELD("add-field"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String name = op.getStr("name");
                String type = op.getStr("type");
                if (op.hasError()) {
                    return false;
                }
                FieldType ft = mgr.managedIndexSchema.getFieldTypeByName(type);
                if (ft == null) {
                    op.addError("No such field type '" + type + "'");
                    return false;
                }
                try {
                    SchemaField field = SchemaField.create(name, ft, op.getValuesExcluding("name", "type"));
                    mgr.managedIndexSchema = mgr.managedIndexSchema.addFields(Collections.singletonList(field), Collections.EMPTY_MAP, false);
                    return true;
                }
                catch (Exception e) {
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        ADD_DYNAMIC_FIELD("add-dynamic-field"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String name = op.getStr("name");
                String type = op.getStr("type");
                if (op.hasError()) {
                    return false;
                }
                FieldType ft = mgr.managedIndexSchema.getFieldTypeByName(type);
                if (ft == null) {
                    op.addError("No such field type '" + type + "'");
                    return false;
                }
                try {
                    SchemaField field = SchemaField.create(name, ft, op.getValuesExcluding("name", "type"));
                    mgr.managedIndexSchema = mgr.managedIndexSchema.addDynamicFields(Collections.singletonList(field), Collections.EMPTY_MAP, false);
                    return true;
                }
                catch (Exception e) {
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        DELETE_FIELD_TYPE("delete-field-type"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String name = op.getStr("name");
                if (op.hasError()) {
                    return false;
                }
                if (!op.getValuesExcluding("name").isEmpty()) {
                    op.addError("Only the 'name' param is allowed with the 'delete-field-type' operation");
                    return false;
                }
                try {
                    mgr.managedIndexSchema = mgr.managedIndexSchema.deleteFieldTypes(Collections.singleton(name));
                    return true;
                }
                catch (Exception e) {
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        DELETE_COPY_FIELD("delete-copy-field"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String source = op.getStr("source");
                List<String> dests = op.getStrs("dest");
                if (op.hasError()) {
                    return false;
                }
                if (!op.getValuesExcluding("source", "dest").isEmpty()) {
                    op.addError("Only the 'source' and 'dest' params are allowed with the 'delete-copy-field' operation");
                    return false;
                }
                try {
                    mgr.managedIndexSchema = mgr.managedIndexSchema.deleteCopyFields(Collections.singletonMap(source, dests));
                    return true;
                }
                catch (Exception e) {
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        DELETE_FIELD("delete-field"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String name = op.getStr("name");
                if (op.hasError()) {
                    return false;
                }
                if (!op.getValuesExcluding("name").isEmpty()) {
                    op.addError("Only the 'name' param is allowed with the 'delete-field' operation");
                    return false;
                }
                try {
                    mgr.managedIndexSchema = mgr.managedIndexSchema.deleteFields(Collections.singleton(name));
                    return true;
                }
                catch (Exception e) {
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        DELETE_DYNAMIC_FIELD("delete-dynamic-field"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String name = op.getStr("name");
                if (op.hasError()) {
                    return false;
                }
                if (!op.getValuesExcluding("name").isEmpty()) {
                    op.addError("Only the 'name' param is allowed with the 'delete-dynamic-field' operation");
                    return false;
                }
                try {
                    mgr.managedIndexSchema = mgr.managedIndexSchema.deleteDynamicFields(Collections.singleton(name));
                    return true;
                }
                catch (Exception e) {
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        REPLACE_FIELD_TYPE("replace-field-type"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String name = op.getStr("name");
                String className = op.getStr("class");
                if (op.hasError()) {
                    return false;
                }
                try {
                    mgr.managedIndexSchema = mgr.managedIndexSchema.replaceFieldType(name, className, (Map)op.getDataMap());
                    return true;
                }
                catch (Exception e) {
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        REPLACE_FIELD("replace-field"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String name = op.getStr("name");
                String type = op.getStr("type");
                if (op.hasError()) {
                    return false;
                }
                FieldType ft = mgr.managedIndexSchema.getFieldTypeByName(type);
                if (ft == null) {
                    op.addError("No such field type '" + type + "'");
                    return false;
                }
                try {
                    mgr.managedIndexSchema = mgr.managedIndexSchema.replaceField(name, ft, (Map)op.getValuesExcluding("name", "type"));
                    return true;
                }
                catch (Exception e) {
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        }
        ,
        REPLACE_DYNAMIC_FIELD("replace-dynamic-field"){

            @Override
            public boolean perform(CommandOperation op, SchemaManager mgr) {
                String name = op.getStr("name");
                String type = op.getStr("type");
                if (op.hasError()) {
                    return false;
                }
                FieldType ft = mgr.managedIndexSchema.getFieldTypeByName(type);
                if (ft == null) {
                    op.addError("No such field type '" + type + "'");
                    return false;
                }
                try {
                    mgr.managedIndexSchema = mgr.managedIndexSchema.replaceDynamicField(name, ft, op.getValuesExcluding("name", "type"));
                    return true;
                }
                catch (Exception e) {
                    op.addError(SchemaManager.getErrorStr(e));
                    return false;
                }
            }
        };


        public abstract boolean perform(CommandOperation var1, SchemaManager var2);

        public static OpType get(String label) {
            return Nested.OP_TYPES.get(label);
        }

        private OpType(String label) {
            Nested.OP_TYPES.put(label, this);
        }

        private static class Nested {
            static final Map<String, OpType> OP_TYPES = new HashMap<String, OpType>();

            private Nested() {
            }
        }
    }
}

